/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.MasterPasswordFileManager;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import org.glassfish.security.common.FileRealmHelper;

public class DomainSecurity
extends MasterPasswordFileManager {
    private static final StringManager _strMgr = StringManager.getManager(DomainSecurity.class);

    void processAdminKeyFile(File keyFile, String user, String password) throws IOException {
        String keyFilePath = keyFile.getAbsolutePath();
        FileRealmHelper fileRealm = new FileRealmHelper(keyFilePath);
        String[] group2 = new String[]{"asadmin"};
        fileRealm.addUser(user, password.toCharArray(), group2);
        fileRealm.persist();
    }

    void createPasswordAliasKeystore(File pwFile, String password) throws RepositoryException {
        try {
            PasswordAdapter p = new PasswordAdapter(pwFile.getAbsolutePath(), password.toCharArray());
            p.writeStore();
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("passwordAliasKeystoreNotCreated", pwFile), ex);
        }
    }

    void createSSLCertificateDatabase(File configDir, DomainConfig config, String masterPassword) throws RepositoryException {
        this.createKeyStore(new File(configDir, "keystore.jks"), config, masterPassword);
        this.changeKeystorePassword("changeit", masterPassword, new File(configDir, "cacerts.jks"));
        this.copyCertificates(configDir, config, masterPassword);
    }

    void changeMode(String args, File file) throws IOException {
        super.chmod(args, file);
    }
}

