/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.StopDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-domain")
@PerLookup
public class RestartDomainCommand
extends StopDomainCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private ServiceLocator habitat;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartDomainCommand.class);

    @Override
    protected void doCommand() throws CommandException {
        if (!this.isRestartable()) {
            throw new CommandException(Strings.get("restartDomain.notRestartable"));
        }
        long uptimeOldServer = this.getUptime();
        RemoteCLICommand cmd = new RemoteCLICommand("restart-domain", this.programOpts, this.env);
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long stamp = -1L;
        if (pwFile != null) {
            stamp = pwFile.lastModified();
        }
        if (this.debug != null) {
            cmd.executeAndReturnOutput("restart-domain", "--debug", this.debug.toString());
        } else {
            cmd.executeAndReturnOutput("restart-domain");
        }
        this.waitForRestart(pwFile, stamp, uptimeOldServer);
        logger.info(strings.get("restartDomain.success"));
    }

    @Override
    protected int dasNotRunning(boolean local) throws CommandException {
        if (!local) {
            throw new CommandException(Strings.get("restart.dasNotRunningNoRestart"));
        }
        logger.warning(strings.get("restart.dasNotRunning"));
        CLICommand cmd = this.habitat.getService(CLICommand.class, "start-domain", new Annotation[0]);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-domain");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.domainDirParam != null) {
            opts.add("--domaindir");
            opts.add(this.domainDirParam);
        }
        if (this.getDomainName() != null) {
            opts.add(this.getDomainName());
        }
        return cmd.execute(opts.toArray(new String[opts.size()]));
    }
}

