/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.FileValidator;
import com.sun.enterprise.admin.servermgmt.MasterPasswordFileManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryNameValidator;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.security.common.FileRealmHelper;

public class RepositoryManager
extends MasterPasswordFileManager {
    protected static final String CERTUTIL_CMD = System.getProperty("com.sun.aas.nssBin") + "/certutil";
    protected static final String NEW_LINE = System.getProperty("line.separator");
    private static final StringManager _strMgr = StringManager.getManager(RepositoryManager.class);
    protected RepositoryManagerMessages _messages = null;
    public static final String DEBUG = "Debug";

    public RepositoryManager() {
        this.setMessages(new RepositoryManagerMessages(StringManager.getManager(PEDomainsManager.class), "illegalDomainName", "domainName", "domainsRoot", "domainExists", "domainDoesntExist", "domainDirNotValid", "cannotDeleteDomainDir", "invalidDomainDir", "listDomainElement", "cannotDeleteInstance_invalidState", "instanceStartupException", "cannotStartInstance_invalidState", "startInstanceTimeOut", "portConflict", "startupFailed", "cannotStopInstance_invalidState", "cannotStopInstance", "timeoutStarting"));
    }

    protected void setMessages(RepositoryManagerMessages messages) {
        this._messages = messages;
    }

    protected RepositoryManagerMessages getMessages() {
        return this._messages;
    }

    protected void generateFromTemplate(TokenValueSet tokens, File template, File destinationFile) throws IOException {
        LineTokenReplacer replacer = new LineTokenReplacer(tokens, "UTF-8");
        replacer.replace(template, destinationFile);
    }

    protected boolean repositoryExists(RepositoryConfig config) {
        return FileUtils.safeGetCanonicalFile(this.getRepositoryDir(config)).exists();
    }

    protected boolean isValidRepository(File f) {
        return new File(new File(f, "config"), "domain.xml").exists();
    }

    protected boolean isValidRepository(RepositoryConfig config) {
        return this.getFileLayout(config).getDomainConfigFile().exists();
    }

    protected File getRepositoryDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryDir();
    }

    protected File getRepositoryRootDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryRootDir();
    }

    protected void checkRepository(RepositoryConfig config) throws RepositoryException {
        this.checkRepository(config, true, true);
    }

    public void checkRepository(RepositoryConfig config, boolean existingRepository) throws RepositoryException {
        this.checkRepository(config, existingRepository, true);
    }

    public void checkRepository(RepositoryConfig config, boolean existingRepository, boolean checkRootDir) throws RepositoryException {
        String repositoryName = config.getDisplayName();
        new RepositoryNameValidator(this.getMessages().getRepositoryNameMessage()).validate(repositoryName);
        if (checkRootDir || existingRepository) {
            new FileValidator(this.getMessages().getRepositoryRootMessage(), "drw").validate(config.getRepositoryRoot());
        }
        new FileValidator(_strMgr.getString("installRoot"), "dr").validate(config.getInstallRoot());
        if (existingRepository) {
            if (!this.repositoryExists(config)) {
                if (Boolean.getBoolean(DEBUG)) {
                    throw new RepositoryException(this.getMessages().getNoExistsMessage(repositoryName, this.getBigNoExistsMessage(config)));
                }
                throw new RepositoryException(this.getMessages().getNoExistsMessage(repositoryName, this.getRepositoryDir(config).getAbsolutePath()));
            }
            if (!this.isValidRepository(config)) {
                throw new RepositoryException(this.getMessages().getRepositoryNotValidMessage(this.getRepositoryDir(config).getAbsolutePath()));
            }
        } else if (this.repositoryExists(config)) {
            throw new RepositoryException(this.getMessages().getExistsMessage(repositoryName, this.getRepositoryRootDir(config).getAbsolutePath()));
        }
    }

    private String getBigNoExistsMessage(RepositoryConfig config) {
        File repdir = this.getRepositoryDir(config);
        File canrepdir = FileUtils.safeGetCanonicalFile(repdir);
        File canrepdirparent = canrepdir.getParentFile();
        String s = "";
        s = s + "\nRep. Dir:" + repdir;
        s = s + "\nDump of RepositoryConfig: " + config.toString();
        s = s + "\nCanonical File: " + canrepdir;
        s = s + "\nParent File: " + canrepdirparent;
        boolean regex = repdir.exists();
        boolean canex = canrepdir.exists();
        boolean parentex = canrepdirparent.exists();
        boolean regdir = repdir.isDirectory();
        boolean candir = canrepdir.isDirectory();
        boolean parentdir = canrepdirparent.isDirectory();
        s = s + "\nrepdir exists: " + regex + ", canon exists: " + canex + ", parent exists: " + parentex + ", reg is dir: " + regdir + ", canon isdir: " + candir + ", parent is dir: " + parentdir;
        s = s + "\nInstance root sys property (";
        s = s + "com.sun.aas.instanceRoot";
        s = s + "): ";
        s = s + System.getProperty("com.sun.aas.instanceRoot");
        return s;
    }

    protected void setPermissions(RepositoryConfig repositoryConfig) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(repositoryConfig);
        File domainDir = layout.getRepositoryDir();
        try {
            this.chmod("-R 755", domainDir);
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("setPermissionError"), e);
        }
    }

    protected void deleteRepository(RepositoryConfig config) throws RepositoryException {
        this.deleteRepository(config, true);
    }

    protected void deleteRepository(RepositoryConfig config, boolean deleteJMSProvider) throws RepositoryException {
        this.checkRepository(config, true);
        File repository = this.getRepositoryDir(config);
        try {
            FileUtils.liquidate(repository);
        }
        catch (Exception e) {
            throw new RepositoryException(this.getMessages().getCannotDeleteMessage(repository.getAbsolutePath()), e);
        }
        if (this.repositoryExists(config)) {
            throw new RepositoryException(this.getMessages().getCannotDeleteMessage(repository.getAbsolutePath()));
        }
    }

    protected String[] listRepository(RepositoryConfig config) throws RepositoryException {
        String[] dirs;
        File repository = this.getRepositoryRootDir(config);
        try {
            File f = repository.getCanonicalFile();
            if (!f.isDirectory()) {
                throw new RepositoryException(this.getMessages().getInvalidPathMessage(f.getAbsolutePath()));
            }
            dirs = f.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir2, String name) {
                    File f = new File(dir2, name);
                    if (!f.isDirectory()) {
                        return false;
                    }
                    return RepositoryManager.this.isValidRepository(f);
                }
            });
            if (dirs == null) {
                dirs = new String[]{};
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return dirs;
    }

    protected RepositoryConfig getConfigForRepositoryStatus(RepositoryConfig config, String repository) {
        return new RepositoryConfig(repository, config.getRepositoryRoot());
    }

    protected void createAdminKeyFile(RepositoryConfig config, String user, String clearPwd) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getKeyFileTemplate();
        File dest = layout.getAdminKeyFile();
        try {
            FileUtils.copy(src, dest);
            this.modifyKeyFile(dest, user, clearPwd);
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("keyFileNotCreated"), e);
        }
    }

    protected void createKeyFile(RepositoryConfig config, String user, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getKeyFileTemplate();
        File dest = layout.getKeyFile();
        try {
            FileUtils.copy(src, dest);
        }
        catch (Exception e) {
            throw new RepositoryException(_strMgr.getString("keyFileNotCreated"), e);
        }
    }

    private void modifyKeyFile(File keyFile, String user, String password) throws IOException {
        String keyFilePath = keyFile.getAbsolutePath();
        FileRealmHelper fileRealm = new FileRealmHelper(keyFilePath);
        String[] group2 = new String[]{"asadmin"};
        fileRealm.addUser(user, password.toCharArray(), group2);
        fileRealm.persist();
    }

    protected void createServerPolicyFile(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getPolicyFileTemplate();
        File dest = layout.getPolicyFile();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("serverPolicyNotCreated"), ioe);
        }
    }

    public void validateMasterPassword(RepositoryConfig config, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
        }
        catch (IOException ex) {
            throw new RepositoryException(_strMgr.getString("masterPasswordInvalid"));
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("couldNotValidateMasterPassword", passwordAliases), ex);
        }
    }

    public String getClearPasswordForAlias(RepositoryConfig config, String password, String alias) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
            String clearPwd = p.getPasswordForAlias(alias);
            return clearPwd;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void createPasswordAliasKeystore(RepositoryConfig config, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
            p.writeStore();
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("passwordAliasKeystoreNotCreated", passwordAliases), ex);
        }
    }

    protected void changePasswordAliasKeystorePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        if (passwordAliases.exists()) {
            try {
                PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), oldPassword.toCharArray());
                p.changePassword(newPassword.toCharArray());
            }
            catch (Exception ex) {
                throw new RepositoryException(_strMgr.getString("passwordAliasPasswordNotChanged", passwordAliases), ex);
            }
        }
    }

    protected void createJBIInstance(String instanceName, RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        layout.createJBIDirectories();
        TokenValueSet tvSet = new TokenValueSet();
        String tvDelimiter = "@";
        String tJbiInstanceName = "JBI_INSTANCE_NAME";
        String tJbiInstanceRoot = "JBI_INSTANCE_ROOT";
        try {
            TokenValue tvJbiInstanceName = new TokenValue("JBI_INSTANCE_NAME", instanceName, "@");
            TokenValue tvJbiInstanceRoot = new TokenValue("JBI_INSTANCE_ROOT", layout.getRepositoryDir().getCanonicalPath(), "@");
            tvSet.add(tvJbiInstanceName);
            tvSet.add(tvJbiInstanceRoot);
            File src = layout.getJbiTemplateFile();
            File dest = layout.getJbiRegistryFile();
            this.generateFromTemplate(tvSet, src, dest);
            File httpConfigSrc = layout.getHttpBcConfigTemplate();
            File httpConfigDest = layout.getHttpBcConfigFile();
            TokenValueSet httpTvSet = new TokenValueSet();
            this.generateFromTemplate(httpTvSet, httpConfigSrc, httpConfigDest);
            this.createHttpBCInstallRoot(layout);
            this.createJavaEESEInstallRoot(layout);
            this.createWSDLSLInstallRoot(layout);
        }
        catch (Exception ioe) {
            throw new RepositoryException(_strMgr.getString("jbiRegistryFileNotCreated"), ioe);
        }
    }

    public void createHttpBCInstallRoot(PEFileLayout layout) throws Exception {
        FileUtils.copy(layout.getHttpBcArchiveSource(), layout.getHttpBcArchiveDestination());
        ZipFile zf = new ZipFile(layout.getHttpBcArchiveSource(), layout.getHttpBcInstallRoot());
        zf.explode();
    }

    public void createJavaEESEInstallRoot(PEFileLayout layout) throws Exception {
        FileUtils.copy(layout.getJavaEESEArchiveSource(), layout.getJavaEESEArchiveDestination());
        ZipFile zf = new ZipFile(layout.getJavaEESEArchiveSource(), layout.getJavaEESEInstallRoot());
        zf.explode();
    }

    public void createWSDLSLInstallRoot(PEFileLayout layout) throws Exception {
        FileUtils.copy(layout.getWSDLSLArchiveSource(), layout.getWSDLSLArchiveDestination());
        ZipFile zf = new ZipFile(layout.getWSDLSLArchiveSource(), layout.getWSDLSLInstallRoot());
        zf.explode();
    }

    protected void createMQInstance(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File broker = layout.getImqBrokerExecutable();
        File mqVarHome = layout.getImqVarHome();
        try {
            FileUtils.mkdirsMaybe(mqVarHome);
            ArrayList<String> cmdInput = new ArrayList<String>();
            cmdInput.add(broker.getAbsolutePath());
            cmdInput.add("-init");
            cmdInput.add("-varhome");
            cmdInput.add(mqVarHome.getAbsolutePath());
            ProcessExecutor pe = new ProcessExecutor(cmdInput.toArray(new String[cmdInput.size()]));
            pe.execute(false, false);
        }
        catch (Exception ioe) {
            // empty catch block
        }
    }

    protected void createTimerWal(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTimerWalTemplate();
        File dest = layout.getTimerWal();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("timerWalNotCreated"), ioe);
        }
    }

    protected void createTimerDbn(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTimerDbnTemplate();
        File dest = layout.getTimerDbn();
        try {
            FileUtils.copy(src, dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("timerDbnNotCreated"), ioe);
        }
    }

    protected String[] getInteractiveOptions(String user, String password, String masterPassword, HashMap<Object, Object> extraPasswords) {
        int numKeys = extraPasswords == null ? 0 : extraPasswords.size();
        String[] options = new String[3 + numKeys];
        options[0] = user;
        options[1] = password;
        options[2] = masterPassword;
        if (extraPasswords != null) {
            int i = 3;
            for (Map.Entry<Object, Object> me : extraPasswords.entrySet()) {
                options[i++] = (String)me.getKey() + "=" + (String)me.getValue();
            }
        }
        return options;
    }

    public static boolean isNSSSupportAvailable() {
        File certUtilFile = null;
        certUtilFile = OS.isWindows() ? new File(CERTUTIL_CMD + ".exe") : new File(CERTUTIL_CMD);
        return certUtilFile.exists();
    }

    protected static class RepositoryManagerMessages {
        private StringManager _strMgr;
        private String _badNameMessage;
        private String _repositoryNameMessage;
        private String _repositoryRootMessage;
        private String _existsMessage;
        private String _noExistsMessage;
        private String _repositoryNotValidMessage;
        private String _cannotDeleteMessage;
        private String _invalidPathMessage;
        private String _listRepositoryElementMessage;
        private String _cannotDeleteInstance_invalidState;
        private String _instanceStartupExceptionMessage;
        private String _cannotStartInstance_invalidStateMessage;
        private String _startInstanceTimeOutMessage;
        private String _portConflictMessage;
        private String _startupFailedMessage;
        private String _cannotStopInstance_invalidStateMessage;
        private String _cannotStopInstanceMessage;
        private String _timeoutStartingMessage;
        private String _cannotDeleteJmsProviderInstance;

        public RepositoryManagerMessages(StringManager strMgr, String badNameMessage, String repositoryNameMessage, String repositoryRootMessage, String existsMessage, String noExistsMessage, String repositoryNotValidMessage, String cannotDeleteMessage, String invalidPathMessage, String listRepositoryElementMessage, String cannotDeleteInstance_invalidState, String instanceStartupExceptionMessage, String cannotStartInstance_invalidStateMessage, String startInstanceTimeOutMessage, String portConflictMessage, String startupFailedMessage, String cannotStopInstance_invalidStateMessage, String cannotStopInstanceMessage, String timeoutStartingMessage) {
            this._strMgr = strMgr;
            this._badNameMessage = badNameMessage;
            this._repositoryNameMessage = repositoryNameMessage;
            this._repositoryRootMessage = repositoryRootMessage;
            this._existsMessage = existsMessage;
            this._noExistsMessage = noExistsMessage;
            this._repositoryNotValidMessage = repositoryNotValidMessage;
            this._cannotDeleteMessage = cannotDeleteMessage;
            this._invalidPathMessage = invalidPathMessage;
            this._listRepositoryElementMessage = listRepositoryElementMessage;
            this._cannotDeleteInstance_invalidState = cannotDeleteInstance_invalidState;
            this._instanceStartupExceptionMessage = instanceStartupExceptionMessage;
            this._cannotStartInstance_invalidStateMessage = cannotStartInstance_invalidStateMessage;
            this._startInstanceTimeOutMessage = startInstanceTimeOutMessage;
            this._portConflictMessage = portConflictMessage;
            this._startupFailedMessage = startupFailedMessage;
            this._cannotStopInstance_invalidStateMessage = cannotStopInstance_invalidStateMessage;
            this._cannotStopInstanceMessage = cannotStopInstanceMessage;
            this._timeoutStartingMessage = timeoutStartingMessage;
        }

        public String getRepositoryNameMessage() {
            return this._strMgr.getString(this._repositoryNameMessage);
        }

        public String getBadNameMessage(String repositoryName) {
            return this._strMgr.getString(this._badNameMessage, repositoryName);
        }

        public String getRepositoryRootMessage() {
            return this._strMgr.getString(this._repositoryRootMessage);
        }

        public String getNoExistsMessage(String repositoryName, String repositoryLocation) {
            return this._strMgr.getString(this._noExistsMessage, repositoryName, repositoryLocation);
        }

        public String getExistsMessage(String repositoryName, String repositoryLocation) {
            return this._strMgr.getString(this._existsMessage, repositoryName, repositoryLocation);
        }

        public String getRepositoryNotValidMessage(String path) {
            return this._strMgr.getString(this._repositoryNotValidMessage, path);
        }

        public String getCannotDeleteMessage(String repositoryName) {
            return this._strMgr.getString(this._cannotDeleteMessage, repositoryName);
        }

        public String getInvalidPathMessage(String path) {
            return this._strMgr.getString(this._invalidPathMessage, path);
        }

        public String getListRepositoryElementMessage(String repositoryName, String repositoryStatus) {
            return this._strMgr.getString(this._listRepositoryElementMessage, repositoryName, repositoryStatus);
        }

        public String getCannotDeleteInstanceInvalidState(String name, String state) {
            return this._strMgr.getString(this._cannotDeleteInstance_invalidState, name, state);
        }

        public String getInstanceStartupExceptionMessage(String name) {
            return this._strMgr.getString(this._instanceStartupExceptionMessage, name);
        }

        public String getCannotStartInstanceInvalidStateMessage(String name, String state) {
            return this._strMgr.getString(this._cannotStartInstance_invalidStateMessage, name, state);
        }

        public String getStartInstanceTimeOutMessage(String name) {
            return this._strMgr.getString(this._startInstanceTimeOutMessage, name);
        }

        public String getStartupFailedMessage(String name) {
            return this._strMgr.getString(this._startupFailedMessage, name);
        }

        public String getStartupFailedMessage(String name, int port) {
            if (port != 0) {
                return this._strMgr.getString(this._portConflictMessage, new Object[]{name, String.valueOf(port)});
            }
            return this._strMgr.getString(this._startupFailedMessage, name);
        }

        public String getCannotStopInstanceInvalidStateMessage(String name, String state) {
            return this._strMgr.getString(this._cannotStopInstance_invalidStateMessage, name, state);
        }

        public String getCannotStopInstanceMessage(String name) {
            return this._strMgr.getString(this._cannotStopInstanceMessage, name);
        }

        public String getTimeoutStartingMessage(String name) {
            return this._strMgr.getString(this._timeoutStartingMessage, name);
        }
    }
}

