/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class KeystoreManager {
    private static final String KEYTOOL_CMD;
    private static final String KEYTOOL_EXE_NAME;
    private static String CERTIFICATE_DN_PREFIX;
    private static String CERTIFICATE_DN_SUFFIX;
    public static final String CERTIFICATE_ALIAS = "s1as";
    public static final String INSTANCE_SECURE_ADMIN_ALIAS = "glassfish-instance";
    public static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SKID_EXTENSION_SYSTEM_PROPERTY = "-J-Dsun.security.internal.keytool.skid";
    private static final String INSTANCE_CN_SUFFIX = "-instance";
    protected PEFileLayout _fileLayout = null;
    private static final StringManager _strMgr;

    protected static String getCertificateDN(RepositoryConfig cfg, String CNSuffix) {
        String cn = KeystoreManager.getCNFromCfg(cfg);
        if (cn == null) {
            try {
                cn = NetUtils.getCanonicalHostName();
            }
            catch (Exception e) {
                cn = "localhost";
            }
        }
        String x509DistinguishedName = CERTIFICATE_DN_PREFIX + cn + (CNSuffix != null ? CNSuffix : "") + CERTIFICATE_DN_SUFFIX;
        return x509DistinguishedName;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this._fileLayout == null) {
            this._fileLayout = new PEFileLayout(config);
        }
        return this._fileLayout;
    }

    protected void createSSLCertificateDatabase(RepositoryConfig config, String masterPassword) {
        try {
            PEFileLayout layout = this.getFileLayout(config);
            File keystore = layout.getKeyStore();
            this.createKeyStore(keystore, config, masterPassword);
            this.createTrustStore(config, masterPassword);
        }
        catch (RepositoryException re) {
            String msg = _strMgr.getString("SomeProblemWithKeytool", re.getMessage());
            System.err.println(msg);
            try {
                PEFileLayout lo = this.getFileLayout(config);
                File src = lo.getKeyStoreTemplate();
                File dest = lo.getKeyStore();
                FileUtils.copy(src, dest);
                src = lo.getTrustStoreTemplate();
                dest = lo.getTrustStore();
                FileUtils.copy(src, dest);
            }
            catch (Exception e) {
                SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0000", e);
            }
        }
    }

    protected void createKeyStore(File keystore, RepositoryConfig config, String masterPassword) throws RepositoryException {
        String dasCertDN = KeystoreManager.getDASCertDN(config);
        System.out.println(_strMgr.getString("CertificateDN", dasCertDN));
        this.addSelfSignedCertToKeyStore(keystore, CERTIFICATE_ALIAS, masterPassword, dasCertDN);
        String instanceCertDN = KeystoreManager.getInstanceCertDN(config);
        System.out.println(_strMgr.getString("CertificateDN", instanceCertDN));
        this.addSelfSignedCertToKeyStore(keystore, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword, instanceCertDN);
    }

    private void addSelfSignedCertToKeyStore(File keystore, String alias, String masterPassword, String dn) throws RepositoryException {
        String[] keytoolCmd = new String[]{"-genkey", "-keyalg", "RSA", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-dname", dn, "-validity", "3650", "-keypass", masterPassword, "-storepass", masterPassword, SKID_EXTENSION_SYSTEM_PROPERTY};
        KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 60L);
        p.execute("keystoreNotCreated", keystore);
    }

    protected void createTrustStore(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTrustStoreTemplate();
        File truststore = layout.getTrustStore();
        try {
            FileUtils.copy(src, truststore);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("trustStoreNotCreated", truststore), ioe);
        }
        this.changeKeystorePassword(DEFAULT_MASTER_PASSWORD, masterPassword, truststore);
        this.copyCert(layout.getConfigRoot(), CERTIFICATE_ALIAS, masterPassword);
        this.copyCert(layout.getConfigRoot(), INSTANCE_SECURE_ADMIN_ALIAS, masterPassword);
    }

    protected void copyCertificates(File configRoot, DomainConfig config, String masterPassword) throws DomainException {
        try {
            this.copyCert(configRoot, CERTIFICATE_ALIAS, masterPassword);
            this.copyCert(configRoot, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword);
        }
        catch (RepositoryException re) {
            String msg = _strMgr.getString("SomeProblemWithKeytool", re.getMessage());
            throw new DomainException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCert(File configRoot, String alias, String masterPassword) throws RepositoryException {
        File keystore = new File(configRoot, "keystore.jks");
        File truststore = new File(configRoot, "cacerts.jks");
        File certFile = null;
        String[] input = new String[]{masterPassword};
        String[] keytoolCmd = null;
        KeytoolExecutor p = null;
        try {
            certFile = new File(configRoot, alias + ".cer");
            keytoolCmd = new String[]{"-export", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", truststore);
            keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", truststore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", truststore);
        }
        finally {
            boolean isCertFileDeleted;
            if (certFile != null && !(isCertFileDeleted = certFile.delete())) {
                SLogger.getLogger().log(Level.WARNING, "SERVERMGMT0001", certFile.getAbsolutePath());
            }
        }
    }

    protected void changeKeystorePassword(String oldPassword, String newPassword, File keystore) throws RepositoryException {
        if (!oldPassword.equals(newPassword)) {
            String[] keytoolCmd = new String[]{"-storepasswd", "-keystore", keystore.getAbsolutePath()};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{oldPassword, newPassword, newPassword});
            p.execute("keyStorePasswordNotChanged", keystore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeS1ASAliasPassword(RepositoryConfig config, String storePassword, String oldKeyPassword, String newKeyPassword) throws RepositoryException {
        if (!storePassword.equals(oldKeyPassword) && !oldKeyPassword.equals(newKeyPassword)) {
            PEFileLayout layout = this.getFileLayout(config);
            File keystore = layout.getKeyStore();
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
            if (keyStoreType == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            ArrayList<String> aliases = new ArrayList<String>();
            FileInputStream is = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                is = new FileInputStream(keystore);
                keyStore.load(is, storePassword.toCharArray());
                Enumeration<String> all = keyStore.aliases();
                while (all.hasMoreElements()) {
                    aliases.add(all.nextElement());
                }
            }
            catch (Exception e) {
                aliases.add(CERTIFICATE_ALIAS);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0000", ex);
                    }
                }
            }
            String[] keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword});
            try {
                p.execute("s1asKeyPasswordNotChanged", keystore);
            }
            catch (RepositoryException ex) {
                return;
            }
            for (String alias : aliases) {
                keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", alias};
                p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
                p.execute("s1asKeyPasswordNotChanged", keystore);
            }
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        File truststore = layout.getTrustStore();
        if (keystore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, keystore);
            try {
                this.changeS1ASAliasPassword(config, newPassword, oldPassword, newPassword);
            }
            catch (Exception ex) {
                SLogger.getLogger().log(Level.SEVERE, "SERVERMGMT0000", ex);
            }
        }
        if (truststore.exists()) {
            this.changeKeystorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OS.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException(_strMgr.getString("nullArg"));
            }
            if (!file.exists()) {
                throw new IOException(_strMgr.getString("fileNotFound"));
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            cmdList.addAll(Arrays.asList(argsString));
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    public static String getDASCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, null);
    }

    public static String getInstanceCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, INSTANCE_CN_SUFFIX);
    }

    private static String getCNFromCfg(RepositoryConfig cfg) {
        String option = (String)cfg.get("keytooloptions");
        if (option == null || option.length() == 0) {
            return null;
        }
        String value = KeystoreManager.getCNFromOption(option);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private static String getValueFromOptionForName(String option, String name, boolean ignoreNameCase) {
        String[] pairs;
        Pattern p = Pattern.compile(":");
        for (String pair : pairs = p.split(option)) {
            boolean found;
            p = Pattern.compile("=");
            String[] nv = p.split(pair);
            String n = nv[0].trim();
            String v = nv[1].trim();
            boolean bl = found = ignoreNameCase ? n.equalsIgnoreCase(name) : n.equals(name);
            if (!found) continue;
            return v;
        }
        return null;
    }

    private static String getCNFromOption(String option) {
        return KeystoreManager.getValueFromOptionForName(option, "CN", true);
    }

    static {
        KEYTOOL_EXE_NAME = OS.isWindows() ? "keytool.exe" : "keytool";
        CERTIFICATE_DN_PREFIX = "CN=";
        CERTIFICATE_DN_SUFFIX = ",OU=GlassFish,O=Oracle Corporation,L=Santa Clara,ST=California,C=US";
        String nonFinalKeyTool = KEYTOOL_EXE_NAME;
        String propName = "com.sun.aas.javaRoot";
        String javaroot = new ASenvPropertyReader().getProps().get(propName);
        File k = new File(new File(javaroot, "bin"), KEYTOOL_EXE_NAME);
        if (k.canExecute()) {
            nonFinalKeyTool = SmartFile.sanitize(k.getPath());
        } else {
            k = ProcessUtils.getExe(KEYTOOL_EXE_NAME);
            if (k != null && k.canExecute()) {
                nonFinalKeyTool = k.getPath();
            }
        }
        KEYTOOL_CMD = nonFinalKeyTool;
        _strMgr = StringManager.getManager(KeystoreManager.class);
    }

    protected static class KeytoolExecutor
    extends ProcessExecutor {
        public KeytoolExecutor(String[] args, long timeoutInSeconds) {
            super(args, timeoutInSeconds);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        public KeytoolExecutor(String[] args, long timeoutInSeconds, String[] inputLines) {
            super(args, timeoutInSeconds, inputLines);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        @Override
        protected String getExceptionMessage() {
            return this.getLatestOutput(this.mOutFile) + " " + this.getFileBuffer(this.mErrFile);
        }

        private void addKeytoolCommand() {
            if (!this.mCmdStrings[0].equals(KEYTOOL_CMD)) {
                String[] newArgs = new String[this.mCmdStrings.length + 1];
                newArgs[0] = KEYTOOL_CMD;
                System.arraycopy(this.mCmdStrings, 0, newArgs, 1, this.mCmdStrings.length);
                this.mCmdStrings = newArgs;
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws RepositoryException {
            try {
                super.execute();
                if (this.getProcessExitValue() != 0) {
                    throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput());
                }
            }
            catch (ExecException ex) {
                throw new RepositoryException(_strMgr.getString(keystoreErrorMsg, keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput(), ex);
            }
        }
    }
}

