/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;

public class RestPayloadImpl
extends PayloadImpl {

    public static class Inbound
    extends PayloadImpl.Inbound {
        private List<Payload.Part> parts = new ArrayList<Payload.Part>();

        private void add(BodyPart bodyPart, String name) throws WebApplicationException {
            String mimeType = bodyPart.getMediaType().toString();
            MultivaluedMap<String, String> headers = bodyPart.getHeaders();
            Properties props = new Properties();
            for (String key : headers.keySet()) {
                props.setProperty(Inbound.removeContentPrefix(key), headers.getFirst(key));
            }
            Object entity = bodyPart.getEntity();
            if (entity == null) {
                this.parts.add(PayloadImpl.Part.newInstance(mimeType, name, props, (InputStream)null));
            } else if (entity instanceof BodyPartEntity) {
                BodyPartEntity bpe = (BodyPartEntity)entity;
                this.parts.add(PayloadImpl.Part.newInstance(mimeType, name, props, bpe.getInputStream()));
            } else if (entity instanceof String) {
                this.parts.add(PayloadImpl.Part.newInstance(mimeType, name, props, (String)entity));
            } else {
                throw new WebApplicationException((Throwable)new Exception("Unsupported entity " + entity.getClass().getName()), Response.Status.BAD_REQUEST);
            }
        }

        public static Inbound parseFromFormDataMultipart(FormDataMultiPart mp, ParameterMap paramMap) throws WebApplicationException {
            Inbound result = new Inbound();
            if (mp == null) {
                return result;
            }
            Map<String, List<FormDataBodyPart>> fields = mp.getFields();
            for (String fieldName : fields.keySet()) {
                for (FormDataBodyPart bodyPart : mp.getFields(fieldName)) {
                    if (bodyPart.isSimple()) {
                        if (paramMap == null) continue;
                        paramMap.add(bodyPart.getName(), bodyPart.getValue());
                        continue;
                    }
                    result.add(bodyPart, bodyPart.getName());
                }
            }
            return result;
        }

        public static ActionReport fillFromMultipart(MultiPart mp, Inbound inb, Logger logger2) throws WebApplicationException {
            if (logger2 == null) {
                logger2 = AdminLoggerInfo.getLogger();
            }
            if (mp == null) {
                return null;
            }
            if (inb == null) {
                inb = new Inbound();
            }
            ActionReport result = null;
            List<BodyPart> bodyParts = mp.getBodyParts();
            int index = 0;
            for (BodyPart bodyPart : bodyParts) {
                ++index;
                String name = "noname";
                ContentDisposition cd = bodyPart.getContentDisposition();
                if (cd != null && cd.getFileName() != null) {
                    name = cd.getFileName();
                }
                if (logger2.isLoggable(Level.FINER)) {
                    logger2.log(Level.FINER, "--------- BODY PART [{0}] ---------", index);
                    MultivaluedMap<String, String> headers = bodyPart.getHeaders();
                    for (Map.Entry entry : headers.entrySet()) {
                        for (String value : (List)entry.getValue()) {
                            logger2.log(Level.FINER, "{0}: {1}", new Object[]{entry.getKey(), value});
                        }
                    }
                }
                if (bodyPart.getMediaType().isCompatible(new MediaType("application", "json"))) {
                    if (logger2.isLoggable(Level.FINER)) {
                        String body = bodyPart.getEntityAs(String.class);
                        logger2.log(Level.FINER, body);
                    }
                    result = bodyPart.getEntityAs(ActionReport.class);
                } else {
                    logger2.log(Level.FINER, "   <<Content>>");
                    inb.add(bodyPart, name);
                }
                if (!logger2.isLoggable(Level.FINER)) continue;
                logger2.log(Level.FINER, "------- END BODY PART [{0}] -------", index);
            }
            return result;
        }

        private static String removeContentPrefix(String key) {
            if (key == null) {
                return null;
            }
            String lKey = key.toLowerCase(Locale.ENGLISH);
            if ("content-disposition".equals(lKey) || "content-type".equals(lKey) || "content-transfer-encoding".equals(lKey) || !lKey.startsWith("content-")) {
                return key;
            }
            return key.substring("content-".length());
        }

        @Override
        public Iterator<Payload.Part> parts() {
            return this.parts.iterator();
        }
    }

    public static class Outbound
    extends PayloadImpl.Outbound {
        private String complexType;
        private boolean client2Server;

        public Outbound(boolean client2Server) {
            this.client2Server = client2Server;
            this.complexType = client2Server ? "multipart/form-data" : "multipart/mixed";
        }

        @Override
        public String getComplexContentType() {
            return this.complexType;
        }

        @Override
        protected void writePartsTo(OutputStream os) throws IOException {
            throw new UnsupportedOperationException("Not supported for RestPauloadImpl.");
        }

        @Override
        public void writeTo(OutputStream os) throws IOException {
            throw new UnsupportedOperationException("Not supported for RestPauloadImpl.");
        }

        public MultiPart addToMultipart(MultiPart mp, Logger logger2) {
            if (mp == null) {
                if (this.client2Server) {
                    logger2.finest("addToMultipart: Creating FormDataMultiPart for result");
                    mp = new FormDataMultiPart();
                } else {
                    logger2.finest("addToMultipart: Creating MultiPart [mixed] for result");
                    mp = new MultiPart();
                }
            }
            ArrayList<Payload.Part> parts = this.getParts();
            if (logger2.isLoggable(Level.FINEST)) {
                logger2.log(Level.FINEST, "addToMultipart: parts.size = {0}", parts.size());
            }
            int index = 0;
            for (Payload.Part part : parts) {
                BodyPart bp;
                ++index;
                String contentType = part.getContentType();
                MediaType mt = new MediaType();
                if (contentType != null && !contentType.isEmpty()) {
                    int ind = contentType.indexOf(47);
                    mt = ind > -1 ? new MediaType(contentType.substring(0, ind), contentType.substring(ind + 1)) : new MediaType(contentType, "*/*");
                }
                if (logger2.isLoggable(Level.FINEST)) {
                    logger2.log(Level.FINEST, "addToMultipart[{0}]: name: {1}, type: {2}", new Object[]{index, part.getName(), mt});
                }
                if (this.client2Server) {
                    bp = new FormDataBodyPart(part.getName(), (Object)part, mt);
                } else {
                    bp = new BodyPart(part, mt);
                    Object cd = ((ContentDisposition.ContentDispositionBuilder)ContentDisposition.type("file").fileName(part.getName())).build();
                    if (logger2.isLoggable(Level.FINEST)) {
                        logger2.log(Level.FINEST, "addToMultipart[{0}]: Content Disposition: {1}", new Object[]{index, cd});
                    }
                    bp.setContentDisposition((ContentDisposition)cd);
                }
                Properties props = part.getProperties();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    if (logger2.isLoggable(Level.FINEST)) {
                        logger2.log(Level.FINEST, "addToMultipart[{0}]: Header: {1}: {2}", new Object[]{index, Outbound.addContentPrefix((String)entry.getKey()), entry.getValue()});
                    }
                    bp.getHeaders().add(Outbound.addContentPrefix((String)entry.getKey()), (String)entry.getValue());
                }
                mp.bodyPart(bp);
            }
            return mp;
        }

        private static String addContentPrefix(String key) {
            if (key == null) {
                return null;
            }
            String lKey = key.toLowerCase(Locale.ENGLISH);
            if ("content-disposition".equals(lKey) || "content-type".equals(lKey) || "content-transfer-encoding".equals(lKey)) {
                return key;
            }
            return "Content-" + key;
        }
    }
}

