/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GFLauncherLogger {
    public static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.admin.launcher.LogMessages";
    public static final String LOGGER_NAME = "javax.enterprise.launcher";
    private static final Logger logger;
    private static final LocalStringsImpl strings;
    private static FileHandler logfileHandler;
    public static final String NO_QUOTES_ALLOWED = "GFLAUNCHER-001";
    public static final String LAUNCH_FAILURE = "GFLAUNCHER-002";
    public static final String NO_FLASHLIGHT_AGENT = "GFLAUNCHER-003";
    public static final String copy_server_policy = "GFLAUNCHER-004";
    public static final String COMMAND_LINE = "GFLAUNCHER-005";

    public static void warning(String msg, Object ... objs) {
        logger.log(Level.WARNING, msg, objs);
    }

    public static void info(String msg, Object ... objs) {
        logger.log(Level.INFO, msg, objs);
    }

    public static void severe(String msg, Object ... objs) {
        logger.log(Level.SEVERE, msg, objs);
    }

    public static void fine(String msg, Object ... objs) {
        logger.fine(strings.get(msg, objs));
    }

    static synchronized void setConsoleLevel(Level level) {
        for (Handler h : logger.getHandlers()) {
            if (!ConsoleHandler.class.isAssignableFrom(h.getClass())) continue;
            h.setLevel(level);
        }
    }

    static synchronized void addLogFileHandler(String logFile, GFLauncherInfo info) throws GFLauncherException {
        try {
            if (logFile == null || logfileHandler != null) {
                return;
            }
            logfileHandler = new FileHandler(logFile, true);
            logfileHandler.setFormatter(new UniformLogFormatter());
            logfileHandler.setLevel(Level.INFO);
            logger.addHandler(logfileHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static synchronized void removeLogFileHandler() {
        if (logfileHandler != null) {
            logger.removeHandler(logfileHandler);
            logfileHandler.close();
            logfileHandler = null;
        }
    }

    private GFLauncherLogger() {
    }

    static {
        strings = new LocalStringsImpl(GFLauncherLogger.class);
        logger = Logger.getLogger(LOGGER_NAME, SHARED_LOGMESSAGE_RESOURCE);
        logger.setLevel(Level.INFO);
        logger.setUseParentHandlers(false);
        logger.addHandler(new ConsoleHandler());
    }
}

