/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.commands;

import com.sun.enterprise.admin.commands.SslConfigHandler;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-ssl")
@PerLookup
@I18n(value="delete.ssl")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteSsl
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteSsl.class);
    @Param(name="type", acceptableValues="network-listener, http-listener, iiop-listener, iiop-service, jmx-connector")
    public String type;
    @Param(name="listener_id", primary=true, optional=true)
    public String listenerId;
    @Param(name="target", optional=true, defaultValue="server")
    public String target;
    @Inject
    NetworkListeners networkListeners;
    @Inject
    @Named(value="default-instance-name")
    public Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Target targetUtil = this.habitat.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        if (!this.type.equals("iiop-service") && this.listenerId == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.listenerid.missing", "Listener id needs to be specified"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            SslConfigHandler sslConfigHandler = this.habitat.getService(SslConfigHandler.class, this.type, new Annotation[0]);
            if (sslConfigHandler != null) {
                sslConfigHandler.delete(this, report);
            } else if ("jmx-connector".equals(this.type)) {
                JmxConnector jmxConnector = null;
                for (JmxConnector listener : this.config.getAdminService().getJmxConnector()) {
                    if (!listener.getName().equals(this.listenerId)) continue;
                    jmxConnector = listener;
                }
                if (jmxConnector == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.jmx.connector.notfound", "Iiop Listener named {0} not found", this.listenerId));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (jmxConnector.getSsl() == null) {
                    report.setMessage(localStrings.getLocalString("delete.ssl.element.doesnotexist", "Ssl element does not exist for Listener named {0}", this.listenerId));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ConfigSupport.apply(new SingleConfigCode<JmxConnector>(){

                    @Override
                    public Object run(JmxConnector param) throws PropertyVetoException {
                        param.setSsl(null);
                        return null;
                    }
                }, jmxConnector);
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
    }

    public void reportError(ActionReport report, Exception e) {
        report.setMessage(localStrings.getLocalString("delete.ssl.fail", "Deletion of Ssl in {0} failed", this.listenerId));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause(e);
    }
}

