/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.commands;

import com.sun.enterprise.admin.commands.SslConfigHandler;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-ssl")
@PerLookup
@I18n(value="create.ssl")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=JmxConnector.class, opType=RestEndpoint.OpType.POST, path="create-ssl", description="create-ssl", params={@RestParam(name="id", value="$parent"), @RestParam(name="type", value="jmx-connector")}), @RestEndpoint(configBean=NetworkListener.class, opType=RestEndpoint.OpType.POST, path="create-ssl", description="create-ssl", params={@RestParam(name="id", value="$parent"), @RestParam(name="type", value="http-listener")})})
public class CreateSsl
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSsl.class);
    @Param(name="certname", alias="certNickname")
    String certName;
    @Param(name="type", acceptableValues="network-listener, http-listener, iiop-listener, iiop-service, jmx-connector")
    String type;
    @Param(name="ssl2Enabled", optional=true, defaultValue="false")
    Boolean ssl2Enabled;
    @Param(name="ssl2Ciphers", optional=true)
    String ssl2ciphers;
    @Param(name="ssl3Enabled", optional=true, defaultValue="true")
    Boolean ssl3Enabled;
    @Param(name="ssl3TlsCiphers", optional=true)
    String ssl3tlsciphers;
    @Param(name="tlsEnabled", optional=true, defaultValue="true")
    Boolean tlsenabled;
    @Param(name="tlsRollbackEnabled", optional=true, defaultValue="true")
    Boolean tlsrollbackenabled;
    @Param(name="clientAuthEnabled", optional=true, defaultValue="false")
    Boolean clientauthenabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="listener_id", primary=true, optional=true)
    public String listenerId;
    @Inject
    @Named(value="default-instance-name")
    public Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;
    private static final String GF_SSL_IMPL_NAME = "com.sun.enterprise.security.ssl.GlassfishSSLImpl";

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Target targetUtil = this.habitat.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        if (!"iiop-service".equals(this.type) && this.listenerId == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.listenerid.missing", "Listener id needs to be specified"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        SslConfigHandler configHandler = this.habitat.getService(SslConfigHandler.class, this.type, new Annotation[0]);
        if (configHandler != null) {
            configHandler.create(this, report);
        } else if ("jmx-connector".equals(this.type)) {
            this.addSslToJMXConnector(this.config, report);
        }
    }

    public void reportError(ActionReport report, TransactionFailure e) {
        report.setMessage(localStrings.getLocalString("create.ssl.fail", "Creation of Ssl in {0} failed", this.listenerId));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setFailureCause(e);
    }

    public void reportSuccess(ActionReport report) {
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public void populateSslElement(Ssl newSsl) {
        newSsl.setCertNickname(this.certName);
        newSsl.setClientAuthEnabled(this.clientauthenabled.toString());
        newSsl.setSsl2Ciphers(this.ssl2ciphers);
        newSsl.setSsl2Enabled(this.ssl2Enabled.toString());
        newSsl.setSsl3Enabled(this.ssl3Enabled.toString());
        newSsl.setSsl3TlsCiphers(this.ssl3tlsciphers);
        newSsl.setClassname(GF_SSL_IMPL_NAME);
        newSsl.setTlsEnabled(this.tlsenabled.toString());
        newSsl.setTlsRollbackEnabled(this.tlsrollbackenabled.toString());
    }

    public Protocol findOrCreateProtocol(final String name) throws TransactionFailure {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Protocol protocol = networkConfig.findProtocol(name);
        if (protocol == null) {
            protocol = (Protocol)ConfigSupport.apply(new SingleConfigCode<Protocols>(){

                @Override
                public Object run(Protocols param) throws TransactionFailure {
                    Protocol newProtocol = param.createChild(Protocol.class);
                    newProtocol.setName(name);
                    newProtocol.setSecurityEnabled("true");
                    param.getProtocol().add(newProtocol);
                    return newProtocol;
                }
            }, (ConfigBeanProxy)this.habitat.getService(Protocols.class, new Annotation[0]));
        }
        return protocol;
    }

    private void addSslToJMXConnector(Config config, ActionReport report) {
        AdminService adminService = config.getAdminService();
        JmxConnector jmxConnector = null;
        for (JmxConnector jmxConn : adminService.getJmxConnector()) {
            if (!jmxConn.getName().equals(this.listenerId)) continue;
            jmxConnector = jmxConn;
        }
        if (jmxConnector == null) {
            report.setMessage(localStrings.getLocalString("create.ssl.jmx.notfound", "JMX Connector named {0} to which this ssl element is being added does not exist.", this.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (jmxConnector.getSsl() != null) {
            report.setMessage(localStrings.getLocalString("create.ssl.jmx.alreadyExists", "IIOP Listener named {0} to which this ssl element is being added already has an ssl element.", this.listenerId));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<JmxConnector>(){

                @Override
                public Object run(JmxConnector param) throws PropertyVetoException, TransactionFailure {
                    Ssl newSsl = param.createChild(Ssl.class);
                    CreateSsl.this.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, jmxConnector);
        }
        catch (TransactionFailure e) {
            this.reportError(report, e);
        }
        this.reportSuccess(report);
    }
}

