/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.remote;

import com.sun.enterprise.admin.progress.ProgressStatusClient;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.CommandProgress;
import org.glassfish.api.admin.progress.ProgressStatusDTO;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

public class ProgressStatusPrinter
implements AdminCommandEventBroker.AdminCommandListener<GfSseInboundEvent> {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ProgressStatusPrinter.class);
    private static final char[] spinner = new char[]{'|', '/', '-', '\\'};
    private int lastPercentage = -1;
    private String lastMessage = "";
    private StringBuilder outMsg = new StringBuilder();
    private int lastSumSteps = -1;
    private int lastMsgLength = 0;
    private boolean firstPrint = true;
    private int spinnerIndex = -1;
    private Ticker ticker = null;
    private ProgressStatusClient client = new ProgressStatusClient(null);
    private CommandProgress commandProgress;
    private final boolean disableAnimation;
    private final boolean debugOutput;
    private final Logger logger;

    public ProgressStatusPrinter(boolean disableAnimation, boolean debugOutput, Logger logger2) {
        this.disableAnimation = disableAnimation;
        this.debugOutput = debugOutput;
        this.logger = logger2 == null ? Logger.getLogger(ProgressStatusPrinter.class.getName()) : logger2;
    }

    private synchronized boolean spin() {
        if (this.commandProgress == null || !this.commandProgress.isSpinnerActive() || this.debugOutput || this.lastMsgLength <= 1) {
            return false;
        }
        if (this.spinnerIndex >= 0 && !this.disableAnimation) {
            System.out.print("\b\b");
            this.lastMsgLength -= 2;
        }
        ++this.spinnerIndex;
        if (this.spinnerIndex >= spinner.length) {
            this.spinnerIndex = 0;
        }
        if (this.disableAnimation) {
            System.out.print('.');
            ++this.lastMsgLength;
        } else {
            System.out.print(spinner[this.spinnerIndex]);
            System.out.print(' ');
            this.lastMsgLength += 2;
        }
        return true;
    }

    @Override
    public synchronized void onAdminCommandEvent(String name, GfSseInboundEvent event) {
        try {
            if ("ProgressStatus/state".equals(name)) {
                ProgressStatusDTO dto = event.getData(ProgressStatusDTO.class, MediaType.APPLICATION_JSON_TYPE);
                this.client.mirror(dto);
                this.commandProgress = (CommandProgress)this.client.getProgressStatus();
                if (StringUtils.ok(this.commandProgress.getName()) && !StringUtils.ok(this.commandProgress.getLastMessage())) {
                    this.commandProgress.progress(strings.getString("progressstatus.message.starting", "Starting"));
                }
            } else if ("ProgressStatus/change".equals(name)) {
                if (this.commandProgress == null) {
                    this.logger.log(Level.WARNING, strings.get("progressstatus.event.applyerror", "Inapplicable progress status event"));
                    return;
                }
                ProgressStatusEvent pse = event.getData(ProgressStatusEvent.class, MediaType.APPLICATION_JSON_TYPE);
                this.client.mirror(pse);
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, strings.get("progressstatus.event.parseerror", "Can not parse progress status event"), ex);
        }
        if (this.commandProgress != null) {
            String message;
            this.outMsg.setLength(0);
            boolean printIt = false;
            int percentage = Math.round(this.commandProgress.computeCompletePortion() * 100.0f);
            if (percentage >= 0) {
                this.outMsg.append(percentage);
                switch (this.outMsg.length()) {
                    case 1: {
                        this.outMsg.insert(0, "  ");
                        break;
                    }
                    case 2: {
                        this.outMsg.insert(0, ' ');
                        break;
                    }
                }
                this.outMsg.append('%');
                if (percentage != this.lastPercentage) {
                    printIt = true;
                    this.lastPercentage = percentage;
                }
            } else {
                int sumSteps = this.commandProgress.computeSumSteps();
                this.outMsg.append(sumSteps);
                if (sumSteps > this.lastSumSteps) {
                    printIt = true;
                    this.lastSumSteps = sumSteps;
                }
            }
            if ((message = this.commandProgress.getLastMessage()) != null && message.length() > 0) {
                this.outMsg.append(": ");
                this.outMsg.append(message);
                if (!message.equals(this.lastMessage)) {
                    printIt = true;
                    this.lastMessage = message;
                }
            }
            if (printIt) {
                if (this.disableAnimation || this.debugOutput) {
                    if (!this.firstPrint && !this.debugOutput) {
                        System.out.println();
                    }
                    this.firstPrint = false;
                    System.out.print(this.outMsg);
                    this.lastMsgLength = this.outMsg.length();
                    if (this.debugOutput) {
                        System.out.println();
                    }
                } else {
                    int i;
                    if (!this.firstPrint) {
                        System.out.print('\r');
                    } else {
                        this.firstPrint = false;
                    }
                    System.out.print(this.outMsg);
                    System.out.print(' ');
                    int spaceCount = this.lastMsgLength - this.outMsg.length();
                    for (i = 0; i < spaceCount; ++i) {
                        System.out.print(' ');
                    }
                    for (i = 0; i < spaceCount; ++i) {
                        System.out.print('\b');
                    }
                    this.lastMsgLength = this.outMsg.length();
                    this.spinnerIndex = -1;
                }
            }
            if (!this.debugOutput) {
                if (this.commandProgress.isSpinnerActive()) {
                    if (this.ticker == null) {
                        this.ticker = new Ticker(this.disableAnimation ? 1500L : 500L);
                        this.ticker.start();
                    }
                } else if (this.ticker != null) {
                    this.ticker.stopit();
                    this.ticker = null;
                }
            }
        }
    }

    public synchronized void deleteLastMessage() {
        if (this.lastMsgLength <= 0) {
            return;
        }
        if (this.disableAnimation || this.debugOutput) {
            System.out.println();
        } else {
            System.out.print('\r');
            for (int i = 0; i < this.lastMsgLength; ++i) {
                System.out.print(' ');
            }
            System.out.print('\r');
        }
        if (this.ticker != null) {
            this.ticker.stopit();
            this.ticker = null;
        }
        this.lastMsgLength = 0;
    }

    public synchronized void reset() {
        this.client = new ProgressStatusClient(null);
        this.commandProgress = null;
        this.lastPercentage = -1;
        this.lastMessage = "";
        this.outMsg.setLength(0);
        this.lastSumSteps = -1;
        this.lastMsgLength = 0;
        this.firstPrint = true;
        if (this.ticker != null) {
            this.ticker.stopit();
            this.ticker = null;
        }
    }

    private class Ticker
    extends Thread {
        private final long pause;
        private volatile boolean stop = false;

        public Ticker(long pause) {
            this.pause = pause;
            this.setDaemon(true);
        }

        public void stopit() {
            this.stop = true;
        }

        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.stop) continue;
                return;
            } while (ProgressStatusPrinter.this.spin());
        }
    }
}

