/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.UninstallNodeBaseCommand;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="uninstall-node-ssh")
@PerLookup
public class UninstallNodeSshCommand
extends UninstallNodeBaseCommand {
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(optional=true, defaultValue="22", name="sshport")
    private int port;
    @Param(optional=true)
    private String sshkeyfile;
    @Inject
    private SSHLauncher sshLauncher;

    @Override
    String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return this.port;
    }

    @Override
    String getSshKeyFile() {
        return this.sshkeyfile;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey;
            }
        } else {
            this.validateKey(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && SSHUtil.isEncryptedKey(this.sshkeyfile)) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    @Override
    void deleteFromHosts() throws CommandException {
        SFTPClient sftpClient = null;
        try {
            List<String> files = this.getListOfInstallFiles(this.getInstallDir());
            for (String host : this.hosts) {
                this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
                if (this.sshkeyfile != null && !this.sshLauncher.checkConnection()) {
                    this.promptPass = true;
                }
                if (this.promptPass) {
                    this.sshpassword = this.getSSHPassword(host);
                    this.sshLauncher.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
                }
                if (!(sftpClient = this.sshLauncher.getSFTPClient()).exists(this.getInstallDir())) {
                    throw new IOException(this.getInstallDir() + " Directory does not exist");
                }
                this.deleteRemoteFiles(sftpClient, files, this.getInstallDir(), this.getForce());
                if (this.isRemoteDirectoryEmpty(sftpClient, this.getInstallDir())) {
                    sftpClient.rmdir(this.getInstallDir());
                }
                sftpClient.close();
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(ex);
        }
        finally {
            if (sftpClient != null) {
                sftpClient.close();
            }
        }
    }
}

