/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.StopLocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-local-instance")
@PerLookup
public class RestartLocalInstanceCommand
extends StopLocalInstanceCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private ServiceLocator habitat;

    @Override
    protected final int doRemoteCommand() throws CommandException {
        this.setLocalPassword();
        this.programOpts.setInteractive(false);
        if (!this.isRestartable()) {
            throw new CommandException(Strings.get("restart.notRestartable"));
        }
        long uptimeOldServer = this.getUptime();
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long timestamp = pwFile != null ? pwFile.lastModified() : -1L;
        RemoteCLICommand cmd = new RemoteCLICommand("_restart-instance", this.programOpts, this.env);
        if (this.debug != null) {
            cmd.executeAndReturnOutput("_restart-instance", "--debug", this.debug.toString());
        } else {
            cmd.executeAndReturnOutput("_restart-instance");
        }
        this.waitForRestart(pwFile, timestamp, uptimeOldServer);
        return 0;
    }

    @Override
    protected int instanceNotRunning() throws CommandException {
        logger.warning(Strings.get("restart.instanceNotRunning"));
        CLICommand cmd = this.habitat.getService(CLICommand.class, "start-local-instance", new Annotation[0]);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-local-instance");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.nodeDir != null) {
            opts.add("--nodedir");
            opts.add(this.nodeDir);
        }
        if (this.node != null) {
            opts.add("--node");
            opts.add(this.node);
        }
        if (this.instanceName != null) {
            opts.add(this.instanceName);
        }
        return cmd.execute(opts.toArray(new String[opts.size()]));
    }
}

