/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class DirectoryClassLoader
extends URLClassLoader {
    private static final LocalStringsImpl strings = new LocalStringsImpl(DirectoryClassLoader.class);

    public DirectoryClassLoader(String dir2, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(new File(dir2)), parent);
    }

    public DirectoryClassLoader(File dir2, ClassLoader parent) throws IOException {
        super(DirectoryClassLoader.getJars(dir2), parent);
    }

    private static URL[] getJars(File dir2) throws IOException {
        File[] fjars = dir2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.endsWith(".jar");
            }
        });
        if (fjars == null) {
            throw new IOException(strings.get("DirError", dir2));
        }
        URL[] jars = new URL[fjars.length];
        for (int i = 0; i < fjars.length; ++i) {
            jars[i] = fjars[i].toURI().toURL();
        }
        return jars;
    }
}

