/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.MethodLockInfo;
import com.sun.ejb.containers.AbstractSingletonContainer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.IllegalLoopbackException;
import javax.ejb.LockType;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class CMCSingletonContainer
extends AbstractSingletonContainer {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwLock.writeLock();
    private static final long NO_BLOCKING = 0L;
    private static final long BLOCK_INDEFINITELY = -1L;
    private final MethodLockInfo defaultMethodLockInfo = new MethodLockInfo();

    public CMCSingletonContainer(EjbDescriptor desc, ClassLoader cl) throws Exception {
        super(desc, cl);
        this.defaultMethodLockInfo.setLockType(LockType.WRITE);
    }

    @Override
    protected ComponentContext _getContext(EjbInvocation inv) {
        this.checkInit();
        InvocationInfo invInfo = inv.invocationInfo;
        MethodLockInfo lockInfo = invInfo.methodLockInfo == null ? this.defaultMethodLockInfo : invInfo.methodLockInfo;
        Lock theLock = lockInfo.isReadLockedMethod() ? this.readLock : this.writeLock;
        if (this.rwLock.getReadHoldCount() > 0 && !this.rwLock.isWriteLockedByCurrentThread() && lockInfo.isWriteLockedMethod()) {
            throw new IllegalLoopbackException("Illegal Reentrant Access : Attempt to make a loopback call on a Write Lock method '" + invInfo.targetMethod1 + "' while a Read lock is already held");
        }
        if (!lockInfo.hasTimeout() || lockInfo.hasTimeout() && lockInfo.getTimeout() == -1L) {
            theLock.lock();
        } else {
            try {
                boolean lockStatus = theLock.tryLock(lockInfo.getTimeout(), lockInfo.getTimeUnit());
                if (!lockStatus) {
                    String msg = "Couldn't acquire a lock within " + lockInfo.getTimeout() + " " + (Object)((Object)lockInfo.getTimeUnit());
                    if (lockInfo.getTimeout() == 0L) {
                        throw new ConcurrentAccessException(msg);
                    }
                    throw new ConcurrentAccessTimeoutException(msg);
                }
            }
            catch (InterruptedException inEx) {
                String msg = "Couldn't acquire a lock within " + lockInfo.getTimeout() + " " + (Object)((Object)lockInfo.getTimeUnit());
                ConcurrentAccessException cae = lockInfo.getTimeout() == 0L ? new ConcurrentAccessException(msg) : new ConcurrentAccessTimeoutException(msg);
                cae.initCause(inEx);
                throw cae;
            }
        }
        inv.setCMCLock(theLock);
        return this.singletonCtx;
    }

    @Override
    public void releaseContext(EjbInvocation inv) {
        Lock theLock = inv.getCMCLock();
        if (theLock != null) {
            theLock.unlock();
        }
    }
}

