/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class AsmSerializableBeanGenerator
implements Opcodes {
    private static final int INTF_FLAGS = 3;
    private byte[] classData = null;
    private Class loadedClass = null;
    private ClassLoader loader;
    private Class baseClass;
    private String subclassName;
    private static final Method defineClassMethod = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            try {
                Method meth = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                meth.setAccessible(true);
                return meth;
            }
            catch (Exception exc) {
                throw new RuntimeException("Could not find defineClass method!", exc);
            }
        }
    });
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");

    public AsmSerializableBeanGenerator(ClassLoader loader, Class baseClass, String serializableSubclassName) {
        this.loader = loader;
        this.baseClass = baseClass;
        this.subclassName = serializableSubclassName;
    }

    public String getSerializableSubclassName() {
        return this.subclassName;
    }

    public Class generateSerializableSubclass() throws Exception {
        try {
            this.loadedClass = this.loader.loadClass(this.subclassName);
            return this.loadedClass;
        }
        catch (ClassNotFoundException e) {
            ClassWriter cw;
            ClassWriter tv = cw = new ClassWriter(3);
            String subclassInternalName = this.subclassName.replace('.', '/');
            String[] interfaces = new String[]{Type.getType(Serializable.class).getInternalName()};
            tv.visit(196653, 1, subclassInternalName, null, Type.getType(this.baseClass).getInternalName(), interfaces);
            Constructor<?>[] ctors = this.baseClass.getConstructors();
            Constructor<?> ctorWithParams = null;
            for (Constructor<?> ctor : ctors) {
                if (ctor.getParameterTypes().length == 0) {
                    ctorWithParams = null;
                    break;
                }
                if (ctorWithParams != null) continue;
                ctorWithParams = ctor;
            }
            int numArgsToPass = 1;
            String paramTypeString = "()V";
            if (ctorWithParams != null) {
                Class<?>[] paramTypes = ctorWithParams.getParameterTypes();
                numArgsToPass = paramTypes.length + 1;
                paramTypeString = Type.getConstructorDescriptor(ctorWithParams);
            }
            MethodVisitor ctorv = tv.visitMethod(1, "<init>", paramTypeString, null, null);
            for (int i = 0; i < numArgsToPass; ++i) {
                ctorv.visitVarInsn(25, i);
            }
            ctorv.visitMethodInsn(183, Type.getType(this.baseClass).getInternalName(), "<init>", paramTypeString);
            ctorv.visitInsn(177);
            ctorv.visitMaxs(numArgsToPass, numArgsToPass);
            MethodVisitor cv = cw.visitMethod(2, "writeObject", "(Ljava/io/ObjectOutputStream;)V", null, new String[]{"java/io/IOException"});
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitMethodInsn(184, "com/sun/ejb/EJBUtils", "serializeObjectFields", "(Ljava/lang/Object;Ljava/io/ObjectOutputStream;)V");
            cv.visitInsn(177);
            cv.visitMaxs(2, 2);
            cv = cw.visitMethod(2, "readObject", "(Ljava/io/ObjectInputStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitMethodInsn(184, "com/sun/ejb/EJBUtils", "deserializeObjectFields", "(Ljava/lang/Object;Ljava/io/ObjectInputStream;)V");
            cv.visitInsn(177);
            cv.visitMaxs(2, 2);
            tv.visitEnd();
            this.classData = cw.toByteArray();
            this.loadedClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AsmSerializableBeanGenerator.this.makeClass(AsmSerializableBeanGenerator.this.subclassName, AsmSerializableBeanGenerator.this.classData, AsmSerializableBeanGenerator.this.baseClass.getProtectionDomain(), AsmSerializableBeanGenerator.this.loader);
                }
            });
            return this.loadedClass;
        }
    }

    private Class<?> makeClass(String name, byte[] def, ProtectionDomain pd, ClassLoader loader) {
        SecurityManager sman = System.getSecurityManager();
        if (sman != null) {
            sman.checkPermission(accessControlPermission);
        }
        try {
            return (Class)defineClassMethod.invoke((Object)loader, name, def, 0, def.length, pd);
        }
        catch (Exception exc) {
            throw new RuntimeException("Could not invoke defineClass!", exc);
        }
    }
}

