/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.LoggingConfig;
import com.sun.common.util.logging.LoggingXMLNames;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

@Service
@Contract
public class LoggingConfigImpl
implements LoggingConfig,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    FileMonitoring fileMonitoring;
    Properties props = new Properties();
    FileInputStream fis;
    String loggingPropertiesName;
    File loggingConfigDir = null;
    File file = null;

    @Override
    public void postConstruct() {
        this.setupConfigDir(this.env.getConfigDirPath(), this.env.getLibPath());
    }

    public void setupConfigDir(File file, File installDir) {
        this.loggingConfigDir = file;
        this.loggingPropertiesName = "logging.properties";
    }

    private boolean openPropFile() throws IOException {
        try {
            this.props = new Properties();
            this.file = new File(this.loggingConfigDir, this.loggingPropertiesName);
            this.fis = new FileInputStream(this.file);
            this.props.load(this.fis);
            this.fis.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot read logging.properties file : ", e);
            throw new IOException();
        }
    }

    public boolean copyLoggingPropertiesFile(File targetDir) throws IOException {
        Logger.getAnonymousLogger().log(Level.WARNING, "Logging.properties file not found, creating new file using DAS logging.properties");
        String rootFolder = this.env.getProps().get("com.sun.aas.installRoot");
        String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
        File src = new File(templateDir, "logging.properties");
        File dest = new File(targetDir, "logging.properties");
        try {
            FileUtils.copy(src, dest);
            return true;
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot create logging.properties file : ", e);
            throw new IOException();
        }
    }

    private boolean openPropFile(String target) throws IOException {
        try {
            this.props = new Properties();
            String pathForLoggingFile = this.loggingConfigDir.getAbsolutePath() + File.separator + target;
            File dirForLogging = new File(pathForLoggingFile);
            this.file = new File(dirForLogging, this.loggingPropertiesName);
            if (!this.file.exists()) {
                this.copyLoggingPropertiesFile(dirForLogging);
                this.file = new File(dirForLogging, this.loggingPropertiesName);
            }
            this.fis = new FileInputStream(this.file);
            this.props.load(this.fis);
            this.fis.close();
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot read logging.properties file : ", e);
            throw new IOException();
        }
    }

    private void safeCloseStream(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeCloseStream(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closePropFile() throws IOException {
        FileOutputStream ois = null;
        try {
            ois = new FileOutputStream(this.file);
            this.props.store(ois, "GlassFish logging.properties list");
            this.safeCloseStream(ois);
        }
        catch (FileNotFoundException e) {
            try {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot close logging.properties file : ", e);
                throw new IOException();
                catch (IOException e2) {
                    Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot close logging.properties file : ", e2);
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                this.safeCloseStream(ois);
                throw throwable;
            }
        }
        this.fileMonitoring.fileModified(this.file);
    }

    private void setWebLoggers(String value) {
        this.props.setProperty("org.apache.catalina.level", value);
        this.props.setProperty("org.apache.coyote.level", value);
        this.props.setProperty("org.apache.jasper.level", value);
    }

    @Override
    public synchronized String setLoggingProperty(String propertyName, String propertyValue) throws IOException {
        if (!this.openPropFile()) {
            return null;
        }
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("javax.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile();
        return property;
    }

    @Override
    public synchronized String setLoggingProperty(String propertyName, String propertyValue, String targetConfigName) throws IOException {
        if (!this.openPropFile(targetConfigName)) {
            return null;
        }
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("javax.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile();
        return property;
    }

    @Override
    public synchronized Map<String, String> updateLoggingProperties(Map<String, String> properties) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            if (!this.openPropFile()) {
                return null;
            }
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (e.getValue() == null) continue;
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                String property = (String)this.props.setProperty(key, e.getValue());
                if (e.getKey().contains("javax.enterprise.system.container.web")) {
                    this.setWebLoggers(e.getValue());
                }
                m.put(key, property);
            }
            this.closePropFile();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m;
    }

    @Override
    public synchronized Map<String, String> updateLoggingProperties(Map<String, String> properties, String targetConfigName) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            if (!this.openPropFile(targetConfigName)) {
                return null;
            }
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (e.getValue() == null) continue;
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                String property = (String)this.props.setProperty(key, e.getValue());
                if (e.getKey().contains("javax.enterprise.system.container.web")) {
                    this.setWebLoggers(e.getValue());
                }
                m.put(key, property);
            }
            this.closePropFile();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception e) {
            // empty catch block
        }
        return m;
    }

    @Override
    public synchronized Map<String, String> getLoggingProperties(String targetConfigName) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (!this.openPropFile(targetConfigName)) {
            return null;
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        return m;
    }

    @Override
    public synchronized Map<String, String> getLoggingProperties() throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        if (!this.openPropFile()) {
            return null;
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        return m;
    }

    @Override
    public synchronized void deleteLoggingProperties(Map<String, String> properties) throws IOException {
        try {
            this.openPropFile();
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                this.props.remove(key);
            }
            this.closePropFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void deleteLoggingProperties(Map<String, String> properties, String targetConfigName) throws IOException {
        try {
            this.openPropFile(targetConfigName);
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                this.props.remove(key);
            }
            this.closePropFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getZipFileName(String sourceDir) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        String zipFile = sourceDir + File.separator + "log_" + currentTime + ".zip";
        return zipFile;
    }

    private String getZipFileName(String sourceDir, String fileName) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        String zipFile = sourceDir + File.separator + fileName + "-" + currentTime + ".zip";
        return zipFile;
    }

    @Override
    public String createZipFile(String sourceDir) throws IOException {
        ZipOutputStream zout = null;
        String zipFile = this.getZipFileName(sourceDir);
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            this.addDirectory(zout, fileSource, fileSource.getAbsolutePath().length() + 1);
            zout.close();
            this.safeCloseStream(zout);
        }
        catch (IOException ioe) {
            try {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.safeCloseStream(zout);
                throw throwable;
            }
        }
        return zipFile;
    }

    public String createZipFile(String sourceDir, String zipFileName) throws IOException {
        ZipOutputStream zout = null;
        String zipFile = this.getZipFileName(sourceDir, zipFileName);
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            this.addDirectory(zout, fileSource, fileSource.getAbsolutePath().length() + 1);
            zout.close();
            this.safeCloseStream(zout);
        }
        catch (IOException ioe) {
            try {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.safeCloseStream(zout);
                throw throwable;
            }
        }
        return zipFile;
    }

    private void addDirectory(ZipOutputStream zout, File fileSource, int ignoreLength) throws IOException {
        File[] files = fileSource.listFiles();
        FileInputStream fin = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(zout, files[i], ignoreLength);
                continue;
            }
            if (files[i].getAbsolutePath().contains(".zip")) continue;
            try {
                int length;
                byte[] buffer = new byte[1024];
                fin = new FileInputStream(files[i].getAbsolutePath());
                zout.putNextEntry(new ZipEntry(ignoreLength > -1 ? files[i].getAbsolutePath().substring(ignoreLength) : files[i].getAbsolutePath()));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                this.safeCloseStream(fin);
                continue;
            }
            catch (IOException ioe) {
                try {
                    Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                    throw ioe;
                }
                catch (Throwable throwable) {
                    this.safeCloseStream(fin);
                    throw throwable;
                }
            }
        }
    }

    public synchronized String getLoggingFileDetails() throws IOException {
        if (!this.openPropFile()) {
            return null;
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            if (key == null || !key.equals("com.sun.enterprise.server.logging.GFFileHandler.file")) continue;
            return this.props.getProperty(key);
        }
        return null;
    }

    public synchronized String getLoggingFileDetails(String targetConfigName) throws IOException {
        if (!this.openPropFile(targetConfigName)) {
            return null;
        }
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            if (key == null || !key.equals("com.sun.enterprise.server.logging.GFFileHandler.file")) continue;
            return this.props.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultLoggingProperties() throws IOException {
        FileInputStream fisForLoggingTemplate = null;
        Properties propsLoggingTempleate = new Properties();
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            String rootFolder = this.env.getProps().get("com.sun.aas.installRoot");
            String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
            File loggingTemplateFile = new File(templateDir, "logging.properties");
            fisForLoggingTemplate = new FileInputStream(loggingTemplateFile);
            propsLoggingTempleate.load(fisForLoggingTemplate);
            this.safeCloseStream(fisForLoggingTemplate);
        }
        catch (Throwable throwable) {
            this.safeCloseStream(fisForLoggingTemplate);
            throw throwable;
        }
        Enumeration<?> e = propsLoggingTempleate.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, propsLoggingTempleate.getProperty(key));
        }
        return m;
    }
}

