/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.taglibs.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.taglibs.cache.CacheUtil;
import com.sun.enterprise.web.WebContainer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class FlushTag
extends TagSupport {
    private String _key;
    private int _scope = 4;
    private static final Logger _logger = WebContainer.logger;
    private static final String FLUSH_TAG_CLEAR_KEY = "AS-WEB-00217";
    private static final String FLUSH_TAG_CLEAR_CACHE = "AS-WEB-00218";

    @Override
    public int doStartTag() throws JspException {
        Cache cache = CacheUtil.getCache(this.pageContext, this._scope);
        if (this._key != null) {
            String key = CacheUtil.generateKey(this._key, this.pageContext);
            cache.remove(key);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, FLUSH_TAG_CLEAR_KEY, key);
            }
        } else {
            cache.clear();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, FLUSH_TAG_CLEAR_CACHE);
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        this._key = null;
        this._scope = 4;
        return 6;
    }

    public void setKey(String key) {
        if (key != null && key.length() > 0) {
            this._key = key;
        }
    }

    public void setScope(String scope) {
        this._scope = CacheUtil.convertScope(scope);
    }
}

