/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.enterprise.web.WebContainer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class ValueConstraint {
    private static final String[] EXPR_NAMES = new String[]{"", "'equals'", "'greater'", "'lesser'", "'not-equals'", "'in-range'"};
    private static final Logger _logger = WebContainer.logger;
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    private static final String GREATER_EXP_REQ_NUMERIC = "AS-WEB-00357";
    private static final String LESSER_EXP_REQ_NUMERIC = "AS-WEB-00358";
    private static final String ILLEGAL_VALUE_EXP = "AS-WEB-00359";
    private static final String ILLEGAL_VALUE_RANGE = "AS-WEB-00360";
    private static final String MISSING_RANGE_SEP = "AS-WEB-00361";
    private static final String LOWER_RANGE_REQ_NUMBER = "AS-WEB-00362";
    private static final String RANGE_REQ_UPPER_BOUND = "AS-WEB-00363";
    private static final String UPPER_RANGE_REQ_NUMBER = "AS-WEB-00364";
    private String matchValue = null;
    private float minValue = Float.MIN_VALUE;
    private float maxValue = Float.MAX_VALUE;
    private int matchExpr = 1;
    private String str;
    private boolean cacheOnMatch = true;
    private boolean cacheOnMatchFailure = false;

    public ValueConstraint(String value, String expr) throws IllegalArgumentException {
        int match;
        if (expr == null || expr.equals("equals")) {
            match = 1;
        } else if (expr.equals("greater")) {
            match = 2;
            try {
                this.minValue = Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                String msg = _rb.getString(GREATER_EXP_REQ_NUMERIC);
                Object[] params = new Object[]{value};
                msg = MessageFormat.format(msg, params);
                throw new IllegalArgumentException(msg);
            }
        } else if (expr.equals("lesser")) {
            match = 3;
            try {
                this.maxValue = Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                String msg = _rb.getString(LESSER_EXP_REQ_NUMERIC);
                Object[] params = new Object[]{value};
                msg = MessageFormat.format(msg, params);
                throw new IllegalArgumentException(msg);
            }
        } else if (expr.equals("not-equals")) {
            match = 4;
        } else if (expr.equals("in-range")) {
            match = 5;
            this.parseRangeValue(value);
        } else {
            String msg = _rb.getString(ILLEGAL_VALUE_EXP);
            Object[] params = new Object[]{value, expr};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        this.matchExpr = match;
        this.matchValue = value;
    }

    private void parseRangeValue(String value) throws IllegalArgumentException {
        float val2;
        float val1;
        if (value == null || value.length() <= 2) {
            String msg = _rb.getString(ILLEGAL_VALUE_RANGE);
            Object[] params = new Object[]{value};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        int separator = value.charAt(0) == '-' ? value.indexOf(45, 1) : value.indexOf(45, 0);
        if (separator == -1) {
            String msg = _rb.getString(MISSING_RANGE_SEP);
            Object[] params = new Object[]{value};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        String sval1 = value.substring(0, separator).trim();
        try {
            val1 = Float.parseFloat(sval1);
        }
        catch (NumberFormatException nfe) {
            String msg = _rb.getString(LOWER_RANGE_REQ_NUMBER);
            Object[] params = new Object[]{sval1};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        if (separator == value.length()) {
            String msg = _rb.getString(RANGE_REQ_UPPER_BOUND);
            Object[] params = new Object[]{value};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        String sval2 = value.substring(separator + 1).trim();
        try {
            val2 = Float.parseFloat(sval2);
        }
        catch (NumberFormatException nfe) {
            String msg = _rb.getString(UPPER_RANGE_REQ_NUMBER);
            Object[] params = new Object[]{sval2};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        this.minValue = val1;
        this.maxValue = val2;
    }

    public void setValue(String value) {
        this.matchValue = value;
    }

    public void setMinValue(float value) {
        this.minValue = value;
    }

    public void setMaxValue(float value) {
        this.maxValue = value;
    }

    public void setMatchExpr(int expr) {
        this.matchExpr = expr;
    }

    public void setCacheOnMatch(boolean cacheOnMatch) {
        this.cacheOnMatch = cacheOnMatch;
    }

    public void setCacheOnMatchFailure(boolean cacheOnMatchFailure) {
        this.cacheOnMatchFailure = cacheOnMatchFailure;
    }

    public boolean matches(Object value) {
        boolean result;
        switch (this.matchExpr) {
            case 1: {
                result = this.matchValue.equals(value);
                break;
            }
            case 4: {
                result = !this.matchValue.equals(value);
                break;
            }
            case 2: {
                Float lval = new Float(value.toString());
                result = lval.floatValue() > this.minValue;
                break;
            }
            case 3: {
                Float lval = new Float(value.toString());
                result = lval.floatValue() < this.maxValue;
                break;
            }
            case 5: {
                Float lval = new Float(value.toString());
                result = lval.floatValue() >= this.minValue && lval.floatValue() <= this.maxValue;
                break;
            }
            default: {
                result = false;
            }
        }
        return result ? this.cacheOnMatch : this.cacheOnMatchFailure;
    }

    public String toString() {
        if (this.str == null) {
            this.str = "match value = " + this.matchValue + " match expr = " + EXPR_NAMES[this.matchExpr];
        }
        return this.str;
    }
}

