/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.enterprise.web.WebContainer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Field {
    private static final Logger _logger = WebContainer.logger;
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    public static final String CACHE_MAPPING_INCORRECT_SCOPE = "AS-WEB-00356";
    protected String name;
    protected int scope;

    public Field(String name, String scope) throws IllegalArgumentException {
        this.name = name;
        this.scope = this.parseScope(scope);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    private int parseScope(String value) throws IllegalArgumentException {
        int scope;
        if ("context.attribute".equals(value)) {
            scope = 1;
        } else if ("request.header".equals(value)) {
            scope = 2;
        } else if ("request.parameter".equals(value)) {
            scope = 3;
        } else if ("request.cookie".equals(value)) {
            scope = 4;
        } else if ("request.attribute".equals(value)) {
            scope = 5;
        } else if ("session.attribute".equals(value)) {
            scope = 6;
        } else if ("session.id".equals(value)) {
            scope = 7;
        } else {
            String msg = _rb.getString(CACHE_MAPPING_INCORRECT_SCOPE);
            Object[] params = new Object[]{value, this.name};
            msg = MessageFormat.format(msg, params);
            throw new IllegalArgumentException(msg);
        }
        return scope;
    }

    public String getName() {
        return this.name;
    }

    public int getScope() {
        return this.scope;
    }

    public Object getValue(ServletContext context, HttpServletRequest request) {
        Object value = null;
        block0 : switch (this.scope) {
            case 1: {
                value = context.getAttribute(this.name);
                break;
            }
            case 2: {
                value = request.getHeader(this.name);
                break;
            }
            case 3: {
                value = request.getParameter(this.name);
                break;
            }
            case 4: {
                Cookie[] cookies = request.getCookies();
                for (int i = 0; i < cookies.length; ++i) {
                    if (!this.name.equals(cookies[i].getName())) continue;
                    value = cookies[i].getValue();
                    break block0;
                }
                break;
            }
            case 5: {
                value = request.getAttribute(this.name);
                break;
            }
            case 7: {
                HttpSession session = request.getSession(false);
                if (session == null) break;
                value = session.getId();
                break;
            }
            case 6: {
                HttpSession session = request.getSession(false);
                if (session == null) break;
                value = session.getAttribute(this.name);
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }
}

