/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.mapping;

import com.sun.appserv.web.cache.mapping.Field;
import com.sun.appserv.web.cache.mapping.ValueConstraint;
import com.sun.enterprise.web.WebContainer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ConstraintField
extends Field {
    private static final String[] SCOPE_NAMES = new String[]{"", "context.attribute", "request.header", "request.parameter", "request.cookie", "request.attribute", "session.attribute", "session.id"};
    private static final Logger _logger = WebContainer.logger;
    private static final String CONSTRAINT_FIELD_NOT_FOUND = "AS-WEB-00211";
    private static final String CONSTRAINT_FIELD_FOUND = "AS-WEB-00212";
    private static final String CONSTRAINT_FIELD_MATCH = "AS-WEB-00213";
    private static final String CONSTRAINT_FIELD_NOT_MATCH = "AS-WEB-00214";
    boolean cacheOnMatch = true;
    boolean cacheOnMatchFailure = false;
    ValueConstraint[] constraints = new ValueConstraint[0];

    public ConstraintField(String name, String scope) throws IllegalArgumentException {
        super(name, scope);
    }

    public void setCacheOnMatch(boolean cacheOnMatch) {
        this.cacheOnMatch = cacheOnMatch;
    }

    public boolean getCacheOnMatch() {
        return this.cacheOnMatch;
    }

    public void setCacheOnMatchFailure(boolean cacheOnMatchFailure) {
        this.cacheOnMatchFailure = cacheOnMatchFailure;
    }

    public boolean getCacheOnMatchFailure() {
        return this.cacheOnMatchFailure;
    }

    public void addConstraint(ValueConstraint constraint) {
        if (constraint == null) {
            return;
        }
        ValueConstraint[] results = new ValueConstraint[this.constraints.length + 1];
        for (int i = 0; i < this.constraints.length; ++i) {
            results[i] = this.constraints[i];
        }
        results[this.constraints.length] = constraint;
        this.constraints = results;
    }

    public void setValueConstraints(ValueConstraint[] vcs) {
        if (vcs == null) {
            return;
        }
        this.constraints = vcs;
    }

    public boolean applyConstraints(ServletContext context, HttpServletRequest request) {
        Object value = this.getValue(context, request);
        boolean isFine = _logger.isLoggable(Level.FINE);
        if (value == null) {
            if (isFine) {
                _logger.log(Level.FINE, CONSTRAINT_FIELD_NOT_FOUND, new Object[]{this.name, SCOPE_NAMES[this.scope], this.cacheOnMatchFailure});
            }
            return this.cacheOnMatchFailure;
        }
        if (this.constraints.length == 0) {
            if (isFine) {
                _logger.log(Level.FINE, CONSTRAINT_FIELD_FOUND, new Object[]{this.name, value.toString(), SCOPE_NAMES[this.scope], this.cacheOnMatch});
            }
            return this.cacheOnMatch;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            ValueConstraint c = this.constraints[i];
            if (!c.matches(value)) continue;
            if (isFine) {
                _logger.log(Level.FINE, CONSTRAINT_FIELD_MATCH, new Object[]{this.name, value.toString(), SCOPE_NAMES[this.scope], this.cacheOnMatch});
            }
            return this.cacheOnMatch;
        }
        if (isFine) {
            _logger.log(Level.FINE, CONSTRAINT_FIELD_NOT_MATCH, new Object[]{this.name, value.toString(), SCOPE_NAMES[this.scope], this.cacheOnMatchFailure});
        }
        return this.cacheOnMatchFailure;
    }
}

