/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.NoConverter;
import com.beust.jcommander.converters.StringConverter;
import com.beust.jcommander.internal.DefaultConverterFactory;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<String, ParameterDescription> m_descriptions;
    private List<Object> m_objects;
    private Field m_mainParameterField = null;
    private Object m_mainParameterObject;
    private Parameter m_mainParameterAnnotation;
    private ParameterDescription m_mainParameterDescription;
    private Map<Field, ParameterDescription> m_requiredFields = Maps.newHashMap();
    private Map<Field, ParameterDescription> m_fields = Maps.newHashMap();
    private ResourceBundle m_bundle;
    private IDefaultProvider m_defaultProvider;
    private Map<String, JCommander> m_commands = Maps.newLinkedHashMap();
    private String m_parsedCommand;
    private String m_programName;
    private static List<IStringConverterFactory> CONVERTER_FACTORIES = Lists.newArrayList();

    public JCommander(Object object) {
        this.init(object, null);
    }

    public JCommander(Object object, ResourceBundle bundle2, String ... args) {
        this.init(object, bundle2);
        this.parse(args);
    }

    public JCommander(Object object, String ... args) {
        this.init(object, null);
        this.parse(args);
    }

    private void init(Object object, ResourceBundle bundle2) {
        this.m_bundle = bundle2;
        this.m_objects = Lists.newArrayList();
        if (object instanceof Iterable) {
            for (Object o : (Iterable)object) {
                this.m_objects.add(o);
            }
        } else if (object.getClass().isArray()) {
            for (Object o : (Object[])object) {
                this.m_objects.add(o);
            }
        } else {
            this.m_objects.add(object);
        }
    }

    public void parse(String ... args) {
        StringBuilder sb = new StringBuilder("Parsing \"");
        sb.append((CharSequence)this.join(args).append("\"\n  with:").append((CharSequence)this.join(this.m_objects.toArray())));
        this.p(sb.toString());
        this.createDescriptions();
        this.initializeDefaultValues();
        this.parseValues(this.expandArgs(args));
        this.validateOptions();
    }

    private StringBuilder join(Object[] args) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(args[i]);
        }
        return result;
    }

    private void initializeDefaultValues() {
        if (this.m_defaultProvider != null) {
            for (ParameterDescription pd : this.m_descriptions.values()) {
                this.initializeDefaultValue(pd);
            }
        }
    }

    private void validateOptions() {
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder missingFields = new StringBuilder();
            for (ParameterDescription pd : this.m_requiredFields.values()) {
                missingFields.append(pd.getNames()).append(" ");
            }
            throw new ParameterException("The following options are required: " + missingFields);
        }
        if (this.m_mainParameterDescription != null && this.m_mainParameterDescription.getParameter().required() && !this.m_mainParameterDescription.isAssigned()) {
            throw new ParameterException("Main parameters are required (\"" + this.m_mainParameterDescription.getDescription() + "\")");
        }
    }

    private String[] expandArgs(String[] originalArgv) {
        List vResult1 = Lists.newArrayList();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult1.addAll(JCommander.readFile(fileName));
                continue;
            }
            vResult1.add(arg);
        }
        List vResult2 = Lists.newArrayList();
        for (int i = 0; i < vResult1.size(); ++i) {
            String arg = (String)vResult1.get(i);
            String[] v1 = vResult1.toArray(new String[0]);
            if (this.isOption(v1, arg)) {
                String sep = this.getSeparatorFor(v1, arg);
                if (!" ".equals(sep)) {
                    String[] sp;
                    for (String ssp : sp = arg.split("[" + sep + "]")) {
                        vResult2.add(ssp);
                    }
                    continue;
                }
                vResult2.add(arg);
                continue;
            }
            vResult2.add(arg);
        }
        return vResult2.toArray(new String[vResult2.size()]);
    }

    private boolean isOption(String[] args, String arg) {
        String prefixes = this.getOptionPrefixes(args, arg);
        return prefixes.indexOf(arg.charAt(0)) >= 0;
    }

    private ParameterDescription getPrefixDescriptionFor(String arg) {
        for (Map.Entry<String, ParameterDescription> es : this.m_descriptions.entrySet()) {
            if (!arg.startsWith(es.getKey())) continue;
            return es.getValue();
        }
        return null;
    }

    private ParameterDescription getDescriptionFor(String[] args, String arg) {
        ParameterDescription result = this.getPrefixDescriptionFor(arg);
        if (result != null) {
            return result;
        }
        for (String a : args) {
            ParameterDescription pd = this.getPrefixDescriptionFor(arg);
            if (pd != null) {
                result = pd;
            }
            if (!a.equals(arg)) continue;
            return result;
        }
        throw new ParameterException("Unknown parameter: " + arg);
    }

    private String getSeparatorFor(String[] args, String arg) {
        Parameters p;
        ParameterDescription pd = this.getDescriptionFor(args, arg);
        if (pd != null && (p = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p.separators();
        }
        return " ";
    }

    private String getOptionPrefixes(String[] args, String arg) {
        Parameters p;
        ParameterDescription pd = this.getDescriptionFor(args, arg);
        if (pd != null && (p = pd.getObject().getClass().getAnnotation(Parameters.class)) != null) {
            return p.optionPrefixes();
        }
        return "-";
    }

    private static List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new FileReader(fileName));
            while ((line = bufRead.readLine()) != null) {
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new ParameterException("Could not read file " + fileName + ": " + e);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"")) {
            if (result.endsWith("\"")) {
                return result.substring(1, result.length() - 1);
            }
            return result.substring(1);
        }
        return result;
    }

    private void createDescriptions() {
        this.m_descriptions = Maps.newHashMap();
        for (Object object : this.m_objects) {
            this.addDescription(object);
        }
    }

    private void addDescription(Object object) {
        Class<?> cls = object.getClass();
        while (!Object.class.equals(cls)) {
            for (Field f : cls.getDeclaredFields()) {
                this.p("Field:" + cls.getSimpleName() + "." + f.getName());
                f.setAccessible(true);
                Parameter annotation = f.getAnnotation(Parameter.class);
                if (annotation == null) continue;
                Parameter p = annotation;
                if (p.names().length == 0) {
                    this.p("Found main parameter:" + f);
                    if (this.m_mainParameterField != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameterField + " and " + f);
                    }
                    this.m_mainParameterField = f;
                    this.m_mainParameterObject = object;
                    this.m_mainParameterAnnotation = p;
                    this.m_mainParameterDescription = new ParameterDescription(object, p, f, this.m_bundle, this);
                    continue;
                }
                for (String name : p.names()) {
                    if (this.m_descriptions.containsKey(name)) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    ParameterDescription pd = new ParameterDescription(object, p, f, this.m_bundle, this);
                    this.m_fields.put(f, pd);
                    this.m_descriptions.put(name, pd);
                    if (!p.required()) continue;
                    this.m_requiredFields.put(f, pd);
                }
            }
            cls = cls.getSuperclass();
        }
    }

    private void initializeDefaultValue(ParameterDescription pd) {
        String optionName = pd.getParameter().names()[0];
        String def = this.m_defaultProvider.getDefaultValueFor(optionName);
        if (def != null) {
            this.p("Initializing " + optionName + " with default value:" + def);
            pd.addValue(def, true);
        }
    }

    private void parseValues(String[] args) {
        boolean commandParsed = false;
        for (int i = 0; i < args.length && !commandParsed; ++i) {
            String arg = args[i];
            String a = JCommander.trim(arg);
            this.p("Parsing arg:" + a);
            if (this.isOption(args, a)) {
                ParameterDescription pd = this.m_descriptions.get(a);
                if (pd != null) {
                    int n;
                    if (pd.getParameter().password()) {
                        char[] password = this.readPassword(pd.getDescription());
                        pd.addValue(new String(password));
                        continue;
                    }
                    Class<?> fieldType = pd.getField().getType();
                    if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && pd.getParameter().arity() == -1) {
                        pd.addValue("true");
                        this.m_requiredFields.remove(pd.getField());
                        continue;
                    }
                    int arity = pd.getParameter().arity();
                    int n2 = n = arity != -1 ? arity : 1;
                    if (n == 0 && (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType))) {
                        pd.addValue("true");
                        this.m_requiredFields.remove(pd.getField());
                        continue;
                    }
                    if (i < args.length - 1) {
                        int offset;
                        int n3 = offset = "--".equals(args[i + 1]) ? 1 : 0;
                        if (i + n < args.length) {
                            for (int j = 1; j <= n; ++j) {
                                pd.addValue(JCommander.trim(args[i + j + offset]));
                                this.m_requiredFields.remove(pd.getField());
                            }
                            i += n + offset;
                            continue;
                        }
                        throw new ParameterException("Expected " + n + " values after " + arg);
                    }
                    throw new ParameterException("Expected a value after parameter " + arg);
                }
                throw new ParameterException("Unknown option: " + a);
            }
            if (JCommander.isStringEmpty(arg)) continue;
            if (this.m_commands.isEmpty()) {
                ParameterizedType p;
                Type cls;
                List<?> mp = this.getMainParameter(arg);
                String value = arg;
                Object convertedValue = value;
                if (this.m_mainParameterField.getGenericType() instanceof ParameterizedType && (cls = (p = (ParameterizedType)this.m_mainParameterField.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                    convertedValue = this.convertValue(this.m_mainParameterField, (Class)cls, value);
                }
                this.m_mainParameterDescription.setAssigned(true);
                mp.add(convertedValue);
                continue;
            }
            JCommander jc = this.m_commands.get(arg);
            if (jc == null) {
                throw new ParameterException("Expected a command, got " + arg);
            }
            this.m_parsedCommand = arg;
            jc.parse(this.subArray(args, i + 1));
            commandParsed = true;
        }
    }

    private char[] readPassword(String description) {
        System.out.print(description + ": ");
        try {
            Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
            Object console = consoleMethod.invoke(null, new Object[0]);
            Method readPassword = console.getClass().getDeclaredMethod("readPassword", new Class[0]);
            return (char[])readPassword.invoke(console, new Object[0]);
        }
        catch (Throwable t) {
            return this.readLine(description);
        }
    }

    private char[] readLine(String description) {
        try {
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader in = new BufferedReader(isr);
            String result = in.readLine();
            in.close();
            isr.close();
            return result.toCharArray();
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
    }

    private String[] subArray(String[] args, int index) {
        int l = args.length - index;
        String[] result = new String[l];
        System.arraycopy(args, index, result, 0, l);
        return result;
    }

    private static boolean isStringEmpty(String s) {
        return s == null || "".equals(s);
    }

    private List<?> getMainParameter(String arg) {
        if (this.m_mainParameterField == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined");
        }
        try {
            List result = (List)this.m_mainParameterField.get(this.m_mainParameterObject);
            if (result == null) {
                result = Lists.newArrayList();
                this.m_mainParameterField.set(this.m_mainParameterObject, result);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new ParameterException("Couldn't access main parameter: " + ex.getMessage());
        }
    }

    private String getMainParameterDescription() {
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        return this.m_mainParameterAnnotation != null ? this.m_mainParameterAnnotation.description() : null;
    }

    private int longestName(Collection<?> objects) {
        int result = 0;
        for (Object o : objects) {
            int l = o.toString().length();
            if (l <= result) continue;
            result = l;
        }
        return result;
    }

    public void setProgramName(String name) {
        this.m_programName = name;
    }

    public void usage(String commandName) {
        StringBuilder sb = new StringBuilder();
        this.usage(commandName, sb);
        System.out.println(sb.toString());
    }

    public void usage(String commandName, StringBuilder out) {
        String description = this.getCommandDescription(commandName);
        JCommander jc = this.m_commands.get(commandName);
        if (description != null) {
            out.append(description);
            out.append("\n");
        }
        jc.usage(out);
    }

    public String getCommandDescription(String commandName) {
        JCommander jc = this.m_commands.get(commandName);
        Parameters p = jc.getObjects().get(0).getClass().getAnnotation(Parameters.class);
        String result = jc.getMainParameterDescription();
        if (p != null) {
            result = p.commandDescription();
        }
        return result;
    }

    public void usage() {
        StringBuilder sb = new StringBuilder();
        this.usage(sb);
        System.out.println(sb.toString());
    }

    private String cleanUpNames(String names) {
        return names.replace("-", "").replace(" ", "").toLowerCase();
    }

    public void usage(StringBuilder out) {
        if (this.m_descriptions == null) {
            this.createDescriptions();
        }
        boolean hasCommands = !this.m_commands.isEmpty();
        String programName = this.m_programName != null ? this.m_programName : "<main class>";
        out.append("Usage: " + programName + " [options]");
        if (hasCommands) {
            out.append(" [command] [command options]");
        }
        out.append("\n");
        if (this.m_mainParameterAnnotation != null) {
            out.append(" " + this.m_mainParameterAnnotation.description() + "\n");
        }
        out.append("  Options:\n");
        int longestName = 0;
        List<ParameterDescription> sorted = Lists.newArrayList();
        for (ParameterDescription pd : this.m_fields.values()) {
            if (pd.getParameter().hidden()) continue;
            sorted.add(pd);
            int length = pd.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        Collections.sort(sorted, new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                return p0.getLongestName().compareTo(p1.getLongestName());
            }
        });
        for (ParameterDescription pd : sorted) {
            int l = pd.getNames().length();
            int spaceCount = longestName - l;
            int start = out.length();
            out.append("  " + (pd.getParameter().required() ? "* " : "  ") + pd.getNames() + this.s(spaceCount));
            int indent = out.length() - start;
            this.wrapDescription(out, indent, pd.getDescription());
            Object def = pd.getDefault();
            if (def != null) {
                out.append("\n" + this.spaces(indent + 1)).append("Default: " + def);
            }
            out.append("\n");
        }
        if (hasCommands) {
            out.append("  Commands:\n");
            int ln = this.longestName(this.m_commands.keySet()) + 3;
            for (Map.Entry<String, JCommander> commands : this.m_commands.entrySet()) {
                String name = commands.getKey();
                int spaceCount = ln - name.length();
                out.append("    " + name + this.s(spaceCount) + this.getCommandDescription(name) + "\n");
            }
        }
    }

    private void wrapDescription(StringBuilder out, int indent, String description) {
        int max = 79;
        String[] words = description.split(" ");
        int current = indent;
        int i = 0;
        while (i < words.length) {
            String word = words[i];
            if (word.length() > max || current + word.length() <= max) {
                out.append(" ").append(word);
                current += word.length() + 1;
                ++i;
                continue;
            }
            out.append("\n").append(this.spaces(indent));
            current = indent;
        }
    }

    private String spaces(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.m_fields.values());
    }

    private void p(String string) {
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            System.out.println("[JCommander] " + string);
        }
    }

    public void setDefaultProvider(IDefaultProvider defaultProvider) {
        this.m_defaultProvider = defaultProvider;
    }

    public void addConverterFactory(IStringConverterFactory converterFactory) {
        CONVERTER_FACTORIES.add(converterFactory);
    }

    public <T> Class<? extends IStringConverter<T>> findConverter(Class<T> cls) {
        for (IStringConverterFactory f : CONVERTER_FACTORIES) {
            Class<IStringConverter<T>> result = f.getConverter(cls);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object convertValue(ParameterDescription pd, String value) {
        return this.convertValue(pd.getField(), pd.getField().getType(), value);
    }

    public Object convertValue(Field field, Class type2, String value) {
        Parameter annotation = field.getAnnotation(Parameter.class);
        Class<IStringConverter<Object>> converterClass = annotation.converter();
        if (converterClass == null || converterClass == NoConverter.class) {
            converterClass = this.findConverter(type2);
        }
        if (converterClass == null) {
            converterClass = StringConverter.class;
        }
        if (converterClass == null && Collection.class.isAssignableFrom(type2)) {
            converterClass = StringConverter.class;
        }
        if (converterClass == null) {
            throw new ParameterException("Don't know how to convert " + value + " to type " + type2 + " (field: " + field.getName() + ")");
        }
        Object result = null;
        try {
            String[] names = annotation.names();
            String optionName = names.length > 0 ? names[0] : "[Main class]";
            IStringConverter<?> converter = this.instantiateConverter(optionName, converterClass);
            result = converter.convert(value);
        }
        catch (InstantiationException e) {
            throw new ParameterException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParameterException(e);
        }
        catch (InvocationTargetException e) {
            throw new ParameterException(e);
        }
        return result;
    }

    private IStringConverter<?> instantiateConverter(String optionName, Class<? extends IStringConverter<?>> converterClass) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] ctors;
        Constructor<?> ctor = null;
        Constructor<?> stringCtor = null;
        for (Constructor<?> c : ctors = converterClass.getDeclaredConstructors()) {
            Class<?>[] types = c.getParameterTypes();
            if (types.length == 1 && types[0].equals(String.class)) {
                stringCtor = c;
                continue;
            }
            if (types.length != 0) continue;
            ctor = c;
        }
        IStringConverter result = stringCtor != null ? (IStringConverter)stringCtor.newInstance(optionName) : (IStringConverter)ctor.newInstance(new Object[0]);
        return result;
    }

    public void addCommand(String name, Object object) {
        JCommander jc = new JCommander(object);
        jc.setProgramName(name);
        this.m_commands.put(name, jc);
    }

    public Map<String, JCommander> getCommands() {
        return this.m_commands;
    }

    public String getParsedCommand() {
        return this.m_parsedCommand;
    }

    private String s(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    public List<Object> getObjects() {
        return this.m_objects;
    }

    static {
        CONVERTER_FACTORIES.add(new DefaultConverterFactory());
    }
}

