/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.HabitatListenerWeakProxy;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantFilter;
import org.jvnet.hk2.component.InhabitantTracker;
import org.jvnet.hk2.component.InhabitantTrackerContext;

class InhabitantTrackerImpl
implements InhabitantTracker,
HabitatListener {
    protected final Habitat h;
    protected final InhabitantTrackerContext itc;
    protected InhabitantTracker.Callback callback;
    private boolean open;
    private volatile boolean initialized;
    private CopyOnWriteArraySet<Inhabitant<?>> matches;

    public InhabitantTrackerImpl(Habitat h, InhabitantTrackerContext itc, InhabitantTracker.Callback callback) {
        this.h = h;
        this.itc = itc;
        this.open = true;
        if (null != callback) {
            this.checkInitializedListener();
            this.callback = callback;
            if (null != callback && null != this.matches && !this.matches.isEmpty() && this.isDone()) {
                callback.updated(this, h, true);
            }
        }
    }

    public String toString() {
        this.checkInitializedListener();
        String many = this.matches.size() > 1 ? ",..." : "";
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getInhabitant() + many + ")";
    }

    protected void checkInitializedListener() {
        if (!this.initialized) {
            this.initialized = true;
            this.h.addHabitatListener((HabitatListener)new HabitatListenerWeakProxy(this), this.itc.getClassNames());
            this.findInitialMatches();
        }
    }

    @Override
    public <T> Inhabitant<T> getInhabitant() throws ComponentException {
        if (!this.open) {
            return null;
        }
        this.checkInitializedListener();
        Inhabitant<?> best = null;
        Long bestSr = null;
        if (null != this.matches) {
            for (Inhabitant<?> next : this.matches) {
                if (null == best) {
                    best = next;
                    continue;
                }
                Long sr = Habitat.getServiceRanking(next, false);
                if (null == sr) continue;
                if (null == bestSr) {
                    bestSr = Habitat.getServiceRanking(best, true);
                }
                if (sr > bestSr) {
                    best = next;
                    bestSr = sr;
                    continue;
                }
                if (sr != bestSr || best.isInstantiated() || !next.isInstantiated()) continue;
                best = next;
            }
        }
        return best;
    }

    @Override
    public Collection<Inhabitant<?>> getInhabitants() throws ComponentException {
        this.checkInitializedListener();
        return null == this.matches ? Collections.EMPTY_SET : Collections.unmodifiableSet(this.matches);
    }

    @Override
    public void release() {
        if (this.open) {
            if (this.initialized) {
                this.h.removeHabitatListener(this);
                this.initialized = false;
            }
            this.open = false;
            this.matches = null;
            this.callback = null;
        }
    }

    @Override
    public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
        if (this.open && HabitatListener.EventType.INHABITANT_MODIFIED == eventType) {
            if (null != this.matches && this.matches.contains(inhabitant)) {
                InhabitantFilter filter = this.itc.getFilter();
                if (null != filter && !filter.matches(inhabitant)) {
                    this.updateMatched(HabitatListener.EventType.INHABITANT_INDEX_REMOVED, inhabitant);
                } else if (null != this.callback && this.isDone()) {
                    this.callback.updated(this, this.h, false);
                }
            } else {
                InhabitantFilter filter = this.itc.getFilter();
                if (null != filter && filter.matches(inhabitant)) {
                    if (null == this.matches) {
                        this.matches = new CopyOnWriteArraySet();
                    }
                    this.updateMatched(HabitatListener.EventType.INHABITANT_INDEX_ADDED, inhabitant);
                }
            }
        }
        return this.open;
    }

    @Override
    public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
        InhabitantFilter filter;
        if (this.open && (HabitatListener.EventType.INHABITANT_INDEX_ADDED == eventType || HabitatListener.EventType.INHABITANT_INDEX_REMOVED == eventType) && this.itc.getClassNames().contains(index) && (null == (filter = this.itc.getFilter()) || filter.matches(inhabitant))) {
            if (null == this.matches) {
                this.matches = new CopyOnWriteArraySet();
            }
            this.updateMatched(eventType, inhabitant);
        }
        return this.open;
    }

    protected void updateMatched(HabitatListener.EventType eventType, Inhabitant<?> inhabitant) {
        boolean updated = HabitatListener.EventType.INHABITANT_INDEX_ADDED == eventType ? this.matches.add(inhabitant) : this.matches.remove(inhabitant);
        if (updated && null != this.callback && this.isDone()) {
            this.callback.updated(this, this.h, false);
        }
    }

    protected void findInitialMatches() {
        for (String contractName : this.itc.getClassNames()) {
            Collection<Inhabitant<?>> coll = this.h.getAllInhabitantsByContract(contractName);
            for (Inhabitant<?> i : coll) {
                this.inhabitantIndexChanged(HabitatListener.EventType.INHABITANT_INDEX_ADDED, this.h, i, contractName, null, null);
            }
        }
    }

    public boolean isDone() {
        Boolean presence = this.itc.getPresenceFlag();
        if (null == presence) {
            return true;
        }
        if (presence.booleanValue()) {
            return !this.getInhabitants().isEmpty();
        }
        return this.getInhabitants().isEmpty();
    }
}

