/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.constraints.CompositionType;
import org.hibernate.validator.constraints.ConstraintComposition;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.util.annotationfactory.AnnotationFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDescriptorImpl<T extends Annotation>
implements ConstraintDescriptor<T>,
Serializable {
    private static final long serialVersionUID = -2563102960314069246L;
    private static final Logger log = LoggerFactory.make();
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private static final String GROUPS = "groups";
    private static final String PAYLOAD = "payload";
    private static final List<String> NON_COMPOSING_CONSTRAINT_ANNOTATIONS = new ArrayList<String>();
    private final T annotation;
    private final Class<T> annotationType;
    private final List<Class<? extends ConstraintValidator<T, ?>>> constraintValidatorDefinitionClasses;
    private final Set<Class<?>> groups;
    private final Map<String, Object> attributes;
    private final Set<Class<? extends Payload>> payloads;
    private final Set<ConstraintDescriptor<?>> composingConstraints;
    private final boolean isReportAsSingleInvalidConstraint;
    private final ElementType elementType;
    private final ConstraintOrigin definedOn;
    private CompositionType compositionType = CompositionType.AND;
    private final transient ConstraintHelper constraintHelper;

    public ConstraintDescriptorImpl(T annotation, ConstraintHelper constraintHelper, Class<?> implicitGroup, ElementType type2, ConstraintOrigin definedOn) {
        this.annotation = annotation;
        this.annotationType = this.annotation.annotationType();
        this.constraintHelper = constraintHelper;
        this.elementType = type2;
        this.definedOn = definedOn;
        this.isReportAsSingleInvalidConstraint = this.annotationType.isAnnotationPresent(ReportAsSingleViolation.class);
        this.attributes = this.buildAnnotationParameterMap((Annotation)annotation);
        this.groups = this.buildGroupSet(implicitGroup);
        this.payloads = this.buildPayloadSet(annotation);
        this.constraintValidatorDefinitionClasses = this.findConstraintValidatorClasses();
        this.composingConstraints = this.parseComposingConstraints();
    }

    public ConstraintDescriptorImpl(T annotation, ConstraintHelper constraintHelper, ElementType type2, ConstraintOrigin definedOn) {
        this(annotation, constraintHelper, null, type2, definedOn);
    }

    private Set<Class<? extends Payload>> buildPayloadSet(T annotation) {
        Class[] payloadFromAnnotation;
        HashSet<Class> payloadSet = new HashSet<Class>();
        try {
            payloadFromAnnotation = ReflectionHelper.getAnnotationParameter(annotation, PAYLOAD, Class[].class);
        }
        catch (ValidationException e) {
            payloadFromAnnotation = null;
        }
        if (payloadFromAnnotation != null) {
            payloadSet.addAll(Arrays.asList(payloadFromAnnotation));
        }
        return Collections.unmodifiableSet(payloadSet);
    }

    private Set<Class<?>> buildGroupSet(Class<?> implicitGroup) {
        HashSet groupSet = new HashSet();
        Class[] groupsFromAnnotation = ReflectionHelper.getAnnotationParameter(this.annotation, GROUPS, Class[].class);
        if (groupsFromAnnotation.length == 0) {
            groupSet.add(Default.class);
        } else {
            groupSet.addAll(Arrays.asList(groupsFromAnnotation));
        }
        if (implicitGroup != null && groupSet.contains(Default.class)) {
            groupSet.add(implicitGroup);
        }
        return Collections.unmodifiableSet(groupSet);
    }

    private List<Class<? extends ConstraintValidator<T, ?>>> findConstraintValidatorClasses() {
        ArrayList<Class> constraintValidatorClasses = new ArrayList<Class>();
        if (this.constraintHelper.containsConstraintValidatorDefinition(this.annotationType)) {
            for (Class<ConstraintValidator<T, ?>> validator : this.constraintHelper.getConstraintValidatorDefinition(this.annotationType)) {
                constraintValidatorClasses.add(validator);
            }
            return Collections.unmodifiableList(constraintValidatorClasses);
        }
        ArrayList constraintDefinitionClasses = new ArrayList();
        if (this.constraintHelper.isBuiltinConstraint(this.annotationType)) {
            constraintDefinitionClasses.addAll(this.constraintHelper.getBuiltInConstraints(this.annotationType));
        } else {
            Class<? extends ConstraintValidator<?, ?>>[] validatedBy = this.annotationType.getAnnotation(Constraint.class).validatedBy();
            constraintDefinitionClasses.addAll(Arrays.asList(validatedBy));
        }
        this.constraintHelper.addConstraintValidatorDefinition(this.annotationType, constraintDefinitionClasses);
        Iterator i$ = constraintDefinitionClasses.iterator();
        while (i$.hasNext()) {
            Class validator;
            Class safeValidator = validator = (Class)i$.next();
            constraintValidatorClasses.add(safeValidator);
        }
        return Collections.unmodifiableList(constraintValidatorClasses);
    }

    @Override
    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Class<? extends Payload>> getPayload() {
        return this.payloads;
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return this.constraintValidatorDefinitionClasses;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return this.composingConstraints;
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ConstraintOrigin getDefinedOn() {
        return this.definedOn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstraintDescriptorImpl that = (ConstraintDescriptorImpl)o;
        return !(this.annotation != null ? !this.annotation.equals(that.annotation) : that.annotation != null);
    }

    public int hashCode() {
        return this.annotation != null ? this.annotation.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintDescriptorImpl");
        sb.append("{annotation=").append(this.annotationType.getName());
        sb.append(", payloads=").append(this.payloads);
        sb.append(", hasComposingConstraints=").append(this.composingConstraints.isEmpty());
        sb.append(", isReportAsSingleInvalidConstraint=").append(this.isReportAsSingleInvalidConstraint);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", definedOn=").append((Object)this.definedOn);
        sb.append(", groups=").append(this.groups);
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    private Map<String, Object> buildAnnotationParameterMap(Annotation annotation) {
        Method[] declaredMethods = ReflectionHelper.getDeclaredMethods(annotation.annotationType());
        HashMap<String, Object> parameters = new HashMap<String, Object>(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to read annotation attributes: " + annotation.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to read annotation attributes: " + annotation.getClass(), e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private Object getMethodValue(Annotation annotation, Method m) {
        Object value;
        try {
            value = m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.", e);
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.", e);
        }
        return value;
    }

    private Map<ClassIndexWrapper, Map<String, Object>> parseOverrideParameters() {
        Method[] methods;
        HashMap<ClassIndexWrapper, Map<String, Object>> overrideParameters = new HashMap<ClassIndexWrapper, Map<String, Object>>();
        for (Method m : methods = ReflectionHelper.getDeclaredMethods(this.annotationType)) {
            if (m.getAnnotation(OverridesAttribute.class) != null) {
                this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.class));
                continue;
            }
            if (m.getAnnotation(OverridesAttribute.List.class) == null) continue;
            this.addOverrideAttributes(overrideParameters, m, m.getAnnotation(OverridesAttribute.List.class).value());
        }
        return overrideParameters;
    }

    private void addOverrideAttributes(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Method m, OverridesAttribute ... attributes) {
        Object value = this.getMethodValue((Annotation)this.annotation, m);
        for (OverridesAttribute overridesAttribute : attributes) {
            this.ensureAttributeIsOverridable(m, overridesAttribute);
            ClassIndexWrapper wrapper = new ClassIndexWrapper(overridesAttribute.constraint(), overridesAttribute.constraintIndex());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = new HashMap<String, Object>();
                overrideParameters.put(wrapper, map);
            }
            map.put(overridesAttribute.name(), value);
        }
    }

    private void ensureAttributeIsOverridable(Method m, OverridesAttribute overridesAttribute) {
        Method method = ReflectionHelper.getMethod(overridesAttribute.constraint(), overridesAttribute.name());
        if (method == null) {
            throw new ConstraintDefinitionException("Overridden constraint does not define an attribute with name " + overridesAttribute.name());
        }
        Class<?> returnTypeOfOverriddenConstraint = method.getReturnType();
        if (!returnTypeOfOverriddenConstraint.equals(m.getReturnType())) {
            String message = "The overriding type of a composite constraint must be identical to the overridden one. Expected " + returnTypeOfOverriddenConstraint.getName() + " found " + m.getReturnType();
            throw new ConstraintDefinitionException(message);
        }
    }

    private Set<ConstraintDescriptor<?>> parseComposingConstraints() {
        HashSet<ConstraintDescriptorImpl<Annotation>> composingConstraintsSet = new HashSet<ConstraintDescriptorImpl<Annotation>>();
        Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = this.parseOverrideParameters();
        for (Annotation declaredAnnotation : this.annotationType.getDeclaredAnnotations()) {
            Class<? extends Annotation> declaredAnnotationType = declaredAnnotation.annotationType();
            if (NON_COMPOSING_CONSTRAINT_ANNOTATIONS.contains(declaredAnnotationType.getName())) continue;
            if (this.constraintHelper.isConstraintComposition(declaredAnnotationType)) {
                this.setCompositionType(((ConstraintComposition)declaredAnnotation).value());
                if (!log.isDebugEnabled()) continue;
                log.debug("Adding Bool" + declaredAnnotationType.getName());
                continue;
            }
            if (this.constraintHelper.isConstraintAnnotation(declaredAnnotationType) || this.constraintHelper.isBuiltinConstraint(declaredAnnotationType)) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(declaredAnnotation, overrideParameters, -1);
                composingConstraintsSet.add(descriptor);
                if (!log.isDebugEnabled()) continue;
                log.debug("Adding composing constraint: " + descriptor);
                continue;
            }
            if (!this.constraintHelper.isMultiValueConstraint(declaredAnnotationType)) continue;
            List<Annotation> multiValueConstraints = this.constraintHelper.getMultiValueConstraints(declaredAnnotation);
            int index = 0;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl<Annotation> descriptor = this.createComposingConstraintDescriptor(constraintAnnotation, overrideParameters, index);
                composingConstraintsSet.add(descriptor);
                if (log.isDebugEnabled()) {
                    log.debug("Adding composing constraint: " + descriptor);
                }
                ++index;
            }
        }
        return Collections.unmodifiableSet(composingConstraintsSet);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(U declaredAnnotation, Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index) {
        Class<? extends Annotation> annotationType = declaredAnnotation.annotationType();
        return this.createComposingConstraintDescriptor(overrideParameters, index, declaredAnnotation, annotationType);
    }

    private <U extends Annotation> ConstraintDescriptorImpl<U> createComposingConstraintDescriptor(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, int index, U constraintAnnotation, Class<U> annotationType) {
        AnnotationDescriptor<U> annotationDescriptor = new AnnotationDescriptor<U>(annotationType, this.buildAnnotationParameterMap(constraintAnnotation));
        Map<String, Object> overrides = overrideParameters.get(new ClassIndexWrapper(annotationType, index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        annotationDescriptor.setValue(GROUPS, this.groups.toArray(new Class[this.groups.size()]));
        annotationDescriptor.setValue(PAYLOAD, this.payloads.toArray(new Class[this.payloads.size()]));
        U annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl<U>(annotationProxy, this.constraintHelper, this.elementType, this.definedOn);
    }

    public void setCompositionType(CompositionType compositionType) {
        this.compositionType = compositionType;
    }

    public CompositionType getCompositionType() {
        return this.compositionType;
    }

    static {
        NON_COMPOSING_CONSTRAINT_ANNOTATIONS.add(Documented.class.getName());
        NON_COMPOSING_CONSTRAINT_ANNOTATIONS.add(Retention.class.getName());
        NON_COMPOSING_CONSTRAINT_ANNOTATIONS.add(Target.class.getName());
        NON_COMPOSING_CONSTRAINT_ANNOTATIONS.add(Constraint.class.getName());
        NON_COMPOSING_CONSTRAINT_ANNOTATIONS.add(ReportAsSingleViolation.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            if (this.clazz != null && !this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.clazz != null || that.clazz == null;
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

