/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.engine.MethodValidationContext;
import org.hibernate.validator.engine.PathImpl;
import org.hibernate.validator.engine.ValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.engine.groups.Group;
import org.hibernate.validator.engine.groups.GroupChain;
import org.hibernate.validator.engine.groups.GroupChainGenerator;
import org.hibernate.validator.engine.resolver.SingleThreadCachedTraversableResolver;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.metadata.AggregatedMethodMetaData;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.metadata.MethodMetaConstraint;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.method.MethodConstraintViolation;
import org.hibernate.validator.method.MethodValidator;
import org.hibernate.validator.method.metadata.TypeDescriptor;
import org.hibernate.validator.util.CollectionHelper;
import org.hibernate.validator.util.Contracts;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorImpl
implements Validator,
MethodValidator {
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final transient GroupChainGenerator groupChainGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;
    private final boolean failFast;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache, boolean failFast) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.constraintHelper = constraintHelper;
        this.beanMetaDataCache = beanMetaDataCache;
        this.failFast = failFast;
        this.groupChainGenerator = new GroupChainGenerator();
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validation of a null object");
        }
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> validationContext = ValidationContext.getContextForValidate(object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        ValueContext valueContext = ValueContext.getLocalExecutionContext(object, PathImpl.createRootPath());
        return this.validateInContext(valueContext, validationContext, groupChain);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validated object cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> context = ValidationContext.getContextForValidateProperty(object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        return this.validatePropertyInContext(context, PathImpl.createPathFromString(propertyName), groupChain);
    }

    @Override
    public final <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        if (beanType == null) {
            throw new IllegalArgumentException("The bean type cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ValidationContext<T, ConstraintViolation<T>> context = ValidationContext.getContextForValidateValue(beanType, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        return this.validateValueInContext(context, value, PathImpl.createPathFromString(propertyName), groupChain);
    }

    @Override
    public final <T> Set<MethodConstraintViolation<T>> validateParameter(T object, Method method, Object parameterValue, int parameterIndex, Class<?> ... groups) {
        Contracts.assertNotNull(object, "The object to be validated must not be null");
        Contracts.assertNotNull(method, "The method to be validated must not be null");
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameter(method, parameterIndex, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        Object[] parameterValues = new Object[method.getParameterTypes().length];
        parameterValues[parameterIndex] = parameterValue;
        this.validateParametersInContext(context, object, parameterValues, groupChain);
        return context.getFailingConstraints();
    }

    @Override
    public final <T> Set<MethodConstraintViolation<T>> validateAllParameters(T object, Method method, Object[] parameterValues, Class<?> ... groups) {
        Contracts.assertNotNull(object, "The object to be validated must not be null");
        Contracts.assertNotNull(method, "The method to be validated must not be null");
        if (parameterValues == null) {
            return Collections.emptySet();
        }
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameters(method, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        this.validateParametersInContext(context, object, parameterValues, groupChain);
        return context.getFailingConstraints();
    }

    @Override
    public <T> Set<MethodConstraintViolation<T>> validateReturnValue(T object, Method method, Object returnValue, Class<?> ... groups) {
        Contracts.assertNotNull(method, "The method to be validated must not be null");
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        MethodValidationContext<T> context = ValidationContext.getContextForValidateParameters(method, object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver(), this.failFast);
        this.validateReturnValueInContext(context, object, returnValue, groupChain);
        return context.getFailingConstraints();
    }

    @Override
    public final BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.getBeanMetaData(clazz).getBeanDescriptor();
    }

    @Override
    public final TypeDescriptor getConstraintsForType(Class<?> clazz) {
        return this.getBeanMetaData(clazz).getTypeDescriptor();
    }

    @Override
    public final <T> T unwrap(Class<T> type2) {
        if (type2.isAssignableFrom(this.getClass())) {
            return type2.cast(this);
        }
        throw new ValidationException("Type " + type2 + " not supported");
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Invalid property path.");
        }
    }

    private GroupChain determineGroupExecutionOrder(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("null passed as group name");
        }
        Class<?>[] tmpGroups = groups;
        if (tmpGroups.length == 0) {
            tmpGroups = DEFAULT_GROUP_ARRAY;
        }
        return this.groupChainGenerator.getGroupChainFor(Arrays.asList(tmpGroups));
    }

    private <T, U, V, E extends ConstraintViolation<T>> Set<E> validateInContext(ValueContext<U, V> valueContext, ValidationContext<T, E> context, GroupChain groupChain) {
        Group group2;
        if (valueContext.getCurrentBean() == null) {
            return Collections.emptySet();
        }
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getGroup());
            this.validateConstraintsForCurrentGroup(context, valueContext);
            if (!context.shouldFailFast()) continue;
            return context.getFailingConstraints();
        }
        groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getGroup());
            this.validateCascadedConstraints(context, valueContext);
            if (!context.shouldFailFast()) continue;
            return context.getFailingConstraints();
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group3 : sequence) {
                int numberOfViolations = context.getFailingConstraints().size();
                valueContext.setCurrentGroup(group3.getGroup());
                this.validateConstraintsForCurrentGroup(context, valueContext);
                if (context.shouldFailFast()) {
                    return context.getFailingConstraints();
                }
                this.validateCascadedConstraints(context, valueContext);
                if (context.shouldFailFast()) {
                    return context.getFailingConstraints();
                }
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForCurrentGroup(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext) {
        if (!valueContext.validatingDefault()) {
            this.validateConstraintsForNonDefaultGroup(validationContext, valueContext);
        } else {
            this.validateConstraintsForDefaultGroup(validationContext, valueContext);
        }
    }

    private <T, U, V, E extends ConstraintViolation<T>> void validateConstraintsForDefaultGroup(ValidationContext<T, E> validationContext, ValueContext<U, V> valueContext) {
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<?> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<?> hostingBeanMetaData = this.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            List<Class<?>> defaultGroupSequence = hostingBeanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean());
            Set<BeanMetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
            if (defaultGroupSequenceIsRedefined) {
                metaConstraints = hostingBeanMetaData.getMetaConstraints();
            }
            PathImpl currentPath = valueContext.getPropertyPath();
            for (Class<?> defaultSequenceMember : defaultGroupSequence) {
                valueContext.setCurrentGroup(defaultSequenceMember);
                boolean validationSuccessful = true;
                for (BeanMetaConstraint<?> metaConstraint : metaConstraints) {
                    Class<?> declaringClass = metaConstraint.getLocation().getBeanClass();
                    if (declaringClass.isInterface()) {
                        Class validatedForClass = (Class)validatedInterfaces.get(declaringClass);
                        if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                        validatedInterfaces.put(declaringClass, clazz);
                    }
                    boolean tmp = this.validateConstraint(validationContext, valueContext, metaConstraint);
                    if (validationContext.shouldFailFast()) {
                        return;
                    }
                    validationSuccessful = validationSuccessful && tmp;
                    valueContext.setPropertyPath(currentPath);
                    validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
                }
                if (validationSuccessful) continue;
                break;
            }
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
    }

    private <T, U, V> void validateConstraintsForNonDefaultGroup(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext) {
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        PathImpl currentPath = valueContext.getPropertyPath();
        for (BeanMetaConstraint<?> metaConstraint : beanMetaData.getMetaConstraints()) {
            this.validateConstraint(validationContext, valueContext, metaConstraint);
            if (validationContext.shouldFailFast()) {
                return;
            }
            valueContext.setPropertyPath(currentPath);
        }
        validationContext.markProcessed(valueContext.getCurrentBean(), valueContext.getCurrentGroup(), valueContext.getPropertyPath());
    }

    private <T, U, V> boolean validateConstraint(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext, BeanMetaConstraint<?> metaConstraint) {
        boolean validationSuccessful = true;
        if (metaConstraint.getElementType() != ElementType.TYPE) {
            valueContext.appendNode(metaConstraint.getLocation().getPropertyName());
        }
        if (this.isValidationRequired(validationContext, valueContext, metaConstraint)) {
            Object valueToValidate = metaConstraint.getValue(valueContext.getCurrentBean());
            valueContext.setCurrentValidatedValue(valueToValidate);
            validationSuccessful = metaConstraint.validateConstraint(validationContext, valueContext);
        }
        return validationSuccessful;
    }

    private <T, U, V> void validateCascadedConstraints(ValidationContext<T, ?> validationContext, ValueContext<U, V> valueContext) {
        Set<Member> cascadedMembers = this.getBeanMetaData(valueContext.getCurrentBeanType()).getCascadedMembers();
        PathImpl currentPath = valueContext.getPropertyPath();
        for (Member member : cascadedMembers) {
            Object value;
            String newNode = ReflectionHelper.getPropertyName(member);
            valueContext.appendNode(newNode);
            if (this.isCascadeRequired(validationContext, valueContext, member) && (value = ReflectionHelper.getValue(member, valueContext.getCurrentBean())) != null) {
                Class<?> type2 = value.getClass();
                Iterator<?> iter = this.createIteratorForCascadedValue(type2, value, valueContext);
                boolean isIndexable = this.isIndexable(type2);
                this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext);
                if (validationContext.shouldFailFast()) {
                    return;
                }
            }
            valueContext.setPropertyPath(currentPath);
        }
    }

    private <T, U, V> void validateCascadedMethodConstraints(MethodValidationContext<T> validationContext, ValueContext<U, V> valueContext) {
        U value = valueContext.getCurrentBean();
        Class<U> type2 = valueContext.getCurrentBeanType();
        Iterator<?> iter = this.createIteratorForCascadedValue(type2, value, valueContext);
        boolean isIndexable = this.isIndexable(type2);
        this.validateCascadedConstraint(validationContext, iter, isIndexable, valueContext);
    }

    private Iterator<?> createIteratorForCascadedValue(Type type2, Object value, ValueContext<?, ?> valueContext) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type2)) {
            iter = ((Iterable)value).iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (ReflectionHelper.isMap(type2)) {
            Map map = (Map)value;
            iter = map.entrySet().iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else if (TypeUtils.isArray(type2)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
            valueContext.markCurrentPropertyAsIterable();
        } else {
            ArrayList list = CollectionHelper.newArrayList();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private boolean isIndexable(Type type2) {
        boolean isIndexable = false;
        if (ReflectionHelper.isList(type2)) {
            isIndexable = true;
        } else if (ReflectionHelper.isMap(type2)) {
            isIndexable = true;
        } else if (TypeUtils.isArray(type2)) {
            isIndexable = true;
        }
        return isIndexable;
    }

    private <T> void validateCascadedConstraint(ValidationContext<T, ?> context, Iterator<?> iter, boolean isIndexable, ValueContext<?, ?> valueContext) {
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof Map.Entry) {
                Object mapKey = ((Map.Entry)value).getKey();
                valueContext.setKey(mapKey);
                value = ((Map.Entry)value).getValue();
            } else if (isIndexable) {
                valueContext.setIndex(i);
            }
            if (!context.isAlreadyValidated(value, valueContext.getCurrentGroup(), valueContext.getPropertyPath())) {
                GroupChain groupChain = this.groupChainGenerator.getGroupChainFor(Arrays.asList(valueContext.getCurrentGroup()));
                ValueContext newValueContext = value != null ? ValueContext.getLocalExecutionContext(value, valueContext.getPropertyPath()) : ValueContext.getLocalExecutionContext(valueContext.getCurrentBeanType(), valueContext.getPropertyPath());
                if (valueContext.getParameterIndex() != null) {
                    newValueContext.setParameterIndex(valueContext.getParameterIndex());
                    newValueContext.setParameterName(valueContext.getParameterName());
                }
                this.validateInContext(newValueContext, context, groupChain);
                if (context.shouldFailFast()) {
                    return;
                }
            }
            ++i;
        }
    }

    private <T, U, V> Set<ConstraintViolation<T>> validatePropertyInContext(ValidationContext<T, ConstraintViolation<T>> context, PathImpl propertyPath, GroupChain groupChain) {
        ArrayList<BeanMetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        Iterator<Path.Node> propertyIter = propertyPath.iterator();
        ValueContext<U, V> valueContext = this.collectMetaConstraintsForPath(context.getRootBeanClass(), context.getRootBean(), propertyIter, propertyPath, metaConstraints);
        if (valueContext.getCurrentBean() == null) {
            throw new IllegalArgumentException("Invalid property path.");
        }
        if (metaConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean()));
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getGroup());
            this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
            if (!context.shouldFailFast()) continue;
            return context.getFailingConstraints();
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group3 : sequence) {
                valueContext.setCurrentGroup(group3.getGroup());
                int numberOfConstraintViolations = this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
                if (context.shouldFailFast()) {
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V> Set<ConstraintViolation<T>> validateValueInContext(ValidationContext<T, ConstraintViolation<T>> context, V value, PathImpl propertyPath, GroupChain groupChain) {
        ArrayList<BeanMetaConstraint<?>> metaConstraints = CollectionHelper.newArrayList();
        ValueContext<U, V> valueContext = this.collectMetaConstraintsForPath(context.getRootBeanClass(), null, propertyPath.iterator(), propertyPath, metaConstraints);
        valueContext.setCurrentValidatedValue(value);
        if (metaConstraints.size() == 0) {
            return context.getFailingConstraints();
        }
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(null));
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group2 = groupIterator.next();
            valueContext.setCurrentGroup(group2.getGroup());
            this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
            if (!context.shouldFailFast()) continue;
            return context.getFailingConstraints();
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group3 : sequence) {
                valueContext.setCurrentGroup(group3.getGroup());
                int numberOfConstraintViolations = this.validatePropertyForCurrentGroup(valueContext, context, metaConstraints);
                if (context.shouldFailFast()) {
                    return context.getFailingConstraints();
                }
                if (numberOfConstraintViolations <= 0) continue;
                continue block1;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V> int validatePropertyForCurrentGroup(ValueContext<U, V> valueContext, ValidationContext<T, ConstraintViolation<T>> validationContext, List<BeanMetaConstraint<?>> metaConstraints) {
        if (!valueContext.validatingDefault()) {
            return this.validatePropertyForNonDefaultGroup(valueContext, validationContext, metaConstraints);
        }
        return this.validatePropertyForDefaultGroup(valueContext, validationContext, metaConstraints);
    }

    private <T, U, V> int validatePropertyForNonDefaultGroup(ValueContext<U, V> valueContext, ValidationContext<T, ConstraintViolation<T>> validationContext, List<BeanMetaConstraint<?>> metaConstraints) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        for (BeanMetaConstraint<ConstraintViolation<T>> beanMetaConstraint : metaConstraints) {
            if (!this.isValidationRequired(validationContext, valueContext, beanMetaConstraint)) continue;
            if (valueContext.getCurrentBean() != null) {
                Object valueToValidate = beanMetaConstraint.getValue(valueContext.getCurrentBean());
                valueContext.setCurrentValidatedValue(valueToValidate);
            }
            beanMetaConstraint.validateConstraint(validationContext, valueContext);
            if (!validationContext.shouldFailFast()) continue;
            return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <T, U, V> int validatePropertyForDefaultGroup(ValueContext<U, V> valueContext, ValidationContext<T, ConstraintViolation<T>> validationContext, List<BeanMetaConstraint<?>> constraintList) {
        int numberOfConstraintViolationsBefore = validationContext.getFailingConstraints().size();
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(valueContext.getCurrentBeanType());
        HashMap<Class<?>, Class<?>> validatedInterfaces = CollectionHelper.newHashMap();
        for (Class<?> clazz : beanMetaData.getClassHierarchy()) {
            BeanMetaData<?> hostingBeanMetaData = this.getBeanMetaData(clazz);
            boolean defaultGroupSequenceIsRedefined = hostingBeanMetaData.defaultGroupSequenceIsRedefined();
            Set<BeanMetaConstraint<?>> metaConstraints = hostingBeanMetaData.getDirectMetaConstraints();
            List<Class<?>> defaultGroupSequence = hostingBeanMetaData.getDefaultGroupSequence(valueContext.getCurrentBean());
            if (defaultGroupSequenceIsRedefined) {
                metaConstraints = hostingBeanMetaData.getMetaConstraints();
            }
            for (Class<?> groupClass : defaultGroupSequence) {
                boolean validationSuccessful = true;
                valueContext.setCurrentGroup(groupClass);
                for (BeanMetaConstraint<ConstraintViolation<T>> beanMetaConstraint : metaConstraints) {
                    Class<?> declaringClass = beanMetaConstraint.getLocation().getBeanClass();
                    if (declaringClass.isInterface()) {
                        Class validatedForClass = (Class)validatedInterfaces.get(declaringClass);
                        if (validatedForClass != null && !validatedForClass.equals(clazz)) continue;
                        validatedInterfaces.put(declaringClass, clazz);
                    }
                    if (!constraintList.contains(beanMetaConstraint) || !this.isValidationRequired(validationContext, valueContext, beanMetaConstraint)) continue;
                    if (valueContext.getCurrentBean() != null) {
                        Object valueToValidate = beanMetaConstraint.getValue(valueContext.getCurrentBean());
                        valueContext.setCurrentValidatedValue(valueToValidate);
                    }
                    boolean tmp = beanMetaConstraint.validateConstraint(validationContext, valueContext);
                    boolean bl = validationSuccessful = validationSuccessful && tmp;
                    if (!validationContext.shouldFailFast()) continue;
                    return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
                }
                if (validationSuccessful) continue;
                break;
            }
            if (!defaultGroupSequenceIsRedefined) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfConstraintViolationsBefore;
    }

    private <T> void validateParametersInContext(MethodValidationContext<T> validationContext, T object, Object[] parameterValues, GroupChain groupChain) {
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(validationContext.getRootBeanClass());
        AggregatedMethodMetaData methodMetaData = beanMetaData.getMetaDataFor(validationContext.getMethod());
        methodMetaData.assertCorrectnessOfMethodParameterConstraints();
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(object));
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateParametersForGroup(validationContext, object, parameterValues, groupIterator.next());
            if (!validationContext.shouldFailFast()) continue;
            return;
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group2 : sequence) {
                int numberOfFailingConstraint = this.validateParametersForGroup(validationContext, object, parameterValues, group2);
                if (validationContext.shouldFailFast()) {
                    return;
                }
                if (numberOfFailingConstraint <= 0) continue;
                continue block1;
            }
        }
    }

    private <T> int validateParametersForGroup(MethodValidationContext<T> validationContext, T object, Object[] parameterValues, Group group2) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        Method method = validationContext.getMethod();
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(validationContext.getRootBeanClass());
        AggregatedMethodMetaData methodMetaData = beanMetaData.getMetaDataFor(method);
        List<Class<Object>> groupList = group2.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence(object) : Arrays.asList(group2.getGroup());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            for (int i = 0; i < parameterValues.length; ++i) {
                if (validationContext.getParameterIndex() != null && !validationContext.getParameterIndex().equals(i)) continue;
                Object value = parameterValues[i];
                String parameterName = methodMetaData.getParameterMetaData(i).getParameterName();
                ValueContext<T, Object> valueContext = ValueContext.getLocalExecutionContext(object, PathImpl.createPathForMethodParameter(method, parameterName), i, parameterName);
                valueContext.setCurrentValidatedValue(value);
                valueContext.setCurrentGroup(oneGroup);
                numberOfViolationsOfCurrentGroup += this.validateParameterForGroup(validationContext, valueContext, methodMetaData.getParameterMetaData(i));
                if (!validationContext.shouldFailFast()) continue;
                return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            if (validationContext.getParameterIndex() != null && !validationContext.getParameterIndex().equals(i)) continue;
            Object value = parameterValues[i];
            ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(i);
            String parameterName = parameterMetaData.getParameterName();
            if (!parameterMetaData.isCascading() || value == null) continue;
            ValueContext cascadingvalueContext = ValueContext.getLocalExecutionContext(value, PathImpl.createPathForMethodParameter(method, parameterName), i, parameterName);
            cascadingvalueContext.setCurrentGroup(group2.getGroup());
            this.validateCascadedMethodConstraints(validationContext, cascadingvalueContext);
            if (validationContext.shouldFailFast()) break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, U, V> int validateParameterForGroup(MethodValidationContext<T> validationContext, ValueContext<U, V> valueContext, ParameterMetaData parameterMetaData) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (MethodMetaConstraint<?> metaConstraint : parameterMetaData) {
            if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!validationContext.shouldFailFast()) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <V, T> void validateReturnValueInContext(MethodValidationContext<T> context, T bean, V value, GroupChain groupChain) {
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(context.getRootBeanClass());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence(bean));
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            this.validateReturnValueForGroup(context, bean, value, groupIterator.next());
            if (!context.shouldFailFast()) continue;
            return;
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group2 : sequence) {
                int numberOfFailingConstraint = this.validateReturnValueForGroup(context, bean, value, group2);
                if (context.shouldFailFast()) {
                    return;
                }
                if (numberOfFailingConstraint <= 0) continue;
                continue block1;
            }
        }
    }

    private <T, V> int validateReturnValueForGroup(MethodValidationContext<T> validationContext, T bean, V value, Group group2) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        Method method = validationContext.getMethod();
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(validationContext.getRootBeanClass());
        AggregatedMethodMetaData methodMetaData = beanMetaData.getMetaDataFor(method);
        List<Class<Object>> groupList = group2.isDefaultGroup() ? beanMetaData.getDefaultGroupSequence(bean) : Arrays.asList(group2.getGroup());
        for (Class<?> oneGroup : groupList) {
            int numberOfViolationsOfCurrentGroup = 0;
            ValueContext<T, V> valueContext = ValueContext.getLocalExecutionContext(bean, PathImpl.createPathForMethodReturnValue(method));
            valueContext.setCurrentValidatedValue(value);
            valueContext.setCurrentGroup(oneGroup);
            numberOfViolationsOfCurrentGroup += this.validateReturnValueForGroup(validationContext, valueContext, methodMetaData);
            if (validationContext.shouldFailFast()) {
                return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
            }
            if (numberOfViolationsOfCurrentGroup <= 0) continue;
            break;
        }
        if (methodMetaData.isCascading() && value != null) {
            ValueContext cascadingvalueContext = ValueContext.getLocalExecutionContext(value, PathImpl.createPathForMethodReturnValue(method));
            cascadingvalueContext.setCurrentGroup(group2.getGroup());
            this.validateCascadedMethodConstraints(validationContext, cascadingvalueContext);
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, V> int validateReturnValueForGroup(MethodValidationContext<T> validationContext, ValueContext<T, V> valueContext, AggregatedMethodMetaData methodMetaData) {
        int numberOfViolationsBefore = validationContext.getFailingConstraints().size();
        for (MethodMetaConstraint<?> metaConstraint : methodMetaData) {
            if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) continue;
            metaConstraint.validateConstraint(validationContext, valueContext);
            if (!validationContext.shouldFailFast()) continue;
            break;
        }
        return validationContext.getFailingConstraints().size() - numberOfViolationsBefore;
    }

    private <T, U, V> ValueContext<U, V> collectMetaConstraintsForPath(Class<T> clazz, Object value, Iterator<Path.Node> propertyIter, PathImpl propertyPath, List<BeanMetaConstraint<?>> metaConstraintsList) {
        Path.Node elem = propertyIter.next();
        Object newValue = value;
        BeanMetaData<Object> metaData = this.getBeanMetaData(clazz);
        if (!metaData.isPropertyPresent(elem.getName())) {
            throw new IllegalArgumentException("Invalid property path. There is no property " + elem.getName() + " in entity " + metaData.getBeanClass().getName());
        }
        if (!propertyIter.hasNext()) {
            for (Class<?> hierarchyClass : metaData.getClassHierarchy()) {
                metaData = this.getBeanMetaData(hierarchyClass);
                for (BeanMetaConstraint<?> constraint : metaData.getDirectMetaConstraints()) {
                    if (elem.getName() == null || !elem.getName().equals(constraint.getLocation().getPropertyName())) continue;
                    metaConstraintsList.add(constraint);
                }
            }
        } else {
            Set<Member> cascadedMembers = metaData.getCascadedMembers();
            for (Member m : cascadedMembers) {
                if (!ReflectionHelper.getPropertyName(m).equals(elem.getName())) continue;
                Type type2 = ReflectionHelper.typeOf(m);
                Object object = newValue = newValue == null ? null : ReflectionHelper.getValue(m, newValue);
                if (elem.isInIterable()) {
                    if (newValue != null && elem.getIndex() != null) {
                        newValue = ReflectionHelper.getIndexedValue(newValue, elem.getIndex());
                    } else if (newValue != null && elem.getKey() != null) {
                        newValue = ReflectionHelper.getMappedValue(newValue, elem.getKey());
                    } else if (newValue != null) {
                        throw new IllegalArgumentException("Property path must provide index or map key");
                    }
                    type2 = ReflectionHelper.getIndexedType(type2);
                }
                Class<?> castedValueClass = newValue == null ? type2 : newValue.getClass();
                Object castedValue = newValue;
                return this.collectMetaConstraintsForPath(castedValueClass, castedValue, propertyIter, propertyPath, metaConstraintsList);
            }
        }
        if (newValue == null) {
            return ValueContext.getLocalExecutionContext(clazz, propertyPath);
        }
        return ValueContext.getLocalExecutionContext(value, propertyPath);
    }

    private <U> BeanMetaData<U> getBeanMetaData(Class<U> beanClass) {
        BeanMetaDataImpl<U> cachedBeanMetaData;
        BeanMetaDataImpl<U> beanMetaData = this.beanMetaDataCache.getBeanMetaData(beanClass);
        if (beanMetaData == null && (cachedBeanMetaData = this.beanMetaDataCache.addBeanMetaData(beanClass, beanMetaData = new BeanMetaDataImpl<U>(beanClass, this.constraintHelper, this.beanMetaDataCache))) != null) {
            beanMetaData = cachedBeanMetaData;
        }
        return beanMetaData;
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new SingleThreadCachedTraversableResolver(this.traversableResolver);
    }

    private boolean isValidationRequired(ValidationContext<?, ?> validationContext, ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        boolean isReachable;
        if (!metaConstraint.getGroupList().contains(valueContext.getCurrentGroup())) {
            return false;
        }
        PathImpl path = valueContext.getPropertyPath();
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            isReachable = validationContext.getTraversableResolver().isReachable(valueContext.getCurrentBean(), path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, metaConstraint.getElementType());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isReachable() threw an exception", e);
        }
        return isReachable;
    }

    private boolean isCascadeRequired(ValidationContext<?, ?> validationContext, ValueContext<?, ?> valueContext, Member member) {
        boolean isCascadable;
        boolean isReachable;
        ElementType type2 = member instanceof Field ? ElementType.FIELD : ElementType.METHOD;
        PathImpl path = valueContext.getPropertyPath();
        PathImpl pathToObject = path.getPathWithoutLeafNode();
        try {
            isReachable = validationContext.getTraversableResolver().isReachable(valueContext.getCurrentBean(), path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, type2);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isReachable() threw an exception", e);
        }
        try {
            isCascadable = validationContext.getTraversableResolver().isCascadable(valueContext.getCurrentBean(), path.getLeafNode(), validationContext.getRootBeanClass(), pathToObject, type2);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isCascadable() threw an exception", e);
        }
        return isReachable && isCascadable;
    }
}

