/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleDecorator;
import com.sun.faces.spi.ConfigurationResourceProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.naming.resources.FileDirContext;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.osgijavaeebase.BundleResource;
import org.glassfish.osgijavaeebase.OSGiBundleArchive;
import org.glassfish.osgiweb.OSGiFacesAnnotationScanner;
import org.glassfish.osgiweb.OSGiWebDeploymentRequest;
import org.glassfish.web.loader.WebappClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiWebModuleDecorator
implements WebModuleDecorator {
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private boolean active = true;

    @Override
    public void decorate(WebModule module) {
        BundleContext bctx;
        if (this.isActive() && (bctx = OSGiWebDeploymentRequest.getCurrentBundleContext()) != null && !this.isDefaultWebModule(module)) {
            ServletContext sc = module.getServletContext();
            sc.setAttribute("osgi-bundlecontext", bctx);
            if (this.isMojarraPresent()) {
                this.populateFacesInformation(module, bctx, sc);
            }
            module.setResources(new FileDirContext(){

                protected File file(String name) {
                    String s = name.toUpperCase();
                    if (s.startsWith("/OSGI-INF/") || s.startsWith("/OSGI-OPT/")) {
                        OSGiWebModuleDecorator.this.logger.logp(Level.FINE, "OSGiWebModuleDecorator", "file", "Forbidding access to resource called {0}", new Object[]{name});
                        return null;
                    }
                    return super.file(name);
                }
            });
        }
    }

    private boolean isDefaultWebModule(WebModule module) {
        return module.getWebModuleConfig().getName().startsWith("__default-");
    }

    private boolean isMojarraPresent() {
        try {
            return Class.forName(ConfigurationResourceProvider.class.getName()) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void populateFacesInformation(WebModule module, BundleContext bctx, ServletContext sc) {
        ArrayList<URI> facesConfigs = new ArrayList<URI>();
        ArrayList<URI> faceletConfigs = new ArrayList<URI>();
        this.discoverJSFConfigs(bctx.getBundle(), facesConfigs, faceletConfigs);
        sc.setAttribute("glassfish.osgi.web.facesconfigs", facesConfigs);
        sc.setAttribute("glassfish.osgi.web.faceletconfigs", faceletConfigs);
        Map<Class<? extends Annotation>, Set<Class<? extends Object>>> facesAnnotatedClasses = this.scanFacesAnnotations(module);
        sc.setAttribute("glassfish.osgi.web.facesannotatedclasses", facesAnnotatedClasses);
    }

    private synchronized boolean isActive() {
        return this.active;
    }

    synchronized void deActivate() {
        this.active = false;
    }

    private void discoverJSFConfigs(Bundle b, Collection<URI> facesConfigs, Collection<URI> faceletConfigs) {
        OSGiBundleArchive archive = new OSGiBundleArchive(b);
        for (BundleResource r : archive) {
            String path = r.getPath();
            if (!path.startsWith("META-INF/")) continue;
            URI uri = r.getUri();
            if (path.endsWith(".taglib.xml")) {
                faceletConfigs.add(uri);
                continue;
            }
            if (!path.endsWith(".faces-config.xml")) continue;
            facesConfigs.add(uri);
        }
    }

    private Map<Class<? extends Annotation>, Set<Class<? extends Object>>> scanFacesAnnotations(WebModule wm) {
        DeploymentContext dc = wm.getWebModuleConfig().getDeploymentContext();
        if (dc == null) {
            this.logger.fine("Can't process annotations as deployment context is not set.");
            return Collections.emptyMap();
        }
        Types types = dc.getTransientAppMetaData(Types.class.getName(), Types.class);
        return OSGiFacesAnnotationScanner.scan(this.getURIs(wm), types, this.getClassLoader(wm));
    }

    private Collection<URI> getURIs(WebModule wm) {
        WebappClassLoader cl = this.getClassLoader(wm);
        ArrayList<URI> uris = new ArrayList<URI>();
        for (URL url : cl.getURLs()) {
            try {
                uris.add(url.toURI());
            }
            catch (URISyntaxException e) {
                this.logger.log(Level.WARNING, "Unable to process " + url, e);
            }
        }
        return uris;
    }

    private WebappClassLoader getClassLoader(WebModule wm) {
        WebappClassLoader cl = (WebappClassLoader)WebappClassLoader.class.cast(wm.getWebModuleConfig().getDeploymentContext().getClassLoader());
        return cl;
    }
}

