/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.ee.resources;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jms.Queue;
import javax.jms.Topic;
import org.glassfish.osgi.ee.resources.BaseResourceManager;
import org.glassfish.osgi.ee.resources.Invalidate;
import org.glassfish.osgi.ee.resources.ResourceManager;
import org.jvnet.hk2.component.Habitat;
import org.osgi.framework.BundleContext;

public class JMSDestinationResourceManager
extends BaseResourceManager
implements ResourceManager {
    private Habitat habitat;

    public JMSDestinationResourceManager(Habitat habitat) {
        super(habitat);
    }

    public void registerResources(BundleContext context) {
        this.registerJmsResources(context);
    }

    public void registerJmsResources(BundleContext context) {
        Resources resources = this.getHabitat().getComponent(Domain.class).getResources();
        Collection<AdminObjectResource> administeredObjectResources = resources.getResources(AdminObjectResource.class);
        for (AdminObjectResource resource : administeredObjectResources) {
            if (!this.isJmsResource(resource)) continue;
            ResourceRef resRef = this.getResourceHelper().getResourceRef(resource.getJndiName());
            this.registerResource(resource, resRef, context);
        }
    }

    public void registerResource(BindableResource resource, ResourceRef resRef, BundleContext bundleContext) {
        AdminObjectResource adminObjectResource = (AdminObjectResource)resource;
        if (adminObjectResource.getEnabled().equalsIgnoreCase("true") && resRef != null && resRef.getEnabled().equalsIgnoreCase("true")) {
            String defnName = adminObjectResource.getResType();
            Class<Queue> claz = null;
            Class[] intf = null;
            if (defnName.equals("javax.jms.Queue")) {
                claz = Queue.class;
                intf = new Class[]{Queue.class, Invalidate.class};
            } else if (defnName.equals("javax.jms.Topic")) {
                claz = Topic.class;
                intf = new Class[]{Topic.class, Invalidate.class};
            } else {
                throw new RuntimeException("Invalid Destination [ " + defnName + " ]" + " for jms-resource [ " + resource.getJndiName() + " ]");
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("jndi-name", adminObjectResource.getJndiName());
            Object proxy = this.getProxy(adminObjectResource.getJndiName(), intf, this.getClassLoader());
            this.registerResourceAsService(bundleContext, adminObjectResource, claz.getName(), properties, proxy);
        }
    }

    public boolean handlesResource(BindableResource resource) {
        boolean result = false;
        if (resource instanceof AdminObjectResource && this.isJmsResource((AdminObjectResource)resource)) {
            result = true;
        }
        return result;
    }

    private boolean isJmsResource(AdminObjectResource resource) {
        boolean result = false;
        String raName = resource.getResAdapter();
        if (raName.equals("jmsra")) {
            result = true;
        }
        return result;
    }
}

