/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.provider;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.ProbeInfo;
import org.glassfish.flashlight.client.ProbeClientInvoker;
import org.glassfish.flashlight.client.ProbeHandle;

public class FlashlightProbe
implements ProbeHandle,
ProbeInfo {
    private Method probeMethod;
    public static final String SELF = "@SELF";
    private int id;
    private Class providerClazz;
    private String moduleProviderName;
    private String moduleName;
    private String probeName;
    private String probeProviderName;
    private String[] probeParamNames;
    private Class[] paramTypes;
    private volatile List<ProbeClientInvoker> invokerList = new ArrayList<ProbeClientInvoker>(2);
    private String providerJavaMethodName;
    private AtomicBoolean listenerEnabled = new AtomicBoolean(false);
    private String probeDesc;
    private Object dtraceProviderImpl;
    private Method dtraceMethod;
    private boolean hasSelf;
    private boolean hidden;
    private boolean firstTransform = true;
    private ConcurrentMap<Integer, ProbeClientInvoker> invokers = new ConcurrentHashMap<Integer, ProbeClientInvoker>();
    private static final Logger logger = LogDomains.getLogger(FlashlightProbe.class, "javax.enterprise.system.tools.monitor");
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FlashlightProbe.class);
    private FlashlightProbe parent = null;

    public FlashlightProbe(int id, Class providerClazz, String moduleProviderName, String moduleName, String probeProviderName, String probeName, String[] probeParamNames, Class[] paramTypes, boolean self, boolean hidden) {
        this.id = id;
        this.providerClazz = providerClazz;
        this.moduleProviderName = moduleProviderName;
        this.moduleName = moduleName;
        this.probeProviderName = probeProviderName;
        this.probeName = probeName;
        this.probeDesc = moduleProviderName + ":" + moduleName + ":" + probeProviderName + ":" + probeName;
        this.hasSelf = self;
        this.hidden = hidden;
        if (self) {
            if (this.isMethodStatic()) {
                String errStr = localStrings.getLocalString("cannotDefineSelfOnStatic", "Cannot define \"self\" on a static method - ", this.probeDesc);
                throw new RuntimeException(errStr);
            }
            this.probeParamNames = new String[probeParamNames.length + 1];
            this.paramTypes = new Class[paramTypes.length + 1];
            this.probeParamNames[0] = SELF;
            this.paramTypes[0] = providerClazz;
            for (int index = 0; index < probeParamNames.length; ++index) {
                this.probeParamNames[index + 1] = probeParamNames[index];
                this.paramTypes[index + 1] = paramTypes[index];
            }
        } else {
            this.probeParamNames = probeParamNames;
            this.paramTypes = paramTypes;
        }
    }

    public Method getProbeMethod() {
        return this.probeMethod;
    }

    public void setProbeMethod(Method probeMethod) {
        this.probeMethod = probeMethod;
    }

    private boolean isMethodStatic() {
        try {
            int modifier = this.getProviderClazz().getDeclaredMethod(this.getProviderJavaMethodName(), this.getParamTypes()).getModifiers();
            return Modifier.isStatic(modifier);
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean addInvoker(ProbeClientInvoker invoker) {
        boolean isFirst;
        boolean bl = isFirst = this.invokers.isEmpty() && this.firstTransform;
        if (this.invokers.putIfAbsent(invoker.getId(), invoker) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding an invoker that already exists: " + invoker.getId() + "  &&&&&&&&&&");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding an Invoker that does not exist: " + invoker.getId() + " $$$$$$$$$$$$$");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total invokers = " + this.invokers.size());
        }
        this.listenerEnabled.set(true);
        this.firstTransform = false;
        this.initInvokerList();
        return isFirst;
    }

    public synchronized boolean removeInvoker(ProbeClientInvoker invoker) {
        ProbeClientInvoker pci = (ProbeClientInvoker)this.invokers.remove(invoker.getId());
        if (pci != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing an invoker that already exists: " + pci.getId() + "  ##########");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Failed to remove an invoker that does not exist: " + invoker.getId() + "  %%%%%%%%%");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Total invokers = " + this.invokers.size());
        }
        this.listenerEnabled.set(!this.invokers.isEmpty());
        this.initInvokerList();
        return this.listenerEnabled.get();
    }

    public void fireProbe(Object[] params) {
        if (!this.listenerEnabled.get()) {
            return;
        }
        if (this.parent != null) {
            this.parent.fireProbe(params);
        }
        int sz = this.invokerList.size();
        for (int i = 0; i < sz; ++i) {
            ProbeClientInvoker invoker = this.invokerList.get(i);
            if (invoker == null) continue;
            invoker.invoke(params);
        }
    }

    public boolean isEnabled() {
        return this.listenerEnabled.get();
    }

    public int getId() {
        return this.id;
    }

    public String getModuleProviderName() {
        return this.moduleProviderName;
    }

    public String getModuleName() {
        return this.moduleProviderName;
    }

    public String getProbeProviderName() {
        return this.probeProviderName;
    }

    public String getProbeName() {
        return this.probeName;
    }

    public String[] getProbeParamNames() {
        return this.probeParamNames;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String getProviderJavaMethodName() {
        return this.providerJavaMethodName;
    }

    public void setProviderJavaMethodName(String providerJavaMethodName) {
        this.providerJavaMethodName = providerJavaMethodName;
    }

    public String getProbeDesc() {
        return this.probeDesc;
    }

    public static String getProbeDesc(String moduleProviderName, String moduleName, String probeProviderName, String probeName) {
        return moduleProviderName + ":" + moduleName + ":" + probeProviderName + ":" + probeName;
    }

    public Class getProviderClazz() {
        return this.providerClazz;
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder(this.moduleProviderName + ":" + this.moduleName + ":" + this.probeProviderName + ":" + this.probeName);
        String delim = " (";
        for (int i = 0; i < this.paramTypes.length; ++i) {
            sbldr.append(delim).append(this.paramTypes[i] == null ? " " : this.paramTypes[i].getName());
            sbldr.append(" ").append(this.probeParamNames[i] == null ? " " : this.probeParamNames[i]);
            delim = ", ";
        }
        if (this.paramTypes.length == 0) {
            sbldr.append(" (");
        }
        sbldr.append(")");
        return sbldr.toString();
    }

    public void setDTraceProviderImpl(Object impl) {
        this.dtraceProviderImpl = impl;
    }

    public Object getDTraceProviderImpl() {
        return this.dtraceProviderImpl;
    }

    public Method getDTraceMethod() {
        return this.dtraceMethod;
    }

    public void setDTraceMethod(Method m) {
        this.dtraceMethod = m;
    }

    public boolean hasSelf() {
        return this.hasSelf;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setParent(FlashlightProbe parent) {
        this.parent = parent;
    }

    private void initInvokerList() {
        Set entries = this.invokers.entrySet();
        ArrayList<ProbeClientInvoker> invList = new ArrayList<ProbeClientInvoker>(2);
        for (Map.Entry entry : entries) {
            ProbeClientInvoker invoker = (ProbeClientInvoker)entry.getValue();
            invList.add(invoker);
        }
        this.invokerList = invList;
    }
}

