/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.ejb.api.DistributedEJBTimerService;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="migrate-timers")
@Scoped(value=PerLookup.class)
@I18n(value="migrate.timers")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE})
public class MigrateTimers
implements AdminCommand {
    static StringManager localStrings = StringManager.getManager(MigrateTimers.class);
    private static final Logger logger = LogDomains.getLogger(MigrateTimers.class, "javax.enterprise.system.container.ejb");
    @Param(name="target", optional=true, alias="destination", defaultValue="server")
    public String target;
    private boolean needRedirect;
    @Param(name="fromServer", primary=true, optional=false)
    public String fromServer;
    @Inject
    DistributedEJBTimerService timerService;
    @Inject
    private Domain domain;
    @Inject
    Target targetUtil;
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String error = this.validate();
        if (error != null) {
            report.setMessage(error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (this.needRedirect) {
                this.needRedirect = false;
                ParameterMapExtractor mapExtractor = new ParameterMapExtractor(this);
                ParameterMap params = mapExtractor.extract();
                logger.info(localStrings.getString("migrate.timers.redirect", this.target, params.toCommaSeparatedString()));
                ClusterOperationUtil.replicateCommand("migrate-timers", FailurePolicy.Error, FailurePolicy.Error, Arrays.asList(this.target), context, params, this.habitat);
                return;
            }
            int totalTimersMigrated = this.timerService.migrateTimers(this.fromServer);
            report.setMessage(localStrings.getString("migrate.timers.count", totalTimersMigrated, this.fromServer, this.target));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    private String validate() {
        Cluster fromServerCluster = this.targetUtil.getClusterForInstance(this.fromServer);
        if (fromServerCluster == null) {
            return localStrings.getString("migrate.timers.fromServerNotClusteredInstance", this.fromServer);
        }
        if (this.isServerRunning(this.fromServer)) {
            return localStrings.getString("migrate.timers.migrateFromServerStillRunning", this.fromServer);
        }
        if (this.target.equals("server")) {
            List<Server> instances = fromServerCluster.getInstances();
            for (Server instance : instances) {
                if (!instance.isRunning()) continue;
                this.target = instance.getName();
                this.needRedirect = true;
            }
            if (this.target.equals("server")) {
                return localStrings.getString("migrate.timers.noRunningInstanceToChoose", this.target);
            }
        } else {
            Cluster destinationServerCluster = this.targetUtil.getClusterForInstance(this.target);
            if (!fromServerCluster.getName().equals(destinationServerCluster.getName())) {
                return localStrings.getString("migrate.timers.fromServerAndTargetNotInSameCluster", this.fromServer, this.target);
            }
            if (!this.isServerRunning(this.target)) {
                return localStrings.getString("migrate.timers.destinationServerIsNotAlive", this.target);
            }
        }
        return null;
    }

    private boolean isServerRunning(String serverName) {
        Server server = this.domain.getServerNamed(serverName);
        return server == null ? false : server.isRunning();
    }
}

