/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.ejb.api.DistributedEJBTimerService;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-timers")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.timers")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
public class ListTimers
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListTimers.class);
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Inject
    DistributedEJBTimerService timerService;
    @Inject
    Target targetUtil;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String[] serverIds = null;
        if (this.targetUtil.isCluster(this.target)) {
            List<Server> serversInCluster = this.targetUtil.getInstances(this.target);
            serverIds = new String[serversInCluster.size()];
            for (int i = 0; i < serverIds.length; ++i) {
                serverIds[i] = serversInCluster.get(i).getName();
            }
        } else {
            serverIds = new String[]{this.target};
        }
        try {
            Properties extraProps = new Properties();
            ArrayList ejbTimers = new ArrayList(serverIds.length);
            String[] timerCounts = this.timerService.listTimers(serverIds);
            for (int i = 0; i < serverIds.length; ++i) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(serverIds[i] + ": " + timerCounts[i]);
                HashMap<String, String> ejbTimer = new HashMap<String, String>();
                ejbTimer.put("server", serverIds[i]);
                ejbTimer.put("timerCount", timerCounts[i]);
                ejbTimers.add(ejbTimer);
            }
            extraProps.put("ejbTimers", ejbTimers);
            report.setExtraProperties(extraProps);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.timers.failed", "List Timers command failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

