/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.ListAppRefsCommand;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="show-component-status")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
public class ShowComponentStatusCommand
implements AdminCommand {
    @Param(primary=true)
    public String name = null;
    @Param(optional=true)
    String target = "server";
    @Inject
    Deployment deployment;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    @Inject
    VersioningService versioningService;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ActionReport.MessagePart part = report.getTopMessagePart();
        List<String> matchedVersions = null;
        try {
            matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningException e) {
            report.failure(logger, e.getMessage());
            return;
        }
        if (matchedVersions.isEmpty()) {
            report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (String appName : matchedVersions) {
            ApplicationRef ref;
            String status = "disabled";
            if (!DeploymentUtils.isDomainTarget(this.target) && (ref = this.domain.getApplicationRefInTarget(appName, this.target)) == null) {
                report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", appName, this.target));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.domain.isAppEnabledInTarget(appName, this.target)) {
                status = "enabled";
            }
            ActionReport.MessagePart childPart = part.addChild();
            String message = localStrings.getLocalString("component.status", "Status of {0} is {1}.", appName, status);
            childPart.setMessage(message);
            childPart.addProperty("state", status);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

