/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.util;

import com.sun.enterprise.util.io.FileUtils;
import com.trilead.ssh2.Connection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.util.Strings;

public class SSHUtil {
    private static final List<Connection> activeConnections = new ArrayList<Connection>();
    private static final String NL = System.getProperty("line.separator");

    public static synchronized void register(Connection connection) {
        if (!activeConnections.contains(connection)) {
            activeConnections.add(connection);
        }
    }

    public static synchronized void unregister(Connection connection) {
        connection.close();
        activeConnections.remove(connection);
    }

    public static String checkString(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String getExistingKeyFile() {
        String key = null;
        for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
            String h = System.getProperty("user.home") + File.separator;
            File f = new File(h + ".ssh" + File.separator + keyName);
            if (!f.exists()) continue;
            key = h + ".ssh" + File.separator + keyName;
            break;
        }
        return key;
    }

    public static String getDefaultKeyFile() {
        String k = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_rsa";
        return k;
    }

    public static boolean isEncryptedKey(String keyFile) throws CommandException {
        boolean res = false;
        try {
            String f = FileUtils.readSmallFile(keyFile);
            if (f.startsWith("-----BEGIN ") && f.contains("ENCRYPTED") && f.endsWith(" PRIVATE KEY-----" + NL)) {
                res = true;
            }
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("error.parsing.key", keyFile, ioe.getMessage()));
        }
        return res;
    }

    public static boolean validateKeyFile(String file) throws CommandException {
        boolean ret = false;
        File f = new File(file);
        if (f.exists()) {
            if (!f.getName().endsWith(".pub")) {
                String key = null;
                try {
                    key = FileUtils.readSmallFile(file);
                }
                catch (IOException ioe) {
                    throw new CommandException(Strings.get("unable.to.read.key", file, ioe.getMessage()));
                }
                if (!key.startsWith("-----BEGIN ") && !key.endsWith(" PRIVATE KEY-----" + NL)) {
                    throw new CommandException(Strings.get("invalid.key.file", file));
                }
            }
        } else {
            throw new CommandException(Strings.get("key.does.not.exist", file));
        }
        ret = true;
        return ret;
    }
}

