/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import org.glassfish.external.amx.BootAMXMBean;

class BootAMXListener
implements NotificationListener {
    private final JMXConnectorServer mServer;
    private final BootAMXMBean mBooter;
    private final Logger mLogger = LogDomains.getLogger(BootAMXListener.class, "javax.enterprise.system.jmx");

    public BootAMXListener(JMXConnectorServer server, BootAMXMBean booter) {
        this.mServer = server;
        this.mBooter = booter;
    }

    public void handleNotification(Notification notif, Object handback) {
        JMXConnectionNotification n;
        if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
            this.mLogger.log(Level.INFO, "jmx.bootingamx.listener", handback);
            this.mBooter.bootAMX();
            try {
                this.mServer.removeNotificationListener(this);
                this.mLogger.fine("ConnectorStartupService.BootAMXListener: AMX is booted, stopped listening");
            }
            catch (ListenerNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

