/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class JavaSECMPInitializer
extends JPAInitializer {
    public static Instrumentation globalInstrumentation;
    protected static boolean usesAgent;
    protected static boolean isInContainer;
    protected static boolean isInitialized;
    protected static JavaSECMPInitializer initializer;
    protected static Boolean initializationLock;

    public static boolean isInContainer() {
        return isInContainer;
    }

    public static void setIsInContainer(boolean isInContainer) {
        JavaSECMPInitializer.isInContainer = isInContainer;
    }

    public static JavaSECMPInitializer getJavaSECMPInitializer() {
        return JavaSECMPInitializer.getJavaSECMPInitializer(Thread.currentThread().getContextClassLoader(), null, false);
    }

    public static JavaSECMPInitializer getJavaSECMPInitializer(ClassLoader classLoader) {
        return JavaSECMPInitializer.getJavaSECMPInitializer(classLoader, null, false);
    }

    public static JavaSECMPInitializer getJavaSECMPInitializerFromAgent() {
        return JavaSECMPInitializer.getJavaSECMPInitializer(Thread.currentThread().getContextClassLoader(), null, true);
    }

    public static JavaSECMPInitializer getJavaSECMPInitializerFromMain(Map m) {
        return JavaSECMPInitializer.getJavaSECMPInitializer(Thread.currentThread().getContextClassLoader(), m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaSECMPInitializer getJavaSECMPInitializer(ClassLoader classLoader, Map m, boolean fromAgent) {
        if (!isInitialized) {
            if (globalInstrumentation != null) {
                Boolean bl = initializationLock;
                synchronized (bl) {
                    if (!isInitialized) {
                        JavaSECMPInitializer.initializeTopLinkLoggingFile();
                        if (fromAgent) {
                            AbstractSessionLog.getLog().log(2, "cmp_init_initialize_from_agent", null);
                        }
                        usesAgent = true;
                        initializer = new JavaSECMPInitializer(classLoader);
                        initializer.initialize(m != null ? m : new HashMap(0));
                        globalInstrumentation = null;
                    }
                }
            }
            isInitialized = true;
        }
        if (initializer != null && initializer.getInitializationClassLoader() == classLoader) {
            return initializer;
        }
        return new JavaSECMPInitializer(classLoader);
    }

    protected JavaSECMPInitializer() {
    }

    protected JavaSECMPInitializer(ClassLoader loader) {
        this.initializationClassloader = loader;
    }

    public void checkWeaving(Map properties) {
        String weaving = EntityManagerFactoryProvider.getConfigPropertyAsString("eclipselink.weaving", properties, null);
        if (!usesAgent && !isInContainer) {
            if (weaving == null) {
                properties.put("eclipselink.weaving", "false");
                weaving = "false";
            } else if (weaving.equalsIgnoreCase("true")) {
                throw new PersistenceException(EntityManagerSetupException.wrongWeavingPropertyValue());
            }
        }
        if (weaving != null && (weaving.equalsIgnoreCase("false") || weaving.equalsIgnoreCase("static"))) {
            this.shouldCreateInternalLoader = false;
        }
    }

    protected ClassLoader createTempLoader(Collection col) {
        return this.createTempLoader(col, true);
    }

    protected ClassLoader createTempLoader(Collection col, boolean shouldOverrideLoadClassForCollectionMembers) {
        if (!this.shouldCreateInternalLoader) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof URLClassLoader)) {
            return currentLoader;
        }
        URL[] urlPath = ((URLClassLoader)currentLoader).getURLs();
        TempEntityLoader tempLoader = new TempEntityLoader(urlPath, currentLoader, col, shouldOverrideLoadClassForCollectionMembers);
        AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", tempLoader);
        AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", shouldOverrideLoadClassForCollectionMembers);
        return tempLoader;
    }

    protected static void initializeFromAgent(Instrumentation instrumentation) throws Exception {
        globalInstrumentation = instrumentation;
        JavaSECMPInitializer.getJavaSECMPInitializerFromAgent();
    }

    public static void initializeFromMain(Map m) {
        JavaSECMPInitializer.getJavaSECMPInitializerFromMain(m);
    }

    public static void initializeFromMain() {
        JavaSECMPInitializer.initializeFromMain(new HashMap());
    }

    public void registerTransformer(final ClassTransformer transformer, PersistenceUnitInfo persistenceUnitInfo, Map properties) {
        if (transformer != null && globalInstrumentation != null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", persistenceUnitInfo.getPersistenceUnitName());
            globalInstrumentation.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    return transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                }
            });
        } else if (transformer == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
        } else if (globalInstrumentation == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_globalInstrumentation_is_null");
        }
    }

    public boolean isPersistenceUnitUniquelyDefinedByName() {
        return usesAgent;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static boolean usesAgent() {
        return usesAgent;
    }

    protected boolean keepAllPredeployedPersistenceUnits() {
        return usesAgent;
    }

    static {
        initializationLock = new Boolean(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.getParent().getResources(name);
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            super(urls, parent);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames) {
            this(urls, parent, classNames, true);
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

