/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class MappedInteraction
extends EISInteraction {
    protected String inputResultPath = "";
    protected Vector argumentNames;

    public void addArgument(String parameterAndArgumentFieldName) {
        this.addArgument(parameterAndArgumentFieldName, parameterAndArgumentFieldName);
    }

    public void addArgument(String parameterName, String argumentFieldName) {
        this.getArgumentNames().addElement(parameterName);
        this.getArguments().addElement(new DatabaseField(argumentFieldName));
    }

    public void addArgumentValue(String parameterName, Object argumentValue) {
        this.getArgumentNames().addElement(parameterName);
        this.getArguments().addElement(argumentValue);
    }

    public String getInputResultPath() {
        return this.inputResultPath;
    }

    public void setInputResultPath(String inputResultPath) {
        this.inputResultPath = inputResultPath;
    }

    public Vector getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = new Vector();
        }
        return this.argumentNames;
    }

    public void setArgumentNames(Vector argumentNames) {
        this.argumentNames = argumentNames;
    }

    public Record createInputRecord(EISAccessor accessor) {
        try {
            MappedRecord record = null;
            if (this.getInputRow() != null && !this.hasArguments()) {
                if (this.getInputResultPath().length() == 0) {
                    record = (MappedRecord)this.createRecordElement(this.getInputRecordName(), this.getInputRow(), accessor);
                } else {
                    record = accessor.getRecordFactory().createMappedRecord(this.getInputRecordName());
                    Object nestedRecord = this.createRecordElement(this.getInputResultPath(), this.getInputRow(), accessor);
                    accessor.getEISPlatform().setValueInRecord(this.getInputResultPath(), nestedRecord, record, accessor);
                }
            } else {
                record = accessor.getRecordFactory().createMappedRecord(this.getInputRecordName());
                for (int index = 0; index < this.getArgumentNames().size(); ++index) {
                    String parameterName = (String)this.getArgumentNames().get(index);
                    Object parameter = this.getParameters().get(index);
                    if (parameter == null && this.getInputRow() != null) {
                        parameter = this.getInputRow().get(parameterName);
                    }
                    parameter = this.createRecordElement(parameterName, parameter, accessor);
                    accessor.getEISPlatform().setValueInRecord(parameterName, parameter, record, accessor);
                }
            }
            return record;
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    public AbstractRecord buildRow(Record record, EISAccessor accessor) {
        AbstractRecord row = null;
        if (!(record instanceof MappedRecord)) {
            row = new DatabaseRecord(1);
            row.put(this.getOutputResultPath(), (Object)record);
            return row;
        }
        MappedRecord mappedRecord = (MappedRecord)record;
        if (this.hasOutputArguments()) {
            row = new DatabaseRecord(this.getOutputArgumentNames().size());
            for (int index = 0; index < this.getOutputArgumentNames().size(); ++index) {
                DatabaseField field = (DatabaseField)this.getOutputArguments().get(index);
                row.put(field, mappedRecord.get(this.getOutputArgumentNames().get(index)));
            }
            return row;
        }
        if (this.getOutputResultPath().length() > 0) {
            mappedRecord = (MappedRecord)mappedRecord.get(this.getOutputResultPath());
        }
        row = new EISMappedRecord(mappedRecord, accessor);
        return row;
    }
}

