/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.DDColumnDependableFinder;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean purge;
    private boolean defragment;
    private boolean truncateEndOfTable;
    private boolean updateStatistics;
    private boolean updateStatisticsAll;
    private String indexNameForUpdateStatistics;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;
    static /* synthetic */ Class class$org$apache$derby$impl$sql$compile$ColumnReference;

    AlterTableConstantAction(SchemaDescriptor schemaDescriptor, String string, UUID uUID, long l, int n, ColumnInfo[] columnInfoArray, ConstraintConstantAction[] constraintConstantActionArray, char c, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, String string2) {
        super(uUID);
        this.sd = schemaDescriptor;
        this.tableName = string;
        this.tableConglomerateId = l;
        this.tableType = n;
        this.columnInfo = columnInfoArray;
        this.constraintActions = constraintConstantActionArray;
        this.lockGranularity = c;
        this.compressTable = bl;
        this.behavior = n2;
        this.sequential = bl2;
        this.truncateTable = bl3;
        this.purge = bl4;
        this.defragment = bl5;
        this.truncateEndOfTable = bl6;
        this.updateStatistics = bl7;
        this.updateStatisticsAll = bl8;
        this.indexNameForUpdateStatistics = string2;
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        try {
            this.executeConstantActionBody(activation);
        }
        finally {
            this.clearState();
        }
    }

    private void executeConstantActionBody(Activation activation) throws StandardException {
        Object object;
        int n;
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        int n2 = 0;
        boolean bl = false;
        if (this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable)) {
            this.td = this.dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            if (this.purge) {
                this.purgeRows(this.tc);
            }
            if (this.defragment) {
                this.defragmentRows(this.tc);
            }
            if (this.truncateEndOfTable) {
                this.truncateEnd(this.tc);
            }
            return;
        }
        if (this.updateStatistics) {
            this.updateStatistics();
            return;
        }
        this.dd.startWriting(this.lcc);
        if (this.tableConglomerateId == 0L) {
            this.td = this.dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(this.tc, this.tableConglomerateId, true);
        this.td = this.dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            this.dm.invalidateFor(this.td, 42, this.lcc);
        } else {
            this.dm.invalidateFor(this.td, 12, this.lcc);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(this.dd, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            this.dm.invalidateFor(this.td, 42, this.lcc);
        } else {
            this.dm.invalidateFor(this.td, 12, this.lcc);
        }
        if (this.columnInfo != null) {
            int n3;
            n = 0;
            for (n3 = 0; n3 < this.columnInfo.length; ++n3) {
                if (this.columnInfo[n3].action != 0 || this.columnInfo[n3].dataType.isNullable() || this.columnInfo[n3].defaultInfo != null || this.columnInfo[n3].autoincInc != 0L) continue;
                n = 1;
            }
            if (n != 0) {
                n2 = this.getSemiRowCount(this.tc);
                if (n2 > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                bl = true;
            }
            for (n3 = 0; n3 < this.columnInfo.length; ++n3) {
                if (this.columnInfo[n3].action == 0) {
                    this.addNewColumnToTable(n3);
                    continue;
                }
                if (this.columnInfo[n3].action == 5 || this.columnInfo[n3].action == 6 || this.columnInfo[n3].action == 7) {
                    this.modifyColumnDefault(n3);
                    continue;
                }
                if (this.columnInfo[n3].action == 2) {
                    this.modifyColumnType(n3);
                    continue;
                }
                if (this.columnInfo[n3].action == 3) {
                    this.modifyColumnConstraint(this.columnInfo[n3].name, true);
                    continue;
                }
                if (this.columnInfo[n3].action == 4) {
                    String[] stringArray;
                    if (!bl) {
                        bl = true;
                        n2 = this.getSemiRowCount(this.tc);
                    }
                    if (!this.validateNotNullConstraint(stringArray = new String[]{this.columnInfo[n3].name}, (boolean[])(object = (Object)new boolean[1]), n2, this.lcc, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(this.columnInfo[n3].name, false);
                    continue;
                }
                if (this.columnInfo[n3].action != 1) continue;
                this.dropColumnFromTable(this.columnInfo[n3].name);
            }
        }
        this.adjustUDTDependencies(this.lcc, this.dd, this.td, this.columnInfo, false);
        if (this.constraintActions != null) {
            for (n = 0; n < this.constraintActions.length; ++n) {
                ConstraintConstantAction constraintConstantAction = this.constraintActions[n];
                if (constraintConstantAction instanceof CreateConstraintConstantAction) {
                    int n4 = constraintConstantAction.getConstraintType();
                    switch (n4) {
                        case 2: {
                            object = this.dd.getConstraintDescriptors(this.td);
                            if (((ConstraintDescriptorList)object).getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (bl) break;
                            bl = true;
                            n2 = this.getSemiRowCount(this.tc);
                            break;
                        }
                        case 4: {
                            if (!bl) {
                                bl = true;
                                n2 = this.getSemiRowCount(this.tc);
                            }
                            if (n2 <= 0) break;
                            ConstraintConstantAction.validateConstraint(constraintConstantAction.getConstraintName(), ((CreateConstraintConstantAction)constraintConstantAction).getConstraintText(), this.td, this.lcc, true);
                        }
                    }
                }
                this.constraintActions[n].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            this.td.setLockGranularity(this.lockGranularity);
            this.dd.updateLockGranularity(this.td, this.sd, this.lockGranularity, this.tc);
        }
        if (this.compressTable) {
            this.compressTable();
        }
        if (this.truncateTable) {
            this.truncateTable();
        }
    }

    private void clearState() {
        this.td = null;
        this.lcc = null;
        this.dd = null;
        this.dm = null;
        this.tc = null;
        this.activation = null;
    }

    private void updateStatistics() throws StandardException {
        this.td = this.dd.getTableDescriptor(this.tableId);
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.updateStatisticsAll ? this.td.getConglomerateDescriptors() : new ConglomerateDescriptor[]{this.dd.getConglomerateDescriptor(this.indexNameForUpdateStatistics, this.sd, false)};
        this.dd.getIndexStatsRefresher(false).runExplicitly(this.lcc, this.td, conglomerateDescriptorArray, "ALTER TABLE");
    }

    private void truncateEnd(TransactionController transactionController) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors();
                for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                    ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
                    transactionController.compressConglomerate(conglomerateDescriptor.getConglomerateNumber());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void defragmentRows(TransactionController transactionController) throws StandardException {
        TransactionController transactionController2;
        ConglomerateController[] conglomerateControllerArray;
        ScanController[] scanControllerArray;
        int n;
        GenericScanController genericScanController;
        block23: {
            block21: {
                block22: {
                    genericScanController = null;
                    n = 0;
                    Object object = null;
                    scanControllerArray = null;
                    conglomerateControllerArray = null;
                    DataValueDescriptor[][] dataValueDescriptorArray = null;
                    transactionController2 = null;
                    try {
                        transactionController2 = transactionController.startNestedUserTransaction(false);
                        switch (this.td.getTableType()) {
                            case 2: 
                            case 5: {
                                Object var20_9 = null;
                                if (genericScanController == null) break block21;
                                break block22;
                            }
                            default: {
                                RowLocation[] rowLocationArray;
                                ExecRow execRow = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getValueRow(this.td.getNumberOfColumns());
                                ColumnDescriptorList columnDescriptorList = this.td.getColumnDescriptorList();
                                int n2 = columnDescriptorList.size();
                                for (int i = 0; i < n2; ++i) {
                                    rowLocationArray = columnDescriptorList.elementAt(i);
                                    execRow.setColumn(rowLocationArray.getPosition(), rowLocationArray.getType().getNull());
                                }
                                DataValueDescriptor[][] dataValueDescriptorArray2 = new DataValueDescriptor[100][];
                                dataValueDescriptorArray2[0] = execRow.getRowArray();
                                rowLocationArray = new RowLocation[100];
                                RowLocation[] rowLocationArray2 = new RowLocation[100];
                                ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors();
                                n = conglomerateDescriptorArray.length - 1;
                                if (n > 0) {
                                    object = new int[n][];
                                    scanControllerArray = new ScanController[n];
                                    conglomerateControllerArray = new ConglomerateController[n];
                                    dataValueDescriptorArray = new DataValueDescriptor[n][];
                                    AlterTableConstantAction.setup_indexes(transactionController2, this.td, object, scanControllerArray, conglomerateControllerArray, dataValueDescriptorArray);
                                }
                                genericScanController = transactionController2.defragmentConglomerate(this.td.getHeapConglomerateId(), false, true, 4, 7, 5);
                                int n3 = 0;
                                while ((n3 = genericScanController.fetchNextGroup(dataValueDescriptorArray2, rowLocationArray, rowLocationArray2)) != 0) {
                                    if (n <= 0) continue;
                                    for (int i = 0; i < n3; ++i) {
                                        for (int j = 0; j < n; ++j) {
                                            AlterTableConstantAction.fixIndex(dataValueDescriptorArray2[i], dataValueDescriptorArray[j], rowLocationArray[i], rowLocationArray2[i], conglomerateControllerArray[j], scanControllerArray[j], object[j]);
                                        }
                                    }
                                }
                                transactionController2.commit();
                                break;
                            }
                        }
                        break block23;
                    }
                    catch (Throwable throwable) {
                        Object var20_11 = null;
                        if (genericScanController != null) {
                            genericScanController.close();
                            genericScanController = null;
                        }
                        if (n > 0) {
                            for (int i = 0; i < n; ++i) {
                                if (scanControllerArray != null && scanControllerArray[i] != null) {
                                    scanControllerArray[i].close();
                                    scanControllerArray[i] = null;
                                }
                                if (conglomerateControllerArray == null || conglomerateControllerArray[i] == null) continue;
                                conglomerateControllerArray[i].close();
                                conglomerateControllerArray[i] = null;
                            }
                        }
                        if (transactionController2 == null) throw throwable;
                        transactionController2.destroy();
                        throw throwable;
                    }
                }
                genericScanController.close();
                genericScanController = null;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (scanControllerArray != null && scanControllerArray[i] != null) {
                        scanControllerArray[i].close();
                        scanControllerArray[i] = null;
                    }
                    if (conglomerateControllerArray == null || conglomerateControllerArray[i] == null) continue;
                    conglomerateControllerArray[i].close();
                    conglomerateControllerArray[i] = null;
                }
            }
            if (transactionController2 == null) return;
            transactionController2.destroy();
            return;
        }
        Object var20_10 = null;
        if (genericScanController != null) {
            genericScanController.close();
            genericScanController = null;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (scanControllerArray != null && scanControllerArray[i] != null) {
                    scanControllerArray[i].close();
                    scanControllerArray[i] = null;
                }
                if (conglomerateControllerArray == null || conglomerateControllerArray[i] == null) continue;
                conglomerateControllerArray[i].close();
                conglomerateControllerArray[i] = null;
            }
        }
        if (transactionController2 == null) return;
        transactionController2.destroy();
    }

    private static void setup_indexes(TransactionController transactionController, TableDescriptor tableDescriptor, int[][] nArray, ScanController[] scanControllerArray, ConglomerateController[] conglomerateControllerArray, DataValueDescriptor[][] dataValueDescriptorArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        int n = 0;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (!conglomerateDescriptor.isIndex()) continue;
            scanControllerArray[n] = transactionController.openScan(conglomerateDescriptor.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0);
            conglomerateControllerArray[n] = transactionController.openConglomerate(conglomerateDescriptor.getConglomerateNumber(), true, 4, 7, 5);
            int[] nArray2 = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            int[] nArray3 = new int[nArray2.length];
            for (int j = 0; j < nArray2.length; ++j) {
                nArray3[j] = nArray2[j] - 1;
            }
            nArray[n] = nArray3;
            dataValueDescriptorArray[n] = new DataValueDescriptor[nArray2.length + 1];
            ++n;
        }
    }

    private static void fixIndex(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, RowLocation rowLocation, RowLocation rowLocation2, ConglomerateController conglomerateController, ScanController scanController, int[] nArray) throws StandardException {
        for (int i = 0; i < nArray.length; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[nArray[i]];
        }
        dataValueDescriptorArray2[dataValueDescriptorArray2.length - 1] = rowLocation;
        scanController.reopenScan(dataValueDescriptorArray2, 1, null, dataValueDescriptorArray2, -1);
        if (scanController.next()) {
            scanController.delete();
        }
        dataValueDescriptorArray2[dataValueDescriptorArray2.length - 1] = rowLocation2;
        conglomerateController.insert(dataValueDescriptorArray2);
    }

    private void purgeRows(TransactionController transactionController) throws StandardException {
        switch (this.td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors();
                for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                    ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
                    transactionController.purgeConglomerate(conglomerateDescriptor.getConglomerateNumber());
                }
            }
        }
    }

    private void addNewColumnToTable(int n) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        int n2 = this.td.getMaxColumnID() + n;
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), (Object)this.columnInfo[n].name, (Object)this.td.getDescriptorType(), (Object)this.td.getQualifiedName());
        }
        DataValueDescriptor dataValueDescriptor = this.columnInfo[n].defaultValue != null ? this.columnInfo[n].defaultValue : this.columnInfo[n].dataType.getNull();
        this.tc.addColumnToConglomerate(this.td.getHeapConglomerateId(), n2, dataValueDescriptor, this.columnInfo[n].dataType.getCollationType());
        UUID uUID = this.columnInfo[n].newDefaultUUID;
        if (this.columnInfo[n].defaultInfo != null && uUID == null) {
            uUID = this.dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n].name, n2 + 1, this.columnInfo[n].dataType, this.columnInfo[n].defaultValue, this.columnInfo[n].defaultInfo, this.td, uUID, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        this.dd.addDescriptor(columnDescriptor, this.td, 2, false, this.tc);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            this.updateNewAutoincrementColumn(this.columnInfo[n].name, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        }
        if (columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(columnDescriptor);
        }
        this.addColumnDependencies(this.lcc, this.dd, this.td, this.columnInfo[n]);
        this.dd.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), this.tc);
    }

    private void dropColumnFromTable(String string) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        int n2;
        int n3;
        Object object5;
        int n4;
        Serializable serializable;
        Object object6;
        int n5;
        boolean bl = this.behavior == 0;
        ColumnDescriptorList columnDescriptorList = this.td.getGeneratedColumns();
        int n6 = columnDescriptorList.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n6; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            String[] stringArray = columnDescriptor.getDefaultInfo().getReferencedColumnNames();
            n5 = stringArray.length;
            for (int j = 0; j < n5; ++j) {
                if (!string.equals(stringArray[j])) continue;
                object6 = columnDescriptor.getColumnName();
                if (!bl) {
                    throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)string, (Object)"GENERATED COLUMN", object6);
                }
                arrayList.add((String)object6);
            }
        }
        DataDescriptorGenerator dataDescriptorGenerator = this.dd.getDataDescriptorGenerator();
        int n7 = arrayList.size();
        int n8 = this.td.getColumnDescriptorList().size() - n7;
        if (n8 == 1) {
            throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)("THE *LAST* COLUMN " + string), (Object)"TABLE", (Object)this.td.getQualifiedName());
        }
        for (n5 = 0; n5 < n7; ++n5) {
            String string2 = (String)arrayList.get(n5);
            this.activation.addWarning(StandardException.newWarning("01009", string2, this.td.getName()));
            this.dropColumnFromTable(string2);
        }
        this.td = this.dd.getTableDescriptor(this.tableId);
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)string, (Object)this.td.getQualifiedName());
        }
        int n9 = this.td.getColumnDescriptorList().size();
        this.droppedColumnPosition = columnDescriptor.getPosition();
        object6 = new FormatableBitSet(n9 + 1);
        ((FormatableBitSet)object6).set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap((FormatableBitSet)object6);
        this.dm.invalidateFor(this.td, bl ? 37 : 46, this.lcc);
        if (columnDescriptor.getDefaultInfo() != null) {
            this.dm.clearDependencies(this.lcc, columnDescriptor.getDefaultDescriptor(this.dd));
        }
        GenericDescriptorList genericDescriptorList = this.dd.getTriggerDescriptors(this.td);
        Enumeration enumeration = genericDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray;
            int n10;
            serializable = (TriggerDescriptor)enumeration.nextElement();
            n4 = 0;
            object5 = ((TriggerDescriptor)serializable).getReferencedCols();
            if (object5 != null) {
                n3 = ((int[])object5).length;
                n2 = 0;
                for (n10 = 0; n10 < n3; ++n10) {
                    if (object5[n10] > this.droppedColumnPosition) {
                        n2 = 1;
                        continue;
                    }
                    if (object5[n10] != this.droppedColumnPosition) continue;
                    if (bl) {
                        ((TriggerDescriptor)serializable).drop(this.lcc);
                        n4 = 1;
                        this.activation.addWarning(StandardException.newWarning("01502", ((TriggerDescriptor)serializable).getName(), this.td.getName()));
                        break;
                    }
                    throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)string, (Object)"TRIGGER", (Object)((TriggerDescriptor)serializable).getName());
                }
                if (n10 == n3 && n2 != 0) {
                    this.dd.dropTriggerDescriptor((TriggerDescriptor)serializable, this.tc);
                    for (n10 = 0; n10 < n3; ++n10) {
                        if (object5[n10] <= this.droppedColumnPosition) continue;
                        int n11 = n10;
                        object5[n11] = object5[n11] - 1;
                    }
                    this.dd.addDescriptor((TupleDescriptor)((Object)serializable), this.sd, 13, false, this.tc);
                }
            }
            if (n4 != 0 || (nArray = ((TriggerDescriptor)serializable).getReferencedColsInTriggerAction()) == null) continue;
            n10 = nArray.length;
            boolean bl2 = false;
            for (n2 = 0; n2 < n10; ++n2) {
                if (nArray[n2] > this.droppedColumnPosition) {
                    bl2 = true;
                    continue;
                }
                if (nArray[n2] != this.droppedColumnPosition) continue;
                if (bl) {
                    ((TriggerDescriptor)serializable).drop(this.lcc);
                    n4 = 1;
                    this.activation.addWarning(StandardException.newWarning("01502", ((TriggerDescriptor)serializable).getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)string, (Object)"TRIGGER", (Object)((TriggerDescriptor)serializable).getName());
            }
            if (n2 != n10 || !bl2) continue;
            this.dd.dropTriggerDescriptor((TriggerDescriptor)serializable, this.tc);
            for (n2 = 0; n2 < n10; ++n2) {
                if (nArray[n2] <= this.droppedColumnPosition) continue;
                int n12 = n2;
                nArray[n12] = nArray[n12] - 1;
            }
            this.dd.addDescriptor((TupleDescriptor)((Object)serializable), this.sd, 13, false, this.tc);
        }
        serializable = this.dd.getConstraintDescriptors(this.td);
        n4 = ((ArrayList)serializable).size();
        object5 = new ArrayList();
        n3 = 0;
        ConstraintDescriptor[] constraintDescriptorArray = new ConstraintDescriptor[n4];
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n13;
            ConstraintDescriptor constraintDescriptor = ((ConstraintDescriptorList)serializable).elementAt(n2);
            object4 = constraintDescriptor.getReferencedColumns();
            n = ((int[])object4).length;
            boolean bl3 = false;
            for (n13 = 0; n13 < n; ++n13) {
                if (object4[n13] > this.droppedColumnPosition) {
                    bl3 = true;
                }
                if (object4[n13] == this.droppedColumnPosition) break;
            }
            if (n13 == n) {
                if (!(constraintDescriptor instanceof CheckConstraintDescriptor) || !bl3) continue;
                this.dd.dropConstraintDescriptor(constraintDescriptor, this.tc);
                for (n13 = 0; n13 < n; ++n13) {
                    if (object4[n13] <= this.droppedColumnPosition) continue;
                    Object object7 = object4;
                    int n14 = n13;
                    object7[n14] = object7[n14] - true;
                }
                ((CheckConstraintDescriptor)constraintDescriptor).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl((int[])object4));
                this.dd.addConstraintDescriptor(constraintDescriptor, this.tc);
                continue;
            }
            if (!bl) {
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)string, (Object)"CONSTRAINT", (Object)constraintDescriptor.getConstraintName());
            }
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                constraintDescriptorArray[n3++] = constraintDescriptor;
                continue;
            }
            this.dm.invalidateFor(constraintDescriptor, 19, this.lcc);
            this.dropConstraint(constraintDescriptor, this.td, (List)object5, this.activation, this.lcc, true);
            this.activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorArray[n2];
            this.dropConstraint(constraintDescriptor, this.td, (List)object5, this.activation, this.lcc, false);
            this.activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
            if (bl) {
                object4 = this.dd.getForeignKeys(constraintDescriptor.getUUID());
                for (n = 0; n < ((ArrayList)object4).size(); ++n) {
                    ConstraintDescriptor constraintDescriptor2 = ((ConstraintDescriptorList)object4).elementAt(n);
                    this.dm.invalidateFor(constraintDescriptor2, 19, this.lcc);
                    this.dropConstraint(constraintDescriptor2, this.td, (List)object5, this.activation, this.lcc, true);
                    this.activation.addWarning(StandardException.newWarning("01500", constraintDescriptor2.getConstraintName(), constraintDescriptor2.getTableDescriptor().getName()));
                }
            }
            this.dm.invalidateFor(constraintDescriptor, 19, this.lcc);
            this.dm.clearDependencies(this.lcc, constraintDescriptor);
        }
        this.createNewBackingCongloms((ArrayList)object5, null);
        this.td = this.dd.getTableDescriptor(this.tableId);
        this.compressTable();
        ColumnDescriptorList columnDescriptorList2 = this.td.getColumnDescriptorList();
        this.dd.dropColumnDescriptor(this.td.getUUID(), string, this.tc);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n9 - columnDescriptor.getPosition()];
        int n15 = columnDescriptor.getPosition();
        n = 0;
        while (n15 < n9) {
            ColumnDescriptor columnDescriptor2 = columnDescriptorList2.elementAt(n15);
            this.dd.dropColumnDescriptor(this.td.getUUID(), columnDescriptor2.getColumnName(), this.tc);
            columnDescriptor2.setPosition(n15);
            if (columnDescriptor2.isAutoincrement()) {
                columnDescriptor2.setAutoinc_create_or_modify_Start_Increment(0);
            }
            tupleDescriptorArray[n] = columnDescriptor2;
            ++n15;
            ++n;
        }
        this.dd.addDescriptorArray(tupleDescriptorArray, this.td, 2, false, this.tc);
        List list = this.dd.getProvidersDescriptorList(this.td.getObjectID().toString());
        Object object8 = list.listIterator();
        while (object8.hasNext()) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)object8.next();
            DependableFinder dependableFinder = dependencyDescriptor.getProviderFinder();
            if (!(dependableFinder instanceof DDColumnDependableFinder)) continue;
            object3 = (DDColumnDependableFinder)dependableFinder;
            object2 = new FormatableBitSet(((DDColumnDependableFinder)object3).getColumnBitMap());
            object = new FormatableBitSet((FormatableBitSet)object2);
            ((FormatableBitSet)object).clear();
            int n16 = ((FormatableBitSet)object2).getLength();
            for (int i = 0; i < n16; ++i) {
                if (i < this.droppedColumnPosition && ((FormatableBitSet)object2).isSet(i)) {
                    ((FormatableBitSet)object).set(i);
                }
                if (i <= this.droppedColumnPosition || !((FormatableBitSet)object2).isSet(i)) continue;
                ((FormatableBitSet)object).set(i - 1);
            }
            if (((FormatableBitSet)object).equals(object2)) continue;
            this.dd.dropStoredDependency(dependencyDescriptor, this.tc);
            ((DDColumnDependableFinder)object3).setColumnBitMap(((FormatableBitSet)object).getByteArray());
            this.dd.addDescriptor(dependencyDescriptor, null, 6, true, this.tc);
        }
        this.dd.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), this.tc, columnDescriptor);
        columnDescriptorList2.remove(this.td.getColumnDescriptor(string));
        object8 = this.dd.getTriggerDescriptors(this.td);
        Enumeration enumeration2 = ((GenericDescriptorList)object8).elements();
        while (enumeration2.hasMoreElements()) {
            Object var34_62;
            TriggerDescriptor triggerDescriptor = (TriggerDescriptor)enumeration2.nextElement();
            this.dd.dropTriggerDescriptor(triggerDescriptor, this.tc);
            object3 = this.dd.getSchemaDescriptor(triggerDescriptor.getSchemaDescriptor().getUUID(), null);
            object2 = this.lcc.pushCompilerContext((SchemaDescriptor)object3);
            object = object2.getParser();
            StatementNode statementNode = object.parseStatement(triggerDescriptor.getTriggerDefinition());
            this.lcc.popCompilerContext((CompilerContext)object2);
            object2 = null;
            try {
                try {
                    CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(class$org$apache$derby$impl$sql$compile$ColumnReference == null ? AlterTableConstantAction.class$("org.apache.derby.impl.sql.compile.ColumnReference") : class$org$apache$derby$impl$sql$compile$ColumnReference);
                    statementNode.accept(collectNodesVisitor);
                    Vector vector = collectNodesVisitor.getList();
                    SPSDescriptor sPSDescriptor = triggerDescriptor.getActionSPS(this.lcc);
                    int[] nArray = new int[this.td.getNumberOfColumns()];
                    Arrays.fill(nArray, -1);
                    sPSDescriptor.setText(this.dd.getTriggerActionString(statementNode, triggerDescriptor.getOldReferencingName(), triggerDescriptor.getNewReferencingName(), triggerDescriptor.getTriggerDefinition(), triggerDescriptor.getReferencedCols(), nArray, 0, triggerDescriptor.getTableDescriptor(), triggerDescriptor.getTriggerEventMask(), true));
                    object3 = this.dd.getSchemaDescriptor(triggerDescriptor.getSchemaDescriptor().getUUID(), null);
                    object2 = this.lcc.pushCompilerContext((SchemaDescriptor)object3);
                    object2.setReliability(0);
                    object = object2.getParser();
                    statementNode = object.parseStatement(sPSDescriptor.getText());
                    object2.setCurrentDependent(sPSDescriptor.getPreparedStatement());
                    statementNode.bindStatement();
                    this.dm.addDependency(sPSDescriptor, this.td, this.lcc.getContextManager());
                }
                catch (StandardException standardException) {
                    if (standardException.getMessageId().equals("42X04")) {
                        if (bl) {
                            triggerDescriptor.drop(this.lcc);
                            this.activation.addWarning(StandardException.newWarning("01502", triggerDescriptor.getName(), this.td.getName()));
                            var34_62 = null;
                            if (object2 == null) continue;
                            this.lcc.popCompilerContext((CompilerContext)object2);
                            continue;
                        }
                        throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)string, (Object)"TRIGGER", (Object)triggerDescriptor.getName());
                    }
                    throw standardException;
                }
                var34_62 = null;
                if (object2 != null) {
                    this.lcc.popCompilerContext((CompilerContext)object2);
                }
            }
            catch (Throwable throwable) {
                var34_62 = null;
                if (object2 != null) {
                    this.lcc.popCompilerContext((CompilerContext)object2);
                }
                throw throwable;
            }
            this.dd.addDescriptor(triggerDescriptor, this.sd, 13, false, this.tc);
        }
    }

    private void modifyColumnType(int n) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        ColumnDescriptor columnDescriptor2 = null;
        columnDescriptor2 = new ColumnDescriptor(this.columnInfo[n].name, columnDescriptor.getPosition(), this.columnInfo[n].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, this.tc);
        this.dd.addDescriptor(columnDescriptor2, this.td, 2, false, this.tc);
    }

    private void modifyColumnConstraint(String string, boolean bl) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(string);
        ColumnDescriptor columnDescriptor2 = null;
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType().getNullabilityType(bl);
        ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
        int n = columnDescriptor.getPosition();
        for (int i = 0; i < constraintDescriptorList.size(); ++i) {
            ConglomerateDescriptor conglomerateDescriptor;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (constraintDescriptor.getConstraintType() != 3) continue;
            ColumnDescriptorList columnDescriptorList = constraintDescriptor.getColumnDescriptors();
            for (int j = 0; j < columnDescriptorList.size() && columnDescriptorList.elementAt(j).getPosition() == n && (conglomerateDescriptor = this.td.getConglomerateDescriptor(constraintDescriptor.getConglomerateId())).getIndexDescriptor().isUnique(); ++j) {
                this.recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(conglomerateDescriptor, this.td, this.activation, this.lcc);
            }
        }
        columnDescriptor2 = new ColumnDescriptor(string, columnDescriptor.getPosition(), dataTypeDescriptor, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc());
        this.dd.dropColumnDescriptor(this.td.getUUID(), string, this.tc);
        this.dd.addDescriptor(columnDescriptor2, this.td, 2, false, this.tc);
    }

    private void modifyColumnDefault(int n) throws StandardException {
        Object object;
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        DataDescriptorGenerator dataDescriptorGenerator = this.dd.getDataDescriptorGenerator();
        int n2 = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            object = new DefaultDescriptor(this.dd, this.columnInfo[n].oldDefaultUUID, this.td.getUUID(), n2);
            this.dm.invalidateFor((Provider)object, 31, this.lcc);
            this.dm.clearDependencies(this.lcc, (Dependent)object);
        }
        object = this.columnInfo[n].newDefaultUUID;
        if (this.columnInfo[n].defaultInfo != null && object == null) {
            object = this.dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n].name, n2, this.columnInfo[n].dataType, this.columnInfo[n].defaultValue, this.columnInfo[n].defaultInfo, this.td, (UUID)object, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc, this.columnInfo[n].autoinc_create_or_modify_Start_Increment);
        this.dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, this.tc);
        this.dd.addDescriptor(columnDescriptor, this.td, 2, false, this.tc);
        if (this.columnInfo[n].action == 6) {
            long l = this.getColumnMax(this.td, this.columnInfo[n].name, this.columnInfo[n].autoincInc);
            this.dd.setAutoincrementValue(this.tc, this.td.getUUID(), this.columnInfo[n].name, l, true);
        } else if (this.columnInfo[n].action == 5) {
            this.dd.setAutoincrementValue(this.tc, this.td.getUUID(), this.columnInfo[n].name, this.columnInfo[n].autoincStart, false);
        }
    }

    private void compressTable() throws StandardException {
        Properties properties = new Properties();
        ExecRow execRow = this.td.getEmptyExecRow();
        int[] nArray = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes();
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow execRow2 = this.activation.getExecutionFactory().getValueRow(execRow.nColumns() - 1);
            int[] nArray2 = new int[nArray.length - 1];
            for (int i = 0; i < execRow2.nColumns(); ++i) {
                execRow2.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? execRow.getColumn(i + 1) : execRow.getColumn(i + 1 + 1));
                nArray2[i] = nArray[i < this.droppedColumnPosition - 1 ? i : i + 1];
            }
            execRow = execRow2;
            nArray = nArray2;
        }
        this.setUpAllSorts(execRow, rowLocation);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i = 0; i < this.bulkFetchSize; ++i) {
            this.baseRow[i] = this.td.getEmptyExecRow();
            this.baseRowArray[i] = this.baseRow[i].getRowArray();
            this.compressRL[i] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long l = this.tc.createAndLoadConglomerate("heap", execRow.getRowArray(), null, nArray, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController scanController = this.tc.openScan(l, false, 4, 7, 5, null, null, 0, null, null, 0);
        scanController.setEstimatedRowCount(this.rowCount);
        scanController.close();
        scanController = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(l, this.dd);
        }
        long l2 = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l2);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l, this.tc);
        this.tc.dropConglomerate(l2);
        this.cleanUp();
    }

    private void truncateTable() throws StandardException {
        Object object;
        TupleDescriptor tupleDescriptor;
        Object object2;
        Properties properties = new Properties();
        ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
        for (int i = 0; i < constraintDescriptorList.size(); ++i) {
            object2 = constraintDescriptorList.elementAt(i);
            if (!(object2 instanceof ReferencedKeyConstraintDescriptor) || !((ReferencedKeyConstraintDescriptor)(tupleDescriptor = (ReferencedKeyConstraintDescriptor)object2)).hasNonSelfReferencingFK(1)) continue;
            throw StandardException.newException("XCL48.S", this.td.getName());
        }
        GenericDescriptorList genericDescriptorList = this.dd.getTriggerDescriptors(this.td);
        object2 = genericDescriptorList.elements();
        while (object2.hasMoreElements()) {
            tupleDescriptor = (TriggerDescriptor)object2.nextElement();
            if (!((TriggerDescriptor)tupleDescriptor).listensForEvent(2) || !((TriggerDescriptor)tupleDescriptor).isEnabled()) continue;
            throw StandardException.newException("XCL49.S", (Object)this.td.getName(), (Object)((TriggerDescriptor)tupleDescriptor).getName());
        }
        ExecRow execRow = this.td.getEmptyExecRow();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long l = this.tc.createConglomerate("heap", execRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0);
        this.getAffectedIndexes();
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            this.collation = new int[this.numIndexes][];
            for (int i = 0; i < this.numIndexes; ++i) {
                this.indexRows[i] = this.compressIRGs[i].getIndexRowTemplate();
                this.compressIRGs[i].getIndexRow(execRow, rowLocation, this.indexRows[i], null);
                int[] nArray = this.compressIRGs[i].baseColumnPositions();
                object = this.compressIRGs[i].isAscending();
                int n = nArray.length + 1;
                this.ordering[i] = new ColumnOrdering[n];
                this.collation[i] = new int[nArray.length + 1];
                for (int j = 0; j < n - 1; ++j) {
                    this.ordering[i][j] = new IndexColumnOrder(j, (boolean)object[j]);
                }
                this.ordering[i][n - 1] = new IndexColumnOrder(n - 1);
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] lArray = new long[this.numIndexes];
            for (int i = 0; i < this.numIndexes; ++i) {
                this.updateIndex(l, this.dd, i, lArray);
            }
        }
        long l2 = this.td.getHeapConglomerateId();
        object = this.td.getConglomerateDescriptor(l2);
        this.dd.updateConglomerateDescriptor((ConglomerateDescriptor)object, l, this.tc);
        this.tc.dropConglomerate(l2);
        this.cleanUp();
    }

    private void updateAllIndexes(long l, DataDictionary dataDictionary) throws StandardException {
        long[] lArray = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(l, dataDictionary, 0, lArray);
            }
            for (int i = 1; i < this.numIndexes; ++i) {
                this.openBulkFetchScan(l);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(i, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(l, dataDictionary, i, lArray);
                this.closeBulkFetchScan();
            }
        } else {
            for (int i = 0; i < this.numIndexes; ++i) {
                this.updateIndex(l, dataDictionary, i, lArray);
            }
        }
    }

    private void updateIndex(long l, DataDictionary dataDictionary, int n, long[] lArray) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[n]);
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.indexConglomerateNumbers[n], false, 4, 7, 5);
        conglomerateController.getInternalTablePropertySet(properties);
        int n2 = this.indexRows[n].nColumns();
        properties.put("baseConglomerateId", Long.toString(l));
        if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
            properties.put("nUniqueColumns", Integer.toString(n2 - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(n2));
        }
        if (conglomerateDescriptor.getIndexDescriptor().isUniqueWithDuplicateNulls()) {
            properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
        }
        properties.put("rowLocationColumn", Integer.toString(n2 - 1));
        properties.put("nKeyFields", Integer.toString(n2));
        conglomerateController.close();
        CardinalityCounter cardinalityCounter = null;
        boolean bl = false;
        if (!this.truncateTable) {
            long l2;
            this.sorters[n].completedInserts();
            this.sorters[n] = null;
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                cardinalityCounter = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n]));
                bl = true;
            } else {
                cardinalityCounter = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n]));
            }
            lArray[n] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[n].getRowArray(), this.ordering[n], this.collation[n], properties, 0, cardinalityCounter, null);
            if (bl) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
            if ((l2 = cardinalityCounter.getRowCount()) > 0L) {
                long[] lArray2 = cardinalityCounter.getCardinality();
                for (int i = 0; i < lArray2.length; ++i) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(l2, lArray2[i]), i + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                }
            }
        } else {
            lArray[n] = this.tc.createConglomerate("BTREE", this.indexRows[n].getRowArray(), this.ordering[n], this.collation[n], properties, 0);
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
        }
        dataDictionary.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[n]), lArray[n], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[n]);
    }

    private void getAffectedIndexes() throws StandardException {
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        if (!this.compressTable && !this.truncateTable) {
            objectArray2 = new ArrayList();
            for (int i = 0; i < this.compressIRGs.length; ++i) {
                ConglomerateDescriptor conglomerateDescriptor;
                objectArray = this.compressIRGs[i].baseColumnPositions();
                for (n = 0; n < objectArray.length && objectArray[n] != this.droppedColumnPosition; ++n) {
                }
                if (n == objectArray.length) continue;
                if (objectArray.length == 1 || this.behavior == 0 && this.compressIRGs[i].isUnique()) {
                    --this.numIndexes;
                    conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                    this.dropConglomerate(conglomerateDescriptor, this.td, true, (List)objectArray2, this.activation, this.activation.getLanguageConnectionContext());
                    this.compressIRGs[i] = null;
                    continue;
                }
                if (!this.compressIRGs[i].isUnique()) continue;
                conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)this.columnInfo[0].name, (Object)"UNIQUE INDEX", (Object)conglomerateDescriptor.getConglomerateName());
            }
            this.createNewBackingCongloms((ArrayList)objectArray2, this.indexConglomerateNumbers);
            IndexRowGenerator[] indexRowGeneratorArray = new IndexRowGenerator[this.numIndexes];
            objectArray = new long[this.numIndexes];
            n = 0;
            int n2 = 0;
            while (n < this.numIndexes) {
                while (this.compressIRGs[n2] == null) {
                    ++n2;
                }
                int[] nArray = this.compressIRGs[n2].baseColumnPositions();
                indexRowGeneratorArray[n] = this.compressIRGs[n2];
                objectArray[n] = (int)this.indexConglomerateNumbers[n2];
                boolean[] blArray = this.compressIRGs[n2].isAscending();
                boolean bl = false;
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (nArray[i] > this.droppedColumnPosition) {
                        int n4 = i;
                        nArray[n4] = nArray[n4] - 1;
                        continue;
                    }
                    if (nArray[i] != this.droppedColumnPosition) continue;
                    nArray[i] = 0;
                    bl = true;
                }
                if (bl) {
                    int[] nArray2 = new int[--n3];
                    boolean[] blArray2 = new boolean[n3];
                    int n5 = 0;
                    for (int i = 0; i < n3; ++i) {
                        if (n5 == 0 && nArray[i + n5] == 0) {
                            ++n5;
                        }
                        nArray2[i] = nArray[i + n5];
                        blArray2[i] = blArray[i + n5];
                    }
                    IndexDescriptor indexDescriptor = this.compressIRGs[n2].getIndexDescriptor();
                    indexDescriptor.setBaseColumnPositions(nArray2);
                    indexDescriptor.setIsAscending(blArray2);
                    indexDescriptor.setNumberOfOrderedColumns(indexDescriptor.numberOfOrderedColumns() - 1);
                }
                ++n;
                ++n2;
            }
            this.compressIRGs = indexRowGeneratorArray;
            this.indexConglomerateNumbers = objectArray;
        }
        if ((objectArray2 = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs)) != null) {
            this.indexConglomerateNumbers = (long[])objectArray2[1];
            this.compressIRGs = (IndexRowGenerator[])objectArray2[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int i = 0; i < this.numIndexes; ++i) {
            objectArray = this.compressIRGs[i].getIndexDescriptor().baseColumnPositions();
            for (n = 0; n < objectArray.length; ++n) {
                this.indexedCols.set(objectArray[n]);
            }
        }
    }

    private void createNewBackingCongloms(ArrayList arrayList, long[] lArray) throws StandardException {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            CreateIndexConstantAction createIndexConstantAction = (CreateIndexConstantAction)arrayList.get(i);
            if (this.dd.getConglomerateDescriptor(createIndexConstantAction.getCreatedUUID()) == null) continue;
            this.executeConglomReplacement(createIndexConstantAction, this.activation);
            long l = createIndexConstantAction.getReplacedConglomNumber();
            long l2 = createIndexConstantAction.getCreatedConglomNumber();
            ConglomerateDescriptor[] conglomerateDescriptorArray = this.td.getConglomerateDescriptors(l);
            for (n2 = 0; n2 < conglomerateDescriptorArray.length; ++n2) {
                conglomerateDescriptorArray[n2].setConglomerateNumber(l2);
            }
            if (lArray == null) continue;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                if (lArray[n2] != l) continue;
                lArray[n2] = l2;
            }
        }
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        int n;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.collation = new int[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        for (n = 0; n < this.numIndexes; ++n) {
            this.indexRows[n] = this.compressIRGs[n].getIndexRowTemplate();
            this.compressIRGs[n].getIndexRow(execRow, rowLocation, this.indexRows[n], null);
            this.collation[n] = this.compressIRGs[n].getColumnCollationIds(this.td.getColumnDescriptorList());
            int[] nArray = this.compressIRGs[n].baseColumnPositions();
            boolean[] blArray = this.compressIRGs[n].isAscending();
            int n2 = nArray.length + 1;
            boolean bl = this.numIndexes == 1;
            BasicSortObserver basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n], bl);
            this.ordering[n] = new ColumnOrdering[n2];
            for (int i = 0; i < n2 - 1; ++i) {
                this.ordering[n][i] = new IndexColumnOrder(i, blArray[i]);
            }
            this.ordering[n][n2 - 1] = new IndexColumnOrder(n2 - 1);
            this.sortIds[n] = this.tc.createSort(null, this.indexRows[n].getRowArrayClone(), this.ordering[n], basicSortObserver, false, this.estimatedRowCount, -1);
        }
        this.sorters = new SortController[this.numIndexes];
        for (n = 0; n < this.numIndexes; ++n) {
            this.sorters[n] = this.tc.openSort(this.sortIds[n]);
            this.needToDropSort[n] = true;
        }
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        int n;
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int n2;
            n = 0;
            n = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = n != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += n;
            for (n2 = 0; n2 < n; ++n2) {
                this.validRow[n2] = true;
            }
            for (n2 = n; n2 < this.bulkFetchSize; ++n2) {
                this.validRow[n2] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (n = 0; n < this.currentRow.nColumns(); ++n) {
                    this.currentRow.setColumn(n + 1, n < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(n + 1) : this.baseRow[this.currentCompressRow].getColumn(n + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int n = this.compressIRGs.length;
            if (n > 1 && this.sequential) {
                n = 1;
            }
            for (int i = 0; i < n; ++i) {
                this.insertIntoSorter(i, rowLocation);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i = 0; i < this.currentRow.getRowArray().length; ++i) {
            if (!this.indexedCols.get(i + 1) || !(this.currentRow.getRowArray()[i] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i].getObject();
        }
    }

    private void insertIntoSorter(int n, RowLocation rowLocation) throws StandardException {
        this.indexRows[n].getNewObjectArray();
        this.compressIRGs[n].getIndexRow(this.currentRow, (RowLocation)rowLocation.cloneValue(false), this.indexRows[n], null);
        this.sorters[n].insert(this.indexRows[n].getRowArray());
    }

    private void cleanUp() throws StandardException {
        int n;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (n = 0; n < this.compressIRGs.length; ++n) {
                if (this.sorters[n] != null) {
                    this.sorters[n].completedInserts();
                }
                this.sorters[n] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (n = 0; n < this.needToDropSort.length; ++n) {
                if (!this.needToDropSort[n]) continue;
                this.tc.dropSort(this.sortIds[n]);
                this.needToDropSort[n] = false;
            }
        }
    }

    private int getSemiRowCount(TransactionController transactionController) throws StandardException {
        int n = 0;
        ScanController scanController = transactionController.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (scanController.next() && ++n != 2) {
        }
        scanController.close();
        return n;
    }

    private void updateNewColumnToDefault(ColumnDescriptor columnDescriptor) throws StandardException {
        DefaultInfo defaultInfo = columnDescriptor.getDefaultInfo();
        String string = columnDescriptor.getColumnName();
        String string2 = defaultInfo.isGeneratedColumn() ? "default" : columnDescriptor.getDefaultInfo().getDefaultText();
        String string3 = "UPDATE " + IdUtil.mkQualifiedName(this.td.getSchemaName(), this.td.getName()) + " SET " + IdUtil.normalToDelimited(string) + "=" + string2;
        AlterTableConstantAction.executeUpdate(this.lcc, string3);
    }

    private static void executeUpdate(LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(string);
        ResultSet resultSet = preparedStatement.executeSubStatement(languageConnectionContext, true, 0L);
        resultSet.close();
    }

    private long getColumnMax(TableDescriptor tableDescriptor, String string, long l) throws StandardException {
        String string2 = l > 0L ? "MAX" : "MIN";
        String string3 = "SELECT  " + string2 + "(" + IdUtil.normalToDelimited(string) + ") FROM " + IdUtil.mkQualifiedName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(string3);
        ResultSet resultSet = preparedStatement.executeSubStatement(this.lcc, false, 0L);
        DataValueDescriptor[] dataValueDescriptorArray = resultSet.getNextRow().getRowArray();
        resultSet.close();
        resultSet.finish();
        return dataValueDescriptorArray[0].getLong();
    }

    private void openBulkFetchScan(long l) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(l, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private void updateNewAutoincrementColumn(String string, long l, long l2) throws StandardException {
        this.lcc.setAutoincrementUpdate(true);
        this.lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), string, new Long(l), l2, 0);
        String string2 = "UPDATE " + IdUtil.mkQualifiedName(this.td.getSchemaName(), this.td.getName()) + " SET " + IdUtil.normalToDelimited(string) + "=" + "org.apache.derby.iapi.db.ConnectionInfo::" + "nextAutoincrementValue(" + StringUtil.quoteStringLiteral(this.td.getSchemaName()) + "," + StringUtil.quoteStringLiteral(this.td.getName()) + "," + StringUtil.quoteStringLiteral(string) + ")";
        try {
            try {
                AlterTableConstantAction.executeUpdate(this.lcc, string2);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("22003")) {
                    throw StandardException.newException("42Z24", standardException, (Object)this.td.getName(), (Object)string);
                }
                throw standardException;
            }
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.lcc.autoincrementFlushCache(this.td.getUUID());
            this.lcc.setAutoincrementUpdate(false);
            throw throwable;
        }
        this.lcc.autoincrementFlushCache(this.td.getUUID());
        this.lcc.setAutoincrementUpdate(false);
    }

    private boolean validateNotNullConstraint(String[] stringArray, boolean[] blArray, int n, LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(stringArray[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)stringArray[i], (Object)this.td.getName());
            }
            if (!columnDescriptor.getType().isNullable()) continue;
            if (n > 0) {
                if (bl) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(IdUtil.normalToDelimited(stringArray[i]) + " IS NOT NULL ");
            }
            bl = true;
            blArray[i] = true;
        }
        if (bl && n > 0 && !ConstraintConstantAction.validateConstraint(null, stringBuffer.toString(), this.td, languageConnectionContext, false)) {
            if (string.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            if (string.equals("X0Y63.S.1")) {
                throw StandardException.newException("X0Y63.S.1", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", (Object)this.td.getQualifiedName(), (Object)stringArray[0]);
        }
        return bl;
    }

    private Object[] compressIndexArrays(long[] lArray, IndexRowGenerator[] indexRowGeneratorArray) {
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = lArray.length - 1;
        for (int i = 0; i < lArray.length; ++i) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                if (lArray[i] != lArray2[n3]) continue;
                lArray2[n2--] = i;
                break;
            }
            if (n3 != n) continue;
            lArray2[n++] = lArray[i];
        }
        if (n < lArray.length) {
            long[] lArray3 = new long[n];
            IndexRowGenerator[] indexRowGeneratorArray2 = new IndexRowGenerator[n];
            int[] nArray = new int[lArray.length - n];
            n2 = 0;
            int n4 = lArray.length - 1;
            for (int i = 0; i < lArray.length; ++i) {
                if (i < n) {
                    lArray3[i] = lArray2[i];
                } else {
                    nArray[lArray.length - i - 1] = (int)lArray2[i];
                }
                if (n4 >= n && i == (int)lArray2[n4]) {
                    --n4;
                    continue;
                }
                indexRowGeneratorArray2[n2] = indexRowGeneratorArray[i];
                ++n2;
            }
            Object[] objectArray = new Object[]{nArray, lArray3, indexRowGeneratorArray2};
            return objectArray;
        }
        return null;
    }
}

