/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.impl.services.bytecode.BCClass;
import org.apache.derby.impl.services.bytecode.BCJava;
import org.apache.derby.impl.services.bytecode.BCLocalField;
import org.apache.derby.impl.services.bytecode.BCMethodCaller;
import org.apache.derby.impl.services.bytecode.BCMethodDescriptor;
import org.apache.derby.impl.services.bytecode.CodeChunk;
import org.apache.derby.impl.services.bytecode.Conditional;
import org.apache.derby.impl.services.bytecode.Type;

class BCMethod
implements MethodBuilder {
    static final int CODE_SPLIT_LENGTH = 65535;
    final BCClass cb;
    protected final ClassHolder modClass;
    final String myReturnType;
    private final String myName;
    BCLocalField[] parameters;
    private final String[] parameterTypes;
    Vector thrownExceptions;
    CodeChunk myCode;
    protected ClassMember myEntry;
    private int currentVarNum;
    private int statementNum;
    private boolean handlingOverflow;
    private int subMethodCount;
    private Type[] stackTypes = new Type[8];
    private int stackTypeOffset;
    int maxStack;
    private int stackDepth;
    private Conditional condition;
    private static final byte[] newArrayElementTypeMap = new byte[]{8, 9, 10, 11, 6, 7, 5};
    static final byte T_BOOLEAN = 4;

    BCMethod(ClassBuilder classBuilder, String string, String string2, int n, String[] stringArray, BCJava bCJava) {
        String[] stringArray2;
        this.cb = (BCClass)classBuilder;
        this.modClass = this.cb.modify();
        this.myReturnType = string;
        this.myName = string2;
        if ((n & 8) == 0) {
            this.currentVarNum = 1;
        }
        if (stringArray != null && stringArray.length != 0) {
            int n2 = stringArray.length;
            stringArray2 = new String[n2];
            this.parameters = new BCLocalField[n2];
            for (int i = 0; i < n2; ++i) {
                Type type2 = bCJava.type(stringArray[i]);
                this.parameters[i] = new BCLocalField(type2, this.currentVarNum);
                this.currentVarNum += type2.width();
                stringArray2[i] = type2.vmName();
            }
        } else {
            stringArray2 = BCMethodDescriptor.EMPTY;
        }
        String string3 = BCMethodDescriptor.get(stringArray2, bCJava.type(string).vmName(), bCJava);
        this.myEntry = this.modClass.addMember(string2, string3, n);
        this.myCode = new CodeChunk(this.cb);
        this.parameterTypes = stringArray;
    }

    public String getName() {
        return this.myName;
    }

    public void getParameter(int n) {
        int n2 = this.parameters[n].cpi;
        short s = this.parameters[n].type.vmType();
        if (n2 < 4) {
            this.myCode.addInstr((short)(CodeChunk.LOAD_VARIABLE_FAST[s] + n2));
        } else {
            this.myCode.addInstrWide(CodeChunk.LOAD_VARIABLE[s], n2);
        }
        this.growStack(this.parameters[n].type);
    }

    public void addThrownException(String string) {
        if (this.thrownExceptions == null) {
            this.thrownExceptions = new Vector();
        }
        this.thrownExceptions.add(string);
    }

    public void complete() {
        if (this.myCode.getPC() > 65535) {
            this.splitMethod();
        }
        this.writeExceptions();
        this.myCode.complete(this, this.modClass, this.myEntry, this.maxStack, this.currentVarNum);
    }

    private void splitMethod() {
        int n = 0;
        boolean bl = true;
        int n2 = this.myCode.getPC();
        while (this.cb.limitMsg == null && n2 > 65535) {
            int n3;
            int n4 = n2 < 131070 ? n2 - 65535 : 65534;
            if (n4 > (n3 = n2 - n)) {
                n4 = n3;
            }
            if ((n = bl ? this.myCode.splitZeroStack(this, this.modClass, n, n4) : this.myCode.splitExpressionOut(this, this.modClass, n4, this.maxStack)) < 0) {
                if (!bl) break;
                bl = false;
                n = 0;
            }
            n2 = this.myCode.getPC();
        }
    }

    ClassHolder constantPool() {
        return this.modClass;
    }

    protected void writeExceptions() {
        if (this.thrownExceptions == null) {
            return;
        }
        int n = this.thrownExceptions.size();
        if (n != 0) {
            try {
                ClassFormatOutput classFormatOutput = new ClassFormatOutput(n * 2 + 2);
                classFormatOutput.putU2(n);
                for (int i = 0; i < n; ++i) {
                    String string = this.thrownExceptions.get(i).toString();
                    int n2 = this.modClass.addClassReference(string);
                    classFormatOutput.putU2(n2);
                }
                this.myEntry.addAttribute("Exceptions", classFormatOutput);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void growStack(int n, Type type2) {
        this.stackDepth += n;
        if (this.stackDepth > this.maxStack) {
            this.maxStack = this.stackDepth;
        }
        if (this.stackTypeOffset >= this.stackTypes.length) {
            Type[] typeArray = new Type[this.stackTypes.length + 8];
            System.arraycopy(this.stackTypes, 0, typeArray, 0, this.stackTypes.length);
            this.stackTypes = typeArray;
        }
        this.stackTypes[this.stackTypeOffset++] = type2;
    }

    private void growStack(Type type2) {
        this.growStack(type2.width(), type2);
    }

    private Type popStack() {
        --this.stackTypeOffset;
        Type type2 = this.stackTypes[this.stackTypeOffset];
        this.stackDepth -= type2.width();
        return type2;
    }

    private Type[] copyStack() {
        Type[] typeArray = new Type[this.stackTypeOffset];
        System.arraycopy(this.stackTypes, 0, typeArray, 0, this.stackTypeOffset);
        return typeArray;
    }

    public void pushThis() {
        this.myCode.addInstr((short)42);
        this.growStack(1, this.cb.classType);
    }

    public void push(byte by) {
        this.push(by, Type.BYTE);
    }

    public void push(boolean bl) {
        this.push(bl ? 1 : 0, Type.BOOLEAN);
    }

    public void push(short s) {
        this.push(s, Type.SHORT);
    }

    public void push(int n) {
        this.push(n, Type.INT);
    }

    public void dup() {
        Type type2 = this.popStack();
        this.myCode.addInstr(type2.width() == 2 ? (short)92 : 89);
        this.growStack(type2);
        this.growStack(type2);
    }

    public void swap() {
        Type type2 = this.popStack();
        Type type3 = this.popStack();
        this.growStack(type2);
        this.growStack(type3);
        if (type2.width() == 1) {
            if (type3.width() == 1) {
                this.myCode.addInstr((short)95);
                return;
            }
            this.myCode.addInstr((short)91);
            this.myCode.addInstr((short)87);
        } else if (type3.width() == 1) {
            this.myCode.addInstr((short)93);
            this.myCode.addInstr((short)88);
        } else {
            this.myCode.addInstr((short)94);
            this.myCode.addInstr((short)88);
        }
        this.growStack(type2);
        this.popStack();
    }

    private void push(int n, Type type2) {
        CodeChunk codeChunk = this.myCode;
        if (n >= -1 && n <= 5) {
            codeChunk.addInstr((short)(3 + n));
        } else if (n >= -128 && n <= 127) {
            codeChunk.addInstrU1((short)16, n);
        } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            codeChunk.addInstrU2((short)17, n);
        } else {
            int n2 = this.modClass.addConstant(n);
            this.addInstrCPE((short)18, n2);
        }
        this.growStack(type2.width(), type2);
    }

    public void push(long l) {
        CodeChunk codeChunk = this.myCode;
        if (l == 0L || l == 1L) {
            short s = l == 0L ? (short)9 : 10;
            codeChunk.addInstr(s);
        } else {
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                this.push((int)l, Type.LONG);
                codeChunk.addInstr((short)133);
                return;
            }
            int n = this.modClass.addConstant(l);
            codeChunk.addInstrU2((short)20, n);
        }
        this.growStack(2, Type.LONG);
    }

    public void push(float f) {
        CodeChunk codeChunk = this.myCode;
        if ((double)f == 0.0) {
            codeChunk.addInstr((short)11);
        } else if ((double)f == 1.0) {
            codeChunk.addInstr((short)12);
        } else if ((double)f == 2.0) {
            codeChunk.addInstr((short)13);
        } else {
            int n = this.modClass.addConstant(f);
            this.addInstrCPE((short)18, n);
        }
        this.growStack(1, Type.FLOAT);
    }

    public void push(double d) {
        CodeChunk codeChunk = this.myCode;
        if (d == 0.0) {
            codeChunk.addInstr((short)14);
        } else {
            int n = this.modClass.addConstant(d);
            codeChunk.addInstrU2((short)20, n);
        }
        this.growStack(2, Type.DOUBLE);
    }

    public void push(String string) {
        int n = this.modClass.addConstant(string);
        this.addInstrCPE((short)18, n);
        this.growStack(1, Type.STRING);
    }

    public void methodReturn() {
        short s;
        if (this.stackDepth != 0) {
            Type type2 = this.popStack();
            s = CodeChunk.RETURN_OPCODE[type2.vmType()];
        } else {
            s = 177;
        }
        this.myCode.addInstr(s);
    }

    public Object describeMethod(short s, String string, String string2, String string3) {
        Type type2 = this.cb.factory.type(string3);
        String string4 = BCMethodDescriptor.get(BCMethodDescriptor.EMPTY, type2.vmName(), this.cb.factory);
        if (string == null && s != 184) {
            Type type3 = this.stackTypes[this.stackTypeOffset - 1];
            if (string == null) {
                string = type3.javaName();
            }
        }
        int n = this.modClass.addMethodReference(string, string2, string4, s == 185);
        return new BCMethodCaller(s, type2, n);
    }

    public int callMethod(Object object) {
        this.popStack();
        BCMethodCaller bCMethodCaller = (BCMethodCaller)object;
        int n = bCMethodCaller.cpi;
        short s = bCMethodCaller.opcode;
        if (s == 185) {
            this.myCode.addInstrU2U1U1(s, n, (short)1, (short)0);
        } else {
            this.myCode.addInstrU2(s, n);
        }
        Type type2 = bCMethodCaller.type;
        int n2 = type2.width();
        if (n2 != 0) {
            this.growStack(n2, type2);
        } else if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
        return n;
    }

    public int callMethod(short s, String string, String string2, String string3, int n) {
        Type type2;
        Type type3;
        String[] stringArray;
        Type type4 = this.cb.factory.type(string3);
        int n2 = this.stackDepth;
        Object var8_8 = null;
        if (n == 0) {
            stringArray = BCMethodDescriptor.EMPTY;
        } else {
            stringArray = new String[n];
            for (int i = n - 1; i >= 0; --i) {
                type3 = this.popStack();
                stringArray[i] = type3.vmName();
            }
        }
        String string4 = BCMethodDescriptor.get(stringArray, type4.vmName(), this.cb.factory);
        type3 = null;
        if (s != 184) {
            type3 = this.popStack();
        }
        if ((type2 = this.vmNameDeclaringClass(string)) != null) {
            type3 = type2;
        }
        int n3 = this.modClass.addMethodReference(type3.vmNameSimple, string2, string4, s == 185);
        if (s == 185) {
            short s2 = (short)(n2 - this.stackDepth);
            this.myCode.addInstrU2U1U1(s, n3, s2, (short)0);
        } else {
            this.myCode.addInstrU2(s, n3);
        }
        int n4 = type4.width();
        if (n4 != 0) {
            this.growStack(n4, type4);
        } else if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
        return n3;
    }

    private Type vmNameDeclaringClass(String string) {
        if (string == null) {
            return null;
        }
        return this.cb.factory.type(string);
    }

    public void callSuper() {
        this.pushThis();
        this.callMethod((short)183, this.cb.getSuperClassName(), "<init>", "void", 0);
    }

    public void pushNewStart(String string) {
        int n = this.modClass.addClassReference(string);
        this.myCode.addInstrU2((short)187, n);
        this.myCode.addInstr((short)89);
        Type type2 = this.cb.factory.type(string);
        this.growStack(1, type2);
        this.growStack(1, type2);
    }

    public void pushNewComplete(int n) {
        this.callMethod((short)183, null, "<init>", "void", n);
    }

    public void upCast(String string) {
        Type type2;
        this.stackTypes[this.stackTypeOffset - 1] = type2 = this.cb.factory.type(string);
    }

    public void cast(String string) {
        Type type2 = this.stackTypes[this.stackTypeOffset - 1];
        short s = type2.vmType();
        if (s == 7 && string.equals(type2.javaName())) {
            return;
        }
        Type type3 = this.cb.factory.type(string);
        this.popStack();
        short s2 = type3.vmType();
        if (s == 7) {
            int n = this.modClass.addClassReference(type3.vmNameSimple);
            this.myCode.addInstrU2((short)192, n);
        } else {
            short s3 = 0;
            while (s != s2 && s3 != -999) {
                short[] sArray = CodeChunk.CAST_CONVERSION_INFO[s][s2];
                s = sArray[1];
                s3 = sArray[0];
                if (s3 == 0) continue;
                this.myCode.addInstr(s3);
            }
        }
        this.growStack(type3);
    }

    public void isInstanceOf(String string) {
        int n = this.modClass.addClassReference(string);
        this.myCode.addInstrU2((short)193, n);
        this.popStack();
        this.growStack(1, Type.BOOLEAN);
    }

    public void pushNull(String string) {
        this.myCode.addInstr((short)1);
        this.growStack(1, this.cb.factory.type(string));
    }

    public void getField(LocalField localField) {
        BCLocalField bCLocalField = (BCLocalField)localField;
        Type type2 = bCLocalField.type;
        this.pushThis();
        this.myCode.addInstrU2((short)180, bCLocalField.cpi);
        this.popStack();
        this.growStack(type2);
    }

    public void getField(String string, String string2, String string3) {
        Type type2 = this.popStack();
        Type type3 = this.vmNameDeclaringClass(string);
        if (type3 != null) {
            type2 = type3;
        }
        this.getField((short)180, type2.vmNameSimple, string2, string3);
    }

    public void getStaticField(String string, String string2, String string3) {
        this.getField((short)178, string, string2, string3);
    }

    private void getField(short s, String string, String string2, String string3) {
        Type type2 = this.cb.factory.type(string3);
        int n = this.modClass.addFieldReference(this.vmNameDeclaringClass((String)string).vmNameSimple, string2, type2.vmName());
        this.myCode.addInstrU2(s, n);
        this.growStack(type2);
    }

    public void setField(LocalField localField) {
        BCLocalField bCLocalField = (BCLocalField)localField;
        Type type2 = bCLocalField.type;
        this.putField(bCLocalField.type, bCLocalField.cpi, false);
        if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
    }

    public void putField(LocalField localField) {
        BCLocalField bCLocalField = (BCLocalField)localField;
        Type type2 = bCLocalField.type;
        this.putField(bCLocalField.type, bCLocalField.cpi, true);
    }

    public void putField(String string, String string2) {
        Type type2 = this.cb.factory.type(string2);
        int n = this.modClass.addFieldReference(this.cb.classType.vmNameSimple, string, type2.vmName());
        this.putField(type2, n, true);
    }

    private void putField(Type type2, int n, boolean bl) {
        if (bl) {
            this.myCode.addInstr(type2.width() == 2 ? (short)92 : 89);
            this.growStack(type2);
        }
        this.pushThis();
        this.swap();
        this.myCode.addInstrU2((short)181, n);
        this.popStack();
        this.popStack();
    }

    public void putField(String string, String string2, String string3) {
        Type type2 = this.popStack();
        Type type3 = this.popStack();
        this.myCode.addInstr(type2.width() == 2 ? (short)93 : 90);
        this.growStack(type2);
        this.growStack(type3);
        this.growStack(type2);
        Type type4 = this.vmNameDeclaringClass(string);
        if (type4 != null) {
            type3 = type4;
        }
        Type type5 = this.cb.factory.type(string3);
        int n = this.modClass.addFieldReference(type3.vmNameSimple, string2, type5.vmName());
        this.myCode.addInstrU2((short)181, n);
        this.popStack();
        this.popStack();
    }

    public void conditionalIfNull() {
        this.conditionalIf((short)199);
    }

    public void conditionalIf() {
        this.conditionalIf((short)153);
    }

    private void conditionalIf(short s) {
        this.popStack();
        this.condition = new Conditional(this.condition, this.myCode, s, this.copyStack());
    }

    public void startElseCode() {
        Type[] typeArray = this.condition.startElse(this, this.myCode, this.copyStack());
        this.stackDepth = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            this.stackTypes[i] = typeArray[i];
            this.stackDepth += this.stackTypes[i].width();
        }
        this.stackTypeOffset = typeArray.length;
    }

    public void completeConditional() {
        this.condition = this.condition.end(this, this.myCode, this.stackTypes, this.stackTypeOffset);
    }

    public void pop() {
        Type type2 = this.popStack();
        this.myCode.addInstr(type2.width() == 2 ? (short)88 : 87);
        if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
    }

    public void endStatement() {
        if (this.stackDepth != 0) {
            this.pop();
        }
    }

    public void getArrayElement(int n) {
        this.push(n);
        this.popStack();
        Type type2 = this.popStack();
        String string = type2.javaName();
        String string2 = string.substring(0, string.length() - 2);
        Type type3 = this.cb.factory.type(string2);
        short s = type3.vmType();
        if (s == 2 && type3.vmName().equals("Z")) {
            s = 0;
        }
        this.myCode.addInstr(CodeChunk.ARRAY_ACCESS[s]);
        this.growStack(type3);
    }

    public void setArrayElement(int n) {
        this.push(n);
        this.swap();
        Type type2 = this.popStack();
        this.popStack();
        this.popStack();
        short s = type2.vmType();
        if (s == 2 && type2.vmName().equals("Z")) {
            s = 0;
        }
        this.myCode.addInstr(CodeChunk.ARRAY_STORE[s]);
    }

    public void pushNewArray(String string, int n) {
        this.push(n);
        this.popStack();
        Type type2 = this.cb.factory.type(string);
        if (type2.vmType() == 7) {
            int n2 = this.modClass.addClassReference(type2.javaName());
            this.myCode.addInstrU2((short)189, n2);
        } else {
            int n3 = type2.vmType() == 2 && 'Z' == type2.vmName().charAt(0) ? 4 : newArrayElementTypeMap[type2.vmType()];
            this.myCode.addInstrU1((short)188, n3);
        }
        this.growStack(1, this.cb.factory.type(string.concat("[]")));
    }

    private void addInstrCPE(short s, int n) {
        if (n >= 65535) {
            this.cb.addLimitExceeded(this, "constant_pool_count", 65535, n);
        }
        this.myCode.addInstrCPE(s, n);
    }

    public boolean statementNumHitLimit(int n) {
        if (this.statementNum > 2048) {
            return true;
        }
        this.statementNum += n;
        return false;
    }

    private void overflowMethodCheck() {
        if (this.handlingOverflow) {
            return;
        }
        if (this.condition != null) {
            return;
        }
        int n = this.myCode.getPC();
        if (n < 55000) {
            return;
        }
        if (this.parameters != null && this.parameters.length != 0) {
            return;
        }
        BCMethod bCMethod = this.getNewSubMethod(this.myReturnType, false);
        this.handlingOverflow = true;
        this.callSubMethod(bCMethod);
        this.methodReturn();
        this.complete();
        this.handlingOverflow = false;
        this.myEntry = bCMethod.myEntry;
        this.myCode = bCMethod.myCode;
        this.currentVarNum = bCMethod.currentVarNum;
        this.statementNum = bCMethod.statementNum;
        this.stackTypes = bCMethod.stackTypes;
        this.stackTypeOffset = bCMethod.stackTypeOffset;
        this.maxStack = bCMethod.maxStack;
        this.stackDepth = bCMethod.stackDepth;
    }

    final BCMethod getNewSubMethod(String string, boolean bl) {
        int n = this.myEntry.getModifier();
        n &= 0xFFFFFFFA;
        String string2 = this.myName + "_s" + Integer.toString(this.subMethodCount++);
        BCMethod bCMethod = (BCMethod)this.cb.newMethodBuilder(n |= 2, string, string2, bl ? this.parameterTypes : null);
        bCMethod.thrownExceptions = this.thrownExceptions;
        return bCMethod;
    }

    final void callSubMethod(BCMethod bCMethod) {
        short s;
        if ((this.myEntry.getModifier() & 8) == 0) {
            s = 182;
            this.pushThis();
        } else {
            s = 184;
        }
        int n = bCMethod.parameters == null ? 0 : bCMethod.parameters.length;
        for (int i = 0; i < n; ++i) {
            this.getParameter(i);
        }
        this.callMethod(s, this.modClass.getName(), bCMethod.getName(), bCMethod.myReturnType, n);
    }
}

