/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.CometEvent;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;
import org.glassfish.web.valve.GlassFishValve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValveBase
implements Contained,
Lifecycle,
Valve,
GlassFishValve,
MBeanRegistration {
    private static Logger log = Logger.getLogger(ValveBase.class.getName());
    protected Container container = null;
    protected int debug = 0;
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String info = "org.apache.catalina.core.ValveBase/1.0";
    protected Valve next = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;
    protected ObjectName controller;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Valve getNext() {
        return this.next;
    }

    @Override
    public void setNext(Valve valve) {
        this.next = valve;
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public abstract int invoke(Request var1, Response var2) throws IOException, ServletException;

    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
    }

    @Override
    public void event(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response, CometEvent event) throws IOException, ServletException {
        if (this.getNext() != null) {
            this.getNext().event(request, response, event);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void setObjectName(ObjectName oname) {
        this.oname = oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getParentName(ObjectName valveName) {
        return null;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        String className;
        int period;
        Container container = this.getContainer();
        if (container == null || !(container instanceof ContainerBase)) {
            return null;
        }
        ContainerBase containerBase = (ContainerBase)container;
        Pipeline pipe = containerBase.getPipeline();
        GlassFishValve[] valves = pipe.getValves();
        String parentName = "";
        if (!(container instanceof Engine)) {
            if (container instanceof Host) {
                parentName = ",host=" + container.getName();
            } else if (container instanceof Context) {
                String path = ((Context)container).getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)container.getParent();
                parentName = ",path=" + path + ",host=" + host.getName();
            } else if (container instanceof Wrapper) {
                Context ctx = (Context)container.getParent();
                String path = ctx.getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)ctx.getParent();
                parentName = ",servlet=" + container.getName() + ",path=" + path + ",host=" + host.getName();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("valve parent=" + parentName + " " + parent);
        }
        if ((period = (className = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            className = className.substring(period + 1);
        }
        int seq = 0;
        for (int i = 0; i < valves.length && valves[i] != this; ++i) {
            if (valves[i] == null || valves[i].getClass() != this.getClass()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Duplicate " + valves[i] + " " + this + " " + container);
            }
            ++seq;
        }
        String ext = "";
        if (seq > 0) {
            ext = ",seq=" + seq;
        }
        ObjectName objectName = new ObjectName(domain + ":type=Valve,name=" + className + ext + parentName);
        if (log.isLoggable(Level.FINE)) {
            log.fine("valve objectname = " + objectName);
        }
        return objectName;
    }

    public ObjectName getContainerName() {
        if (this.container == null) {
            return null;
        }
        return ((ContainerBase)this.container).getJmxName();
    }

    private void registerMBean() {
        block6: {
            if (this.getObjectName() == null && this.container != null) {
                try {
                    ObjectName vname;
                    String domain = ((ContainerBase)this.container).getDomain();
                    if (this.container instanceof StandardContext) {
                        domain = ((StandardContext)this.container).getEngineName();
                    }
                    if (this.container instanceof StandardWrapper) {
                        Container ctx = ((StandardWrapper)this.container).getParent();
                        domain = ((StandardContext)ctx).getEngineName();
                    }
                    if ((vname = this.createObjectName(domain, ((ContainerBase)this.container).getJmxName())) != null) {
                        this.setObjectName(vname);
                        this.setController(vname);
                        Registry.getRegistry(null, null).registerComponent((Object)this, vname, this.getClass().getName());
                    }
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.INFO)) break block6;
                    log.log(Level.INFO, "Can't register valve " + this, t);
                }
            }
        }
    }

    private void unregisterMBean() {
        block3: {
            try {
                if (this.oname != null && this.oname == this.controller && Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                    Registry.getRegistry(null, null).getMBeanServer().unregisterMBean(this.oname);
                    this.setObjectName(null);
                    this.setController(null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(Level.INFO)) break block3;
                log.log(Level.INFO, "Can't unregister valve " + this, t);
            }
        }
    }
}

