/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FacesServlet
implements Servlet {
    private static final String ALLOWED_HTTP_METHODS_ATTR = "com.sun.faces.allowedHttpMethods";
    private Set<String> allowedUnknownHttpMethods;
    private Set<HttpMethod> allowedKnownHttpMethods;
    private final Set<HttpMethod> defaultAllowedHttpMethods = EnumSet.range(HttpMethod.OPTIONS, HttpMethod.CONNECT);
    private Set<HttpMethod> allHttpMethods;
    private boolean allowAllMethods;
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private ServletConfig servletConfig = null;
    private boolean initFacesContextReleased = false;

    public void destroy() {
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.servletConfig = null;
        this.uninitHttpMethodValidityVerification();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            ResourceBundle rb = LOGGER.getResourceBundle();
            String msg = rb.getString("severe.webapp.facesservlet.init_failed");
            Throwable rootCause = e.getCause() != null ? e.getCause() : e;
            LOGGER.log(Level.SEVERE, msg, rootCause);
            throw new UnavailableException(msg);
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = servletConfig.getInitParameter(LIFECYCLE_ID_ATTR);
            if (null == lifecycleId) {
                lifecycleId = servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
            }
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
            this.initHttpMethodValidityVerification();
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
    }

    private void initHttpMethodValidityVerification() {
        assert (null == this.allowedUnknownHttpMethods);
        assert (null != this.defaultAllowedHttpMethods);
        assert (null == this.allHttpMethods);
        this.allHttpMethods = EnumSet.allOf(HttpMethod.class);
        this.allowedUnknownHttpMethods = Collections.emptySet();
        this.allowedKnownHttpMethods = this.defaultAllowedHttpMethods;
        String[] methods = new String[]{};
        String allowedHttpMethodsString = this.servletConfig.getServletContext().getInitParameter(ALLOWED_HTTP_METHODS_ATTR);
        if (null != allowedHttpMethodsString) {
            methods = allowedHttpMethodsString.split("\\s+");
            assert (null != methods);
            this.allowedUnknownHttpMethods = new HashSet<String>(methods.length);
            ArrayList<String> allowedKnownHttpMethodsStringList = new ArrayList<String>();
            for (String cur : methods) {
                boolean isKnownHttpMethod;
                if (cur.equals("*")) {
                    this.allowAllMethods = true;
                    this.allowedUnknownHttpMethods = Collections.emptySet();
                    return;
                }
                try {
                    HttpMethod.valueOf(cur);
                    isKnownHttpMethod = true;
                }
                catch (IllegalArgumentException e) {
                    isKnownHttpMethod = false;
                }
                if (!isKnownHttpMethod) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        HttpMethod[] values = HttpMethod.values();
                        Object[] arg = new Object[values.length + 1];
                        arg[0] = cur;
                        System.arraycopy(values, HttpMethod.OPTIONS.ordinal(), arg, 1, values.length);
                        LOGGER.log(Level.WARNING, "warning.webapp.facesservlet.init_invalid_http_method", arg);
                    }
                    if (this.allowedUnknownHttpMethods.contains(cur)) continue;
                    this.allowedUnknownHttpMethods.add(cur);
                    continue;
                }
                if (allowedKnownHttpMethodsStringList.contains(cur)) continue;
                allowedKnownHttpMethodsStringList.add(cur);
            }
            if (5 == allowedKnownHttpMethodsStringList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(0)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(1)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(2)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(3)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(4)));
            } else if (4 == allowedKnownHttpMethodsStringList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(0)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(1)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(2)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(3)));
            } else if (3 == allowedKnownHttpMethodsStringList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(0)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(1)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(2)));
            } else if (2 == allowedKnownHttpMethodsStringList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(0)), HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(1)));
            } else if (1 == allowedKnownHttpMethodsStringList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(0)));
            } else {
                ArrayList<HttpMethod> restList = new ArrayList<HttpMethod>(allowedKnownHttpMethodsStringList.size() - 1);
                for (int i = 1; i < allowedKnownHttpMethodsStringList.size() - 1; ++i) {
                    restList.add(HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(i)));
                }
                HttpMethod first = HttpMethod.valueOf((String)allowedKnownHttpMethodsStringList.get(0));
                HttpMethod[] rest = new HttpMethod[restList.size()];
                restList.toArray(rest);
                this.allowedKnownHttpMethods = EnumSet.of(first, rest);
            }
        }
    }

    private void uninitHttpMethodValidityVerification() {
        assert (null != this.allowedUnknownHttpMethods);
        assert (null != this.defaultAllowedHttpMethods);
        assert (null != this.allHttpMethods);
        this.allowedUnknownHttpMethods.clear();
        this.allowedUnknownHttpMethods = null;
        this.allowedKnownHttpMethods.clear();
        this.allowedKnownHttpMethods = null;
        this.allHttpMethods.clear();
        this.allHttpMethods = null;
    }

    public void service(ServletRequest req, ServletResponse resp) throws IOException, ServletException {
        String pathInfo;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        this.requestStart(request.getRequestURI());
        if (!this.isHttpMethodValid(request)) {
            response.sendError(400);
            return;
        }
        if (Thread.currentThread().isInterrupted() && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINE, "Thread {0} given to FacesServlet.service() in interrupted state", Thread.currentThread().getName());
        }
        if ((pathInfo = request.getPathInfo()) != null && ((pathInfo = pathInfo.toUpperCase()).startsWith("/WEB-INF/") || pathInfo.equals("/WEB-INF") || pathInfo.startsWith("/META-INF/") || pathInfo.equals("/META-INF"))) {
            response.sendError(404);
            return;
        }
        if (!this.initFacesContextReleased) {
            FacesContext initFacesContext = FacesContext.getCurrentInstance();
            if (null != initFacesContext) {
                initFacesContext.release();
            }
            this.initFacesContextReleased = true;
        }
        FacesContext context = this.facesContextFactory.getFacesContext(this.servletConfig.getServletContext(), request, response, this.lifecycle);
        try {
            ResourceHandler handler = context.getApplication().getResourceHandler();
            if (handler.isResourceRequest(context)) {
                handler.handleResourceRequest(context);
            } else {
                this.lifecycle.execute(context);
                this.lifecycle.render(context);
            }
        }
        catch (FacesException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new ServletException(e.getMessage(), e);
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new ServletException(t.getMessage(), t);
        }
        finally {
            context.release();
        }
        this.requestEnd();
    }

    private boolean isHttpMethodValid(HttpServletRequest request) {
        boolean result = false;
        if (this.allowAllMethods) {
            result = true;
        } else {
            boolean isKnownHttpMethod;
            String requestMethodString = request.getMethod();
            HttpMethod requestMethod = null;
            try {
                requestMethod = HttpMethod.valueOf(requestMethodString);
                isKnownHttpMethod = true;
            }
            catch (IllegalArgumentException e) {
                isKnownHttpMethod = false;
            }
            result = isKnownHttpMethod ? this.allowedKnownHttpMethods.contains((Object)requestMethod) : this.allowedUnknownHttpMethods.contains(requestMethodString);
        }
        return result;
    }

    private void requestStart(String requestUri) {
    }

    private void requestEnd() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpMethod {
        OPTIONS("OPTIONS"),
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        TRACE("TRACE"),
        CONNECT("CONNECT");

        private String name;

        private HttpMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

