/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.FileList;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.ImagePlanProgressTracker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DownloadFileTask
implements Callable<File> {
    Image img;
    List<FileList.DataSink> fal;
    Fmri fmri;
    File download_dir;
    int nfile;
    ImagePlanProgressTracker tracker;

    private DownloadFileTask() {
    }

    public DownloadFileTask(Image img, List<FileList.DataSink> fal, Fmri fmri, File download_dir, int nfile, ImagePlanProgressTracker tracker) {
        this.img = img;
        this.fal = fal;
        this.fmri = fmri;
        this.download_dir = download_dir;
        this.nfile = nfile;
        this.tracker = tracker;
    }

    @Override
    public File call() throws IOException {
        return this.download();
    }

    public File download() throws IOException {
        int numRead;
        byte[] buf = new byte[32768];
        FileList.DataSink fa = this.fal.get(0);
        String hash = fa.getHash();
        String hv = URLEncoder.encode(hash, "UTF-8");
        HttpURLConnection uc = this.img.getRepositoryURLConnection("file/0/" + hv, this.fmri);
        this.img.checkRepositoryConnection(uc);
        BufferedInputStream tis = new BufferedInputStream(uc.getInputStream());
        String outfilename = hash;
        this.img.getLogger().log(Level.FINER, "downloading", outfilename);
        this.tracker.startFileDownload(this.nfile, fa.getSize());
        File gzipfile = new File(this.download_dir, outfilename);
        fa.setGzipFile(gzipfile);
        FileOutputStream fos = new FileOutputStream(gzipfile);
        long xferedBytes = 0L;
        while ((numRead = tis.read(buf, 0, buf.length)) != -1) {
            ((OutputStream)fos).write(buf, 0, numRead);
            this.tracker.onFileDownloadProgress(this.nfile, xferedBytes += (long)numRead);
        }
        this.tracker.onFileDownloadProgress(this.nfile, xferedBytes);
        ((OutputStream)fos).close();
        this.tracker.endFileDownload(this.nfile++, fa.getSize());
        for (int j = 1; j < this.fal.size(); ++j) {
            FileList.DataSink nfa = this.fal.get(j);
            nfa.setGzipFile(gzipfile);
        }
        return gzipfile;
    }
}

