/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class Constraint {
    String pkgName;
    Version minVer;
    Version maxVer;
    Presence presence;
    String source;

    Constraint(String pkgName, Version minVer, Version maxVer, Presence presence, String source) {
        if (pkgName == null || minVer == null || presence == null || source == null) {
            throw new IllegalArgumentException("invalid Constraint args");
        }
        this.pkgName = pkgName;
        this.minVer = minVer;
        this.maxVer = maxVer;
        this.presence = presence;
        this.source = source;
    }

    public String toString() {
        return "Pkg " + this.pkgName + ": " + (Object)((Object)this.presence) + " min_version: " + this.minVer + " max_version: " + this.maxVer + " defined by: pkg:/" + this.source;
    }

    public boolean equals(Object o) {
        Constraint v = (Constraint)o;
        return this.pkgName.equals(v.pkgName) && this.presence.equals((Object)v.presence) && this.minVer.equals(v.minVer) && (this.maxVer == null && v.maxVer == null || this.maxVer != null && v.maxVer != null && this.maxVer.equals(v.maxVer));
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.pkgName != null ? this.pkgName.hashCode() : 0);
        hash = 59 * hash + (this.minVer != null ? this.minVer.hashCode() : 0);
        hash = 59 * hash + (this.maxVer != null ? this.maxVer.hashCode() : 0);
        hash = 59 * hash + (this.presence != null ? this.presence.hashCode() : 0);
        return hash;
    }

    static Constraint makeRequiredConstraint(Fmri fmri, String src) {
        return new Constraint(fmri.getName(), fmri.getVersion(), null, Presence.ALWAYS, src);
    }

    static Constraint makeOptionalConstraint(Fmri fmri, String src) {
        return new Constraint(fmri.getName(), fmri.getVersion(), null, Presence.MAYBE, src);
    }

    static Constraint makeIncorporationConstraint(Fmri fmri, String src) {
        return new Constraint(fmri.getName(), fmri.getVersion(), fmri.getVersion(), Presence.MAYBE, src);
    }

    Version checkForWork(Fmri fmriPresent) throws ConstraintException {
        if (fmriPresent == null) {
            if (this.presence == Presence.MAYBE || this.presence == Presence.NEVER) {
                return null;
            }
            return this.minVer;
        }
        if (this.presence == Presence.NEVER) {
            throw new PresenceConflict(this, Constraint.makeRequiredConstraint(fmriPresent, ""));
        }
        Version vp = fmriPresent.getVersion();
        if (vp.compareTo(this.minVer) < 0) {
            return this.minVer;
        }
        if (this.maxVer != null && vp.compareTo(this.maxVer) > 0 && !vp.isSuccessor(this.maxVer)) {
            throw new DowngradeConflict(this, fmriPresent);
        }
        return null;
    }

    Constraint combine(Constraint proposed) throws ConstraintException {
        Version minv;
        if (!this.pkgName.equals(proposed.pkgName)) {
            throw new IllegalArgumentException("constraint package names do not match");
        }
        Presence p = this.presence.combine(proposed.presence);
        if (p == Presence.ERROR) {
            throw new PresenceConflict(proposed, this);
        }
        Version maxv = null;
        maxv = this.maxVer == null ? proposed.maxVer : (proposed.maxVer == null ? this.maxVer : (this.maxVer.compareTo(proposed.maxVer) < 0 ? this.maxVer : proposed.maxVer));
        Version version = minv = this.minVer.compareTo(proposed.minVer) < 0 ? proposed.minVer : this.minVer;
        if (maxv != null && maxv.compareTo(minv) < 0 && !minv.isSuccessor(maxv)) {
            throw new VersionConflict(proposed, this);
        }
        return new Constraint(this.pkgName, minv, maxv, p, this.source);
    }

    static class Set {
        Fmri activeFmri = null;
        HashMap<String, List<Constraint>> constraints = new HashMap();
        HashMap<String, ConstraintEntry> loadedFmriVersions = new HashMap();

        Set() {
        }

        void finishLoading(Fmri fmri) {
            if (this.activeFmri != fmri) {
                throw new IllegalArgumentException("finishing for wrong fmri (" + this.activeFmri + " != " + fmri + ")");
            }
            this.activeFmri = null;
        }

        boolean startLoading(Fmri fmri) {
            if (this.activeFmri != null) {
                throw new IllegalArgumentException("Already loading!");
            }
            this.activeFmri = fmri;
            String fmri_name = fmri.getName();
            ConstraintEntry ce = this.loadedFmriVersions.get(fmri_name);
            if (ce != null) {
                if (ce.v.equals(fmri.getVersion())) {
                    this.activeFmri = null;
                    return false;
                }
                for (String p : ce.pkglist) {
                    List<Constraint> cl = this.constraints.get(p);
                    for (Constraint c : new ArrayList<Constraint>(cl)) {
                        if (!c.source.equals(fmri_name)) continue;
                        cl.remove(c);
                    }
                }
            } else {
                ce = new ConstraintEntry();
            }
            ce.v = fmri.getVersion();
            ce.pkglist = new ArrayList<String>();
            this.loadedFmriVersions.put(fmri_name, ce);
            return true;
        }

        void updateConstraints(Constraint c) throws ConstraintException {
            String activeFmriName = this.activeFmri.getName();
            ConstraintEntry ce = this.loadedFmriVersions.get(activeFmriName);
            if (!activeFmriName.equals(c.source)) {
                throw new IllegalArgumentException("invalid constraint argument");
            }
            if (c.presence == Presence.ALWAYS) {
                return;
            }
            List<Constraint> cl = this.constraints.get(c.pkgName);
            if (cl != null) {
                for (Constraint cc : cl) {
                    cc.combine(c);
                }
                cl.add(c);
            } else {
                cl = new ArrayList<Constraint>();
                cl.add(c);
                this.constraints.put(c.pkgName, cl);
            }
            if (!ce.pkglist.contains(c.pkgName)) {
                ce.pkglist.add(c.pkgName);
            }
        }

        Constraint applyConstraints(Constraint c) throws ConstraintException {
            List<Constraint> cl = this.constraints.get(c.pkgName);
            if (cl != null) {
                Iterator<Constraint> ic = cl.iterator();
                Constraint ca = ic.next();
                while (ic.hasNext()) {
                    ca = ca.combine(ic.next());
                }
                return ca.combine(c);
            }
            return null;
        }

        Fmri applyConstraintsToFmri(Fmri fmri) throws ConstraintException {
            Constraint nc;
            Constraint ic = Constraint.makeRequiredConstraint(fmri, "");
            try {
                nc = this.applyConstraints(ic);
            }
            catch (ConstraintException ce) {
                throw new FmriConflict(ce.oldConstraint, fmri);
            }
            if (nc == null || ic.equals(nc)) {
                return fmri;
            }
            Fmri nfmri = fmri.clone();
            nfmri.version = nc.minVer;
            return nfmri;
        }

        class ConstraintEntry {
            Version v;
            List<String> pkglist;

            ConstraintEntry() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Presence {
        ERROR(0, "ERROR"),
        ALWAYS(1, "Required"),
        MAYBE(2, "Optional"),
        NEVER(3, "Excluded");

        static final Presence[][] compat;
        private final int index;
        private final String str;

        private Presence(int index, String str) {
            this.index = index;
            this.str = str;
        }

        public String toString() {
            return this.str;
        }

        private Presence combine(Presence p) {
            Presence left = this;
            Presence right = p;
            if (this.index > p.index) {
                left = p;
                right = this;
            }
            for (Presence[] pa : compat) {
                if (!pa[0].equals((Object)left) || !pa[1].equals((Object)right)) continue;
                return pa[2];
            }
            throw new IllegalArgumentException("invalid Presence: this=" + (Object)((Object)this) + ", p=" + (Object)((Object)p));
        }

        static {
            compat = new Presence[][]{{ALWAYS, ALWAYS, ALWAYS}, {ALWAYS, MAYBE, ALWAYS}, {ALWAYS, NEVER, ERROR}, {MAYBE, MAYBE, MAYBE}, {MAYBE, NEVER, NEVER}, {NEVER, NEVER, NEVER}};
        }
    }

    static class FmriConflict
    extends ConstraintException {
        Fmri fmri;

        FmriConflict(Constraint c, Fmri f) {
            super(c, null);
            this.fmri = f;
        }

        public String getMessage() {
            return "Package " + this.fmri + " conflicts with constraint in installed pkg:/" + this.newConstraint.source + ": " + this.newConstraint;
        }
    }

    static class DowngradeConflict
    extends ConstraintException {
        Fmri fmri;

        DowngradeConflict(Constraint c, Fmri f) {
            super(c, null);
            this.fmri = f;
        }

        public String getMessage() {
            return "Package " + this.newConstraint.source + " contains constraint that requires downgrade of installed pkg " + this.fmri + ": " + this.newConstraint;
        }
    }

    static class VersionConflict
    extends ConstraintException {
        VersionConflict(Constraint newc, Constraint oldc) {
            super(newc, oldc);
        }

        public String getMessage() {
            return "Package " + this.newConstraint.source + " contains constraint incompatible with constraint in installed package " + this.oldConstraint.source + "\nproposed: " + this.newConstraint + "\ninstalled: " + this.oldConstraint;
        }
    }

    static class PresenceConflict
    extends ConstraintException {
        PresenceConflict(Constraint newc, Constraint oldc) {
            super(newc, oldc);
        }

        public String getMessage() {
            return "Package presence is both required and prohibited:\n\t" + this.newConstraint + "\n\t" + this.oldConstraint + "\n";
        }
    }

    static class ConstraintException
    extends IllegalArgumentException {
        Constraint newConstraint;
        Constraint oldConstraint;

        ConstraintException(Constraint newc, Constraint oldc) {
            this.newConstraint = newc;
            this.oldConstraint = oldc;
        }
    }
}

