/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.util.http.MimeHeaders;
import com.sun.grizzly.websockets.ProtocolHandler;
import com.sun.grizzly.websockets.draft06.Draft06Handler;
import com.sun.grizzly.websockets.draft07.Draft07Handler;
import com.sun.grizzly.websockets.draft08.Draft08Handler;
import com.sun.grizzly.websockets.draft76.Draft76Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Version {
    DRAFT17("13"){

        public ProtocolHandler createHandler(boolean mask) {
            return new Draft08Handler(mask);
        }

        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT08("8"){

        public ProtocolHandler createHandler(boolean mask) {
            return new Draft08Handler(mask);
        }

        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT07("7"){

        public ProtocolHandler createHandler(boolean mask) {
            return new Draft07Handler(mask);
        }

        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT06("6"){

        public ProtocolHandler createHandler(boolean mask) {
            return new Draft06Handler(mask);
        }

        public boolean validate(MimeHeaders headers) {
            return this.wireProtocolVersion.equals(headers.getHeader("Sec-WebSocket-Version"));
        }
    }
    ,
    DRAFT76(""){

        public ProtocolHandler createHandler(boolean mask) {
            return new Draft76Handler();
        }

        public boolean validate(MimeHeaders headers) {
            return headers.getHeader("Sec-WebSocket-Key1") != null;
        }

        public boolean isFragmentationSupported() {
            return false;
        }
    };

    String wireProtocolVersion;

    public abstract ProtocolHandler createHandler(boolean var1);

    public abstract boolean validate(MimeHeaders var1);

    private Version(String wireProtocolVersion) {
        this.wireProtocolVersion = wireProtocolVersion;
    }

    public String toString() {
        return this.name();
    }

    public boolean isFragmentationSupported() {
        return true;
    }

    public static String getSupportedWireProtocolVersions() {
        StringBuilder sb = new StringBuilder();
        for (Version v : Version.values()) {
            if (v.wireProtocolVersion.length() <= 0) continue;
            sb.append(v.wireProtocolVersion).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

