/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.http.servlet.HttpServletRequestImpl;
import com.sun.grizzly.http.servlet.HttpServletResponseImpl;
import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.tcp.http11.InternalInputBuffer;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import com.sun.grizzly.websockets.BaseNetworkHandler;
import com.sun.grizzly.websockets.WebSocketException;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerNetworkHandler
extends BaseNetworkHandler {
    private final Request request;
    private final Response response;
    private final InternalInputBuffer inputBuffer;
    private final InternalOutputBuffer outputBuffer;
    private final Mapper mapper;
    private UDecoder urlDecoder = new UDecoder();

    public ServerNetworkHandler(Request req, Response resp, Mapper mapper) {
        this.request = req;
        this.response = resp;
        this.mapper = mapper;
        this.inputBuffer = (InternalInputBuffer)req.getInputBuffer();
        this.outputBuffer = (InternalOutputBuffer)resp.getOutputBuffer();
    }

    protected int read() {
        int read = 0;
        ByteChunk newChunk = new ByteChunk(8192);
        try {
            ByteChunk bytes = new ByteChunk(8192);
            if (this.chunk.getLength() > 0) {
                newChunk.append(this.chunk);
            }
            int count = 8192;
            while (count == 8192) {
                count = this.inputBuffer.doRead(bytes, this.request);
                newChunk.append(bytes);
                read += count;
            }
        }
        catch (IOException e) {
            throw new WebSocketException(e.getMessage(), e);
        }
        if (read == -1) {
            throw new WebSocketException("Read -1 bytes.  Connection closed?");
        }
        this.chunk.setBytes(newChunk.getBytes(), 0, newChunk.getEnd());
        return read;
    }

    public byte get() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            this.fill();
            try {
                return (byte)this.chunk.substract();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    public byte[] get(int count) {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            try {
                byte[] bytes = new byte[count];
                for (int total = 0; total < count; total += this.chunk.substract(bytes, total, count - total)) {
                    if (this.chunk.getLength() >= count) continue;
                    this.read();
                }
                return bytes;
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            if (this.chunk.getLength() == 0) {
                this.read();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        InternalOutputBuffer internalOutputBuffer = this.outputBuffer;
        synchronized (internalOutputBuffer) {
            try {
                ByteChunk buffer = new ByteChunk();
                buffer.setBytes(bytes, 0, bytes.length);
                this.outputBuffer.doWrite(buffer, this.response);
                this.outputBuffer.flush();
            }
            catch (IOException e) {
                throw new WebSocketException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() {
        ByteChunk byteChunk = this.chunk;
        synchronized (byteChunk) {
            return this.chunk.getLength() != 0;
        }
    }

    public HttpServletRequest getRequest() throws IOException {
        GrizzlyRequest r = new GrizzlyRequest();
        r.setRequest(this.request);
        return new WSServletRequestImpl(r, this.mapper);
    }

    public HttpServletResponse getResponse() throws IOException {
        GrizzlyResponse r = new GrizzlyResponse();
        r.setResponse(this.response);
        return new HttpServletResponseImpl(r);
    }

    public String toString() {
        InputReader inputStream = (InputReader)this.inputBuffer.getInputStream();
        int remoteSocketAddress = ((SocketChannel)inputStream.key.channel()).socket().getPort();
        StringBuilder sb = new StringBuilder();
        sb.append("SNH[");
        sb.append(remoteSocketAddress);
        sb.append(",").append(super.toString());
        sb.append(']');
        return sb.toString();
    }

    private class WSServletRequestImpl
    extends HttpServletRequestImpl {
        private String pathInfo;
        private String servletPath;
        private String contextPath;

        public WSServletRequestImpl(GrizzlyRequest r, Mapper mapper) throws IOException {
            super(r);
            this.setContextImpl(new ServletContextImpl());
            if (mapper != null) {
                this.updatePaths(r, mapper);
            }
        }

        public String getContextPath() {
            if (this.contextPath != null) {
                return this.contextPath;
            }
            return super.getContextPath();
        }

        public String getServletPath() {
            if (this.servletPath != null) {
                return this.servletPath;
            }
            return super.getServletPath();
        }

        public String getPathInfo() {
            if (this.pathInfo != null) {
                return this.pathInfo;
            }
            return super.getPathInfo();
        }

        private void updatePaths(GrizzlyRequest r, Mapper mapper) {
            Request req = r.getRequest();
            try {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                HttpRequestURIDecoder.decode(decodedURI, ServerNetworkHandler.this.urlDecoder, null, null);
                mapper.map(req.remoteHost(), decodedURI, (MappingData)req.getNote(12));
                MappingData data = (MappingData)req.getNote(12);
                this.pathInfo = data.pathInfo.getString();
                this.servletPath = data.requestPath.getString();
                this.contextPath = data.contextPath.getString();
            }
            catch (Exception e) {
                this.pathInfo = null;
                this.servletPath = null;
                this.contextPath = null;
            }
        }
    }
}

