/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.KeepAliveStatsProvider;
import com.sun.grizzly.http.KeepAliveStats;

public class MonitorableKeepAliveStats
extends KeepAliveStats {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public MonitorableKeepAliveStats(GrizzlyMonitoring grizzlyMonitoring, String monitoringId) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        if (grizzlyMonitoring != null) {
            KeepAliveStatsProvider statsProvider = grizzlyMonitoring.getKeepAliveStatsProvider(monitoringId);
            if (statsProvider != null) {
                statsProvider.setStatsObject(this);
            }
            this.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
            this.setKeepAliveTimeoutInSeconds(this.getKeepAliveTimeoutInSeconds());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        super.setMaxKeepAliveRequests(maxKeepAliveRequests);
        this.grizzlyMonitoring.getKeepAliveProbeProvider().setMaxCountRequestsEvent(this.monitoringId, maxKeepAliveRequests);
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        super.setKeepAliveTimeoutInSeconds(timeout);
        this.grizzlyMonitoring.getKeepAliveProbeProvider().setTimeoutInSecondsEvent(this.monitoringId, timeout);
    }

    public void incrementCountConnections() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountConnectionsEvent(this.monitoringId);
    }

    protected void decrementCountConnections() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().decrementCountConnectionsEvent(this.monitoringId);
    }

    public void incrementCountFlushes() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountFlushesEvent(this.monitoringId);
    }

    public void incrementCountHits() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountHitsEvent(this.monitoringId);
    }

    public void incrementCountRefusals() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountRefusalsEvent(this.monitoringId);
    }

    public void incrementCountTimeouts() {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountTimeoutsEvent(this.monitoringId);
    }
}

