/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public abstract class UpdateNodeRemoteCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    private Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost", optional=true)
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    protected String remotePort;
    protected String remoteUser;
    protected String sshkeyfile;
    protected String remotepassword;
    protected String sshkeypassphrase;
    protected String windowsdomain;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;

    protected abstract void populateParameters();

    protected abstract RemoteType getType();

    protected abstract String getDefaultPort();

    protected final void executeInternal(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        Node node = null;
        this.logger = context.getLogger();
        node = this.nodes.getNode(this.name);
        if (node == null) {
            String m = Strings.get("noSuchNode", this.name);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        if (node.isDefaultLocalNode()) {
            String m = Strings.get("update.node.config.defaultnode", this.name);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        this.populateParameters();
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.name);
        map.add("installdir", this.installdir);
        map.add("nodehost", this.nodehost);
        map.add("nodedir", this.nodedir);
        map.add("sshport", this.remotePort);
        map.add("sshuser", this.remoteUser);
        map.add("sshkeyfile", this.sshkeyfile);
        map.add("sshpassword", this.remotepassword);
        map.add("sshkeypassphrase", this.sshkeypassphrase);
        map.add("windowsdomain", this.windowsdomain);
        map.add("type", this.getType().toString());
        this.initFromConfig(node);
        this.setDefaults();
        ParameterMap validateMap = new ParameterMap();
        validateMap.add("installdir", this.installdir);
        validateMap.add("nodehost", this.nodehost);
        validateMap.add("nodedir", this.nodedir);
        validateMap.add("sshport", this.remotePort);
        validateMap.add("sshuser", this.remoteUser);
        validateMap.add("sshkeyfile", this.sshkeyfile);
        validateMap.add("sshpassword", this.remotepassword);
        validateMap.add("sshkeypassphrase", this.sshkeypassphrase);
        validateMap.add("windowsdomain", this.windowsdomain);
        validateMap.add("type", this.getType().toString());
        try {
            NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
            nodeUtils.validate(validateMap);
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("node.ssh.invalid.params");
            if (!this.force) {
                String m2 = Strings.get("update.node.ssh.not.updated");
                msg.append(StringUtils.cat(NL, m1, m2, e.getMessage()));
                report.setMessage(msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String m2 = Strings.get("update.node.ssh.continue.force");
            msg.append(StringUtils.cat(NL, m1, e.getMessage(), m2));
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_update-node", report);
        ci.parameters(map);
        ci.execute();
        if (StringUtils.ok(report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private void initFromConfig(Node node) {
        SshAuth ssha;
        SshConnector sshc;
        if (this.nodehost == null) {
            this.nodehost = node.getNodeHost();
        }
        if (this.installdir == null) {
            this.installdir = node.getInstallDir();
        }
        if (this.nodedir == null) {
            this.nodedir = node.getNodeDir();
        }
        if (this.windowsdomain == null) {
            this.windowsdomain = node.getWindowsDomain();
            if (this.windowsdomain == null) {
                this.windowsdomain = node.getNodeHost();
            }
        }
        if ((sshc = node.getSshConnector()) == null) {
            return;
        }
        if (this.remotePort == null) {
            this.remotePort = sshc.getSshPort();
        }
        if ((ssha = sshc.getSshAuth()) == null) {
            return;
        }
        if (this.remoteUser == null) {
            this.remoteUser = ssha.getUserName();
        }
        if (this.sshkeyfile == null) {
            this.sshkeyfile = ssha.getKeyfile();
        }
        if (this.remotepassword == null) {
            this.remotepassword = ssha.getPassword();
        }
        if (this.sshkeypassphrase == null) {
            this.sshkeypassphrase = ssha.getPassword();
        }
    }

    private void setDefaults() {
        if (!StringUtils.ok(this.remotePort)) {
            this.remotePort = this.getDefaultPort();
        }
        if (!StringUtils.ok(this.remoteUser)) {
            this.remoteUser = "${user.name}";
        }
        if (!StringUtils.ok(this.installdir)) {
            this.installdir = "${com.sun.aas.productRoot}";
        }
    }
}

