/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.ExceptionUtil;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFile;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsRemotePinger;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.connect.NodeRunner;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.DcomUtils;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtils {
    public static final String NODE_DEFAULT_SSH_PORT = "22";
    public static final String NODE_DEFAULT_DCOM_PORT = "135";
    public static final String NODE_DEFAULT_REMOTE_USER = "${user.name}";
    static final String NODE_DEFAULT_INSTALLDIR = "${com.sun.aas.productRoot}";
    static final String PARAM_NODEHOST = "nodehost";
    static final String PARAM_INSTALLDIR = "installdir";
    static final String PARAM_NODEDIR = "nodedir";
    static final String PARAM_REMOTEPORT = "sshport";
    public static final String PARAM_REMOTEUSER = "sshuser";
    static final String PARAM_SSHKEYFILE = "sshkeyfile";
    static final String PARAM_REMOTEPASSWORD = "sshpassword";
    static final String PARAM_SSHKEYPASSPHRASE = "sshkeypassphrase";
    public static final String PARAM_WINDOWSDOMAINNAME = "windowsdomain";
    static final String PARAM_TYPE = "type";
    static final String PARAM_INSTALL = "install";
    public static final String PARAM_WINDOWS_DOMAIN = "windowsdomain";
    static final String LANDMARK_FILE = "glassfish/modules/admin-cli.jar";
    private static final String NL = System.getProperty("line.separator");
    private TokenResolver resolver = null;
    private Logger logger = null;
    private Habitat habitat = null;
    SSHLauncher sshL = null;

    NodeUtils(Habitat habitat, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
        this.sshL = habitat.getComponent(SSHLauncher.class);
    }

    static boolean isSSHNode(Node node) {
        if (node == null) {
            return false;
        }
        return node.getType().equals("SSH");
    }

    public static boolean isDcomNode(Node node) {
        if (node == null) {
            return false;
        }
        return node.getType().equals("DCOM");
    }

    String getGlassFishVersionOnNode(Node node) throws CommandValidationException {
        if (node == null) {
            return "";
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("version");
        command.add("--local");
        command.add("--terse");
        NodeRunner nr = new NodeRunner(this.habitat, this.logger);
        StringBuilder output = new StringBuilder();
        try {
            int commandStatus = nr.runAdminCommandOnNode(node, output, command);
            if (commandStatus != 0) {
                return "unknown version: " + output.toString();
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(Strings.get("failed.to.run", ((Object)command).toString(), node.getNodeHost()), e);
        }
        return output.toString().trim();
    }

    void validate(Node node) throws CommandValidationException {
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", node.getName());
        map.add(PARAM_INSTALLDIR, node.getInstallDir());
        map.add(PARAM_NODEHOST, node.getNodeHost());
        map.add(PARAM_NODEDIR, node.getNodeDirAbsolute());
        SshConnector sshc = node.getSshConnector();
        if (sshc != null) {
            map.add(PARAM_REMOTEPORT, sshc.getSshPort());
            SshAuth ssha = sshc.getSshAuth();
            map.add(PARAM_REMOTEUSER, ssha.getUserName());
            map.add(PARAM_SSHKEYFILE, ssha.getKeyfile());
            map.add(PARAM_REMOTEPASSWORD, ssha.getPassword());
            map.add(PARAM_SSHKEYPASSPHRASE, ssha.getKeyPassphrase());
            map.add(PARAM_TYPE, node.getType());
        }
        this.validate(map);
    }

    void validate(ParameterMap map) throws CommandValidationException {
        this.validatePassword((String)map.getOne(PARAM_REMOTEPASSWORD));
        String nodehost = (String)map.getOne(PARAM_NODEHOST);
        this.validateHostName(nodehost);
        this.validateRemote(map, nodehost);
    }

    private void validateRemote(ParameterMap map, String nodehost) throws CommandValidationException {
        RemoteType type2 = this.parseType(map);
        if (type2 == RemoteType.SSH) {
            this.validateSsh(map, nodehost);
        }
        if (nodehost.equals("localhost")) {
            return;
        }
        if (this.sshL == null) {
            return;
        }
        this.validateRemoteConnection(map);
    }

    private void validateSsh(ParameterMap map, String nodehost) throws CommandValidationException {
        String sshkeyfile = (String)map.getOne(PARAM_SSHKEYFILE);
        if (StringUtils.ok(sshkeyfile)) {
            File kfile = new File(this.resolver.resolve(sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
    }

    void validateHostName(String hostName) throws CommandValidationException {
        if (!StringUtils.ok(hostName)) {
            throw new CommandValidationException(Strings.get("nodehost.required"));
        }
        try {
            InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new CommandValidationException(Strings.get("unknown.host", hostName), e);
        }
    }

    private String resolvePassword(String p) {
        try {
            return RelativePathResolver.getRealPasswordFromAlias(p);
        }
        catch (Exception e) {
            return p;
        }
    }

    private void validatePassword(String p) throws CommandValidationException {
        String expandedPassword = null;
        if (StringUtils.ok(p)) {
            try {
                expandedPassword = RelativePathResolver.getRealPasswordFromAlias(p);
            }
            catch (IllegalArgumentException e) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p));
            }
            catch (Exception e) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p), e);
            }
            if (expandedPassword == null) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p));
            }
        }
    }

    void pingRemoteConnection(Node node) throws CommandValidationException {
        RemoteType type2 = RemoteType.valueOf(node.getType());
        this.validateHostName(node.getNodeHost());
        switch (type2) {
            case SSH: {
                this.pingSSHConnection(node);
                break;
            }
            case DCOM: {
                this.pingDcomConnection(node);
                break;
            }
            default: {
                throw new CommandValidationException("Internal Error: unknown type");
            }
        }
    }

    private void pingSSHConnection(Node node) throws CommandValidationException {
        try {
            this.sshL.init(node, this.logger);
            this.sshL.pingConnection();
        }
        catch (Exception e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            String msg = Strings.get("ssh.bad.connect", node.getNodeHost(), "SSH");
            this.logger.warning(StringUtils.cat(": ", msg, m1, m2, this.sshL.toString()));
            throw new CommandValidationException(StringUtils.cat(NL, msg, m1, m2));
        }
    }

    private void pingDcomConnection(Node node) throws CommandValidationException {
        try {
            SshConnector connector = node.getSshConnector();
            SshAuth auth = connector.getSshAuth();
            String host = connector.getSshHost();
            if (!StringUtils.ok(host)) {
                host = node.getNodeHost();
            }
            String username = auth.getUserName();
            String password = this.resolvePassword(auth.getPassword());
            String installdir = node.getInstallDirUnixStyle();
            String domain = node.getWindowsDomain();
            if (!StringUtils.ok(domain)) {
                domain = host;
            }
            if (!StringUtils.ok(installdir)) {
                throw new CommandValidationException(Strings.get("dcom.no.installdir"));
            }
            this.pingDcomConnection(host, domain, username, password, this.getInstallRoot(installdir));
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            String msg = Strings.get("ssh.bad.connect", node.getNodeHost(), "DCOM");
            this.logger.warning(StringUtils.cat(": ", msg, m1, m2));
            throw new CommandValidationException(StringUtils.cat(NL, msg, m1, m2));
        }
    }

    void pingDcomConnection(String host, String domain, String username, String password, String installRoot) throws CommandValidationException {
        if (!StringUtils.ok(password)) {
            throw new CommandValidationException(Strings.get("dcom.nopassword"));
        }
        password = DcomUtils.resolvePassword(this.resolver.resolve(password));
        if (NetUtils.isThisHostLocal(host)) {
            throw new CommandValidationException(Strings.get("dcom.yes.local", host));
        }
        try {
            installRoot = installRoot.replace('/', '\\');
            WindowsRemoteFileSystem wrfs = new WindowsRemoteFileSystem(host, username, password);
            WindowsRemoteFile wrf = new WindowsRemoteFile(wrfs, installRoot);
            WindowsCredentials creds = new WindowsCredentials(host, domain, username, password);
            if (!wrf.exists()) {
                throw new CommandValidationException(Strings.get("dcom.no.remote.install", host, installRoot));
            }
            if (!WindowsRemotePinger.ping(installRoot, creds)) {
                throw new CommandValidationException(Strings.get("dcom.no.connection", host));
            }
        }
        catch (CommandValidationException cve) {
            throw cve;
        }
        catch (Exception ex) {
            throw new CommandValidationException(ex);
        }
    }

    private void validateRemoteConnection(ParameterMap map) throws CommandValidationException {
        RemoteType type2 = this.parseType(map);
        if (type2 == RemoteType.SSH) {
            this.validateSSHConnection(map);
        } else if (type2 == RemoteType.DCOM) {
            this.validateDcomConnection(map);
        }
    }

    private void validateDcomConnection(ParameterMap map) throws CommandValidationException {
        if (Boolean.parseBoolean((String)map.getOne(PARAM_INSTALL))) {
            return;
        }
        String nodehost = this.resolver.resolve((String)map.getOne(PARAM_NODEHOST));
        String installdir = this.resolver.resolve((String)map.getOne(PARAM_INSTALLDIR));
        String user = this.resolver.resolve((String)map.getOne(PARAM_REMOTEUSER));
        String password = (String)map.getOne(PARAM_REMOTEPASSWORD);
        String domain = nodehost;
        this.pingDcomConnection(nodehost, domain, user, password, this.getInstallRoot(installdir));
    }

    private void validateSSHConnection(ParameterMap map) throws CommandValidationException {
        String nodehost = (String)map.getOne(PARAM_NODEHOST);
        String installdir = (String)map.getOne(PARAM_INSTALLDIR);
        String sshport = (String)map.getOne(PARAM_REMOTEPORT);
        String sshuser = (String)map.getOne(PARAM_REMOTEUSER);
        String sshkeyfile = (String)map.getOne(PARAM_SSHKEYFILE);
        String sshpassword = (String)map.getOne(PARAM_REMOTEPASSWORD);
        String sshkeypassphrase = (String)map.getOne(PARAM_SSHKEYPASSPHRASE);
        boolean installFlag = Boolean.parseBoolean((String)map.getOne(PARAM_INSTALL));
        if (!NetUtils.isPortStringValid(this.resolver.resolve(sshport))) {
            throw new CommandValidationException(Strings.get("ssh.invalid.port", sshport));
        }
        int port = Integer.parseInt(this.resolver.resolve(sshport));
        try {
            String resolvedInstallDir = this.resolver.resolve(installdir);
            this.sshL.validate(this.resolver.resolve(nodehost), port, this.resolver.resolve(sshuser), sshpassword, this.resolver.resolve(sshkeyfile), sshkeypassphrase, resolvedInstallDir, LANDMARK_FILE, this.logger);
        }
        catch (IOException e) {
            String m1 = e.getMessage();
            String m2 = "";
            Throwable e2 = e.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            if (e instanceof FileNotFoundException) {
                if (!installFlag) {
                    this.logger.warning(StringUtils.cat(": ", m1, m2, this.sshL.toString()));
                    throw new CommandValidationException(StringUtils.cat(NL, m1, m2));
                }
            }
            String msg = Strings.get("ssh.bad.connect", nodehost, "SSH");
            this.logger.warning(StringUtils.cat(": ", msg, m1, m2, this.sshL.toString()));
            throw new CommandValidationException(StringUtils.cat(NL, msg, m1, m2));
        }
    }

    static void sanitizeReport(ActionReport report) {
        Throwable rootCause;
        if (report != null && report.hasFailures() && report.getFailureCause() != null && (rootCause = ExceptionUtil.getRootCause(report.getFailureCause())) != null && StringUtils.ok(rootCause.getMessage())) {
            report.setMessage(rootCause.getMessage());
        }
    }

    void runAdminCommandOnNode(Node node, List<String> command, AdminCommandContext context, String firstErrorMessage, String humanCommand, StringBuilder output, boolean waitForReaderThreads) {
        ActionReport report = context.getActionReport();
        boolean failure = true;
        String msg1 = firstErrorMessage;
        String msg2 = "";
        String msg3 = "";
        String nodeHost = node.getNodeHost();
        String nodeName = node.getName();
        String installDir = node.getInstallDir();
        if (output == null) {
            output = new StringBuilder();
        }
        if (StringUtils.ok(humanCommand)) {
            msg3 = Strings.get("node.remote.tocomplete", nodeHost, installDir, humanCommand);
        }
        NodeRunner nr = new NodeRunner(this.habitat, this.logger);
        try {
            int status = nr.runAdminCommandOnNode(node, output, waitForReaderThreads, command);
            if (status != 0) {
                msg2 = Strings.get("node.command.failed", nodeName, nodeHost, output.toString().trim(), nr.getLastCommandRun());
                this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
                msg2 = Strings.get("node.command.failed.short", nodeName, nodeHost, output.toString().trim());
            } else {
                failure = false;
                this.logger.info(output.toString().trim());
            }
        }
        catch (SSHCommandExecutionException ec) {
            msg2 = Strings.get("node.ssh.bad.connect", nodeName, nodeHost, ec.getMessage());
            String msg = Strings.get("node.command.failed.ssh.details", nodeName, nodeHost, ec.getCommandRun(), ec.getMessage(), ec.getSSHSettings());
            this.logger.warning(StringUtils.cat(": ", msg1, msg, msg3));
        }
        catch (ProcessManagerException ex) {
            msg2 = Strings.get("node.command.failed.local.details", ex.getMessage(), nr.getLastCommandRun());
            this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
            msg2 = Strings.get("node.command.failed.local.exception", ex.getMessage());
        }
        catch (UnsupportedOperationException e) {
            msg2 = Strings.get("node.not.ssh", nodeName, nodeHost);
            this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
        }
        catch (IllegalArgumentException e) {
            msg2 = e.getMessage();
            this.logger.warning(StringUtils.cat(": ", msg1, msg2, msg3));
        }
        if (failure) {
            report.setMessage(StringUtils.cat(NL + NL, msg1, msg2, msg3));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    void runAdminCommandOnNode(Node node, List<String> command, AdminCommandContext context, String firstErrorMessage, String humanCommand, StringBuilder output) {
        this.runAdminCommandOnNode(node, command, context, firstErrorMessage, humanCommand, output, true);
    }

    private RemoteType parseType(ParameterMap map) throws CommandValidationException {
        try {
            return RemoteType.valueOf((String)map.getOne(PARAM_TYPE));
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }

    private String getInstallRoot(String installDir) {
        char[] chars = installDir.toCharArray();
        char end = chars[chars.length - 1];
        if (end != '/' && end != '\\') {
            return installDir + "/glassfish";
        }
        return installDir + "glassfish";
    }
}

