/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster.windows.process;

import com.sun.enterprise.util.cluster.windows.process.Strings;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import java.util.logging.Level;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.IJIEnumVariant;

public class WindowsWmi {
    private WindowsCredentials bonafides;
    private IJIDispatch dispatch;
    private JIComServer comStub;
    private IJIComObject unknown;
    private JISession session;
    private IJIComObject comObject;
    private Object[] crazyLongMicrosoftArgs;
    private JIVariant variant;
    private int count = -1;
    private String[] processInfo;

    public WindowsWmi(WindowsCredentials bonafides) throws WindowsException {
        try {
            this.bonafides = bonafides;
            JISystem.getLogger().setLevel(Level.INFO);
            JISystem.setInBuiltLogHandler(false);
            JISystem.setAutoRegisteration(true);
            this.crazyLongMicrosoftArgs = new Object[]{new JIString(bonafides.getHost()), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()};
            this.session = JISession.createSession(bonafides.getDomain(), bonafides.getUser(), bonafides.getPassword());
            this.session.useSessionSecurity(true);
            this.session.setGlobalSocketTimeout(5000);
            this.comStub = new JIComServer(JIProgId.valueOf("WbemScripting.SWbemLocator"), bonafides.getHost(), this.session);
            this.unknown = this.comStub.createInstance();
            this.comObject = this.unknown.queryInterface("76A6415B-CB41-11d1-8B02-00600806D9B6");
            this.dispatch = (IJIDispatch)JIObjectFactory.narrowObject(this.comObject.queryInterface("00020400-0000-0000-c000-000000000046"));
            this.setCount();
            this.setInfo();
            this.killme();
        }
        catch (Exception e) {
            this.dispatch = null;
            this.count = -1;
        }
        if (!this.initialized()) {
            throw new WindowsException(Strings.get("WMI.init.error"));
        }
    }

    public final int getCount() throws WindowsException {
        return this.count;
    }

    public final String[] getInfo() throws WindowsException {
        return this.processInfo;
    }

    private void setCount() throws WindowsException {
        try {
            JIVariant[] results = this.dispatch.callMethodA("ConnectServer", this.crazyLongMicrosoftArgs);
            IJIDispatch wbemServices_dispatch = (IJIDispatch)JIObjectFactory.narrowObject(results[0].getObjectAsComObject());
            JIVariant[] results2 = wbemServices_dispatch.callMethodA("InstancesOf", new Object[]{new JIString("Win32_Process"), new Integer(0), JIVariant.OPTIONAL_PARAM()});
            IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject(results2[0].getObjectAsComObject());
            this.variant = wbemObjectSet_dispatch.get("_NewEnum");
            JIVariant Count = wbemObjectSet_dispatch.get("Count");
            this.count = Count.getObjectAsInt();
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
    }

    private void setInfo() throws WindowsException {
        try {
            this.processInfo = new String[this.count];
            IJIComObject comObj = this.variant.getObjectAsComObject();
            comObj.registerUnreferencedHandler(new IJIUnreferenced(){

                public void unReferenced() {
                }
            });
            IJIEnumVariant enumVARIANT = (IJIEnumVariant)((Object)JIObjectFactory.narrowObject(comObj.queryInterface("00020404-0000-0000-C000-000000000046")));
            for (int i = 0; i < this.count; ++i) {
                Object[] values = enumVARIANT.next(1);
                JIArray array = (JIArray)values[0];
                Object[] arrayObj = (Object[])array.getArrayInstance();
                for (int j = 0; j < arrayObj.length; ++j) {
                    IJIDispatch wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject(((JIVariant)arrayObj[j]).getObjectAsComObject());
                    JIVariant variant2 = wbemObject_dispatch.callMethodA("GetObjectText_", new Object[]{new Integer(1)})[0];
                    if (j != 0) continue;
                    this.processInfo[i] = variant2.getObjectAsString().getString();
                }
            }
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
    }

    private void killme() throws JIException {
        JISession.destroySession(this.session);
    }

    private boolean initialized() {
        return this.dispatch != null;
    }

    private boolean runWasAlreadyRun() {
        return this.variant != null;
    }
}

