/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster.windows.process;

import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import java.util.Collection;
import java.util.logging.Level;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsRemoteScripter {
    private final WindowsCredentials bonafides;
    private String outputStream = "StdOut";

    public WindowsRemoteScripter(WindowsCredentials bonafides) {
        this.bonafides = bonafides;
    }

    public final void wantStdErr() {
        this.outputStream = "StdErr";
    }

    public String run(Collection<String> cmdArgs) throws WindowsException {
        if (cmdArgs == null || cmdArgs.isEmpty()) {
            throw new IllegalArgumentException("Internal Error: No args to run");
        }
        StringBuilder sb = new StringBuilder();
        for (String s : cmdArgs) {
            sb.append(s).append(' ');
        }
        return this.run(sb.toString());
    }

    public String run(String cmd) throws WindowsException {
        if (cmd == null || cmd.isEmpty()) {
            throw new IllegalArgumentException("Internal Error: No args to run");
        }
        try {
            JISystem.getLogger().setLevel(Level.SEVERE);
            JISession session = JISession.createSession(this.bonafides.getDomain(), this.bonafides.getUser(), this.bonafides.getPassword());
            session.useSessionSecurity(true);
            JIComServer comStub = new JIComServer(JIProgId.valueOf("WScript.Shell"), this.bonafides.getHost(), session);
            IJIComObject unknown = comStub.createInstance();
            IJIComObject comobject = unknown.queryInterface("00020400-0000-0000-c000-000000000046");
            IJIDispatch shell = (IJIDispatch)JIObjectFactory.narrowObject(comobject);
            Object[] scriptArgs = new Object[]{new JIString("%comspec% /c " + cmd)};
            JIVariant[] results = shell.callMethodA("Exec", scriptArgs);
            IJIDispatch wbemObjectSet_dispatch = (IJIDispatch)JIObjectFactory.narrowObject(results[0].getObjectAsComObject());
            JIVariant stdOutJIVariant = wbemObjectSet_dispatch.get(this.outputStream);
            IJIDispatch stdOut = (IJIDispatch)JIObjectFactory.narrowObject(stdOutJIVariant.getObjectAsComObject());
            StringBuilder sb = new StringBuilder();
            while (!stdOut.get("AtEndOfStream").getObjectAsBoolean()) {
                sb.append(stdOut.callMethodA("ReadAll").getObjectAsString().getString());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new WindowsException(e.toString());
        }
    }
}

