/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster.windows.io;

import com.sun.enterprise.util.cluster.windows.io.Strings;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileCopyProgress;
import com.sun.enterprise.util.cluster.windows.io.WindowsRemoteFileSystem;
import com.sun.enterprise.util.cluster.windows.process.WindowsCredentials;
import com.sun.enterprise.util.cluster.windows.process.WindowsException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import jcifs.smb.SmbFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowsRemoteFile {
    private SmbFile smbFile;
    private WindowsRemoteFileSystem wrfs;
    private String smbPath;

    public WindowsRemoteFile(WindowsRemoteFile parent, String path) throws WindowsException {
        try {
            this.wrfs = parent.wrfs;
            this.smbPath = parent.smbPath + this.removeLeadingAndTrailingSlashes(path) + "/";
            this.smbFile = new SmbFile(this.smbPath, this.wrfs.getAuthorization());
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
    }

    public WindowsRemoteFile(WindowsCredentials bonafides, String path) throws WindowsException {
        this(new WindowsRemoteFileSystem(bonafides), path);
    }

    public WindowsRemoteFile(WindowsRemoteFileSystem wrfs, String path) throws WindowsException {
        try {
            if (wrfs == null || path == null || path.isEmpty()) {
                throw new NullPointerException();
            }
            if (path.indexOf(":") < 0) {
                throw new IllegalArgumentException("Non-absolute path.  No colon in the path");
            }
            this.wrfs = wrfs;
            path = path.replace('\\', '/').replace(':', '$');
            StringBuilder sb = new StringBuilder("smb://");
            sb.append(wrfs.getHost()).append("/").append(path);
            if (!path.endsWith("/")) {
                sb.append('/');
            }
            this.smbPath = sb.toString();
            this.smbFile = new SmbFile(this.smbPath, wrfs.getAuthorization());
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
    }

    public final boolean exists() throws WindowsException {
        try {
            return this.smbFile.exists();
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final String[] list() throws WindowsException {
        try {
            return this.smbFile.list();
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final void createNewFile() throws WindowsException {
        try {
            this.smbFile.createNewFile();
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final void copyTo(WindowsRemoteFile wf) throws WindowsException {
        try {
            this.smbFile.copyTo(wf.smbFile);
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final void copyTo(File file) throws WindowsException {
        this.copyTo(file, null);
    }

    public final void copyTo(File file, WindowsRemoteFileCopyProgress progress) throws WindowsException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            long filelength = this.smbFile.length();
            bis = new BufferedInputStream(this.smbFile.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buf = new byte[this.getChunkSize(progress, filelength)];
            int numBytes = 0;
            long totalBytesCopied = 0L;
            while ((numBytes = bis.read(buf)) >= 0) {
                ((BufferedOutputStream)bos).write(buf, 0, numBytes);
                totalBytesCopied += (long)numBytes;
                if (progress == null) continue;
                progress.callback(totalBytesCopied, filelength);
            }
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public final void delete() throws WindowsException {
        try {
            this.smbFile.delete();
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final void mkdirs() throws WindowsException {
        this.mkdirs(false);
    }

    public final void mkdirs(boolean force) throws WindowsException {
        try {
            if (this.exists()) {
                if (force) {
                    this.delete();
                } else {
                    throw new WindowsException(Strings.get("dir.already.exists", this.getPath()));
                }
            }
            this.smbFile.mkdirs();
        }
        catch (WindowsException we) {
            throw we;
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final void copyFrom(BufferedInputStream sin) throws WindowsException {
        this.copyFrom(sin, null, -1L);
    }

    private final void copyFrom(BufferedInputStream sin, WindowsRemoteFileCopyProgress progress, long filelength) throws WindowsException {
        OutputStream sout = null;
        if (sin == null) {
            throw new NullPointerException("copyFrom stream arg is null");
        }
        try {
            if (!this.exists()) {
                this.createNewFile();
            }
            sout = new BufferedOutputStream(this.smbFile.getOutputStream());
            byte[] buf = new byte[this.getChunkSize(progress, filelength)];
            int numBytes = 0;
            long totalBytesCopied = 0L;
            while ((numBytes = sin.read(buf)) >= 0) {
                sout.write(buf, 0, numBytes);
                totalBytesCopied += (long)numBytes;
                if (progress == null) continue;
                progress.callback(totalBytesCopied, filelength);
            }
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
        finally {
            try {
                sin.close();
            }
            catch (Exception e) {}
            try {
                sout.close();
            }
            catch (Exception e) {}
        }
    }

    public final void copyFrom(File from, WindowsRemoteFileCopyProgress progress) throws WindowsException {
        try {
            if (from == null || !from.isFile()) {
                throw new IllegalArgumentException("copyFrom file arg is bad: " + from);
            }
            long filesize = from.length();
            BufferedInputStream sin = new BufferedInputStream(new FileInputStream(from));
            this.copyFrom(sin, progress, filesize);
        }
        catch (WindowsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
    }

    public final void copyFrom(Collection<String> from) throws WindowsException {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("copyFrom String-array arg is empty");
        }
        StringBuilder sb = new StringBuilder();
        for (String s : from) {
            sb.append(s).append('\n');
        }
        this.copyFrom(sb.toString());
    }

    public final void copyFrom(String from) throws WindowsException {
        try {
            if (from == null || from.isEmpty()) {
                throw new IllegalArgumentException("copyFrom String arg is empty");
            }
            if (!this.exists()) {
                this.createNewFile();
            }
            PrintWriter pw = new PrintWriter(new BufferedOutputStream(this.smbFile.getOutputStream()));
            pw.print(from);
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw new WindowsException(e);
        }
    }

    public final void setLastModified(long when) throws WindowsException {
        try {
            this.smbFile.setLastModified(when);
        }
        catch (Exception se) {
            throw new WindowsException(se);
        }
    }

    public final String getPath() {
        return this.smbPath;
    }

    private String removeLeadingAndTrailingSlashes(String path) {
        while (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        while (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private int getChunkSize(WindowsRemoteFileCopyProgress progress, long filelength) {
        int chunksize;
        int n = chunksize = progress == null ? 0x100000 : progress.getChunkSize();
        if (filelength < Integer.MAX_VALUE && chunksize > (int)filelength && filelength > 0L) {
            return (int)filelength;
        }
        return chunksize;
    }
}

