/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.iiop;

import com.sun.corba.ee.impl.txpoa.TSIdentificationImpl;
import com.sun.corba.ee.spi.costransactions.TransactionService;
import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import com.sun.corba.ee.spi.logging.POASystemException;
import com.sun.corba.ee.spi.orbutil.closure.ClosureFactory;
import com.sun.enterprise.transaction.jts.iiop.TxIORInterceptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.jts.pi.InterceptorImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.Current;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="TransactionIIOPInterceptorFactory")
public class TransactionIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static Logger _logger = LogDomains.getLogger(InterceptorImpl.class, "javax.enterprise.system.core.transaction");
    private static StringManager localStrings = StringManager.getManager(InterceptorImpl.class);
    private static String jtsClassName = "com.sun.jts.CosTransactions.DefaultTransactionService";
    private static Properties jtsProperties = new Properties();
    private static TSIdentificationImpl tsIdent = new TSIdentificationImpl();
    private static boolean txServiceInitialized = false;
    private InterceptorImpl interceptor = null;
    @Inject
    private Habitat habitat;
    @Inject
    private ProcessEnvironment processEnv;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!txServiceInitialized) {
            this.createInterceptor(info, codec);
        }
        return this.interceptor;
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (!txServiceInitialized) {
            this.createInterceptor(info, codec);
        }
        return this.interceptor;
    }

    private void createInterceptor(ORBInitInfo info, Codec codec) {
        if (this.processEnv.getProcessType().isServer()) {
            try {
                System.setProperty("com.sun.jts.pi.CLIENT_POLICY_CHECKING", String.valueOf(false));
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "iiop.readproperty_exception", ex);
            }
            this.initJTSProperties(true);
        } else {
            this.initJTSProperties(false);
        }
        try {
            block11: {
                org.omg.PortableInterceptor.Current pic = (org.omg.PortableInterceptor.Current)info.resolve_initial_references("PICurrent");
                int[] slotIds = new int[]{info.allocate_slot_id(), info.allocate_slot_id()};
                this.interceptor = new InterceptorImpl(pic, codec, slotIds, null);
                com.sun.corba.ee.spi.orb.ORB theORB = ((ORBInitInfoExt)info).getORB();
                InterceptorImpl.setOrb((ORB)theORB);
                try {
                    Class<?> theJTSClass = Class.forName(jtsClassName);
                    if (theJTSClass == null) break block11;
                    try {
                        TransactionService jts = (TransactionService)theJTSClass.newInstance();
                        jts.identify_ORB((ORB)theORB, tsIdent, jtsProperties);
                        this.interceptor.setTSIdentification(tsIdent);
                        Current transactionCurrent = jts.get_current();
                        theORB.getLocalResolver().register("TransactionCurrent", ClosureFactory.makeConstant(transactionCurrent));
                        theORB.getLocalResolver().register("TSIdentification", ClosureFactory.makeConstant(tsIdent));
                        txServiceInitialized = true;
                    }
                    catch (Exception ex) {
                        throw new INITIALIZE("JTS Exception: " + ex, POASystemException.JTS_INIT_ERROR, CompletionStatus.COMPLETED_MAYBE);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    _logger.log(Level.SEVERE, "iiop.inittransactionservice_exception", cnfe);
                }
            }
            TxIORInterceptor iorInterceptor = new TxIORInterceptor(codec, this.habitat);
            info.add_ior_interceptor(iorInterceptor);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private void initJTSProperties(boolean isServer) {
        if (this.habitat != null) {
            jtsProperties = TransactionServiceProperties.getJTSProperties(this.habitat, true);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "++++ Server id: " + jtsProperties.getProperty("org.omg.CORBA.ORBServerId"));
            }
            if (isServer) {
                Configuration.setProperties(jtsProperties);
            }
        }
    }

    private boolean isValueSet(String value) {
        return value != null && !value.equals("") && !value.equals(" ");
    }
}

