/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.node.DisplayableComponentNode;
import com.sun.enterprise.deployment.node.MessageDestinationNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleNode<T extends RootDeploymentDescriptor>
extends DisplayableComponentNode<T>
implements RootXMLNode<T> {
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    protected static final String SCHEMA_LOCATION_TAG = "xsi:schemaLocation";
    protected String docType;
    private Map namespaceContext = null;

    @Override
    public void setDocType(String docType) {
        this.docType = docType;
        this.setSpecVersion();
    }

    public static Element appendChildNS(Node parent, String elementName, String nameSpace) {
        Element child = BundleNode.getOwnerDocument(parent).createElementNS(nameSpace, elementName);
        parent.appendChild(child);
        return child;
    }

    @Override
    protected Map getDispatchTable() {
        Map dispatchTable = super.getDispatchTable();
        dispatchTable.put("display-name", "setDisplayName");
        dispatchTable.put("version", "setSpecVersion");
        return dispatchTable;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if (SCHEMA_LOCATION_TAG.equals(element.getCompleteName())) {
            Object o;
            StringTokenizer st = new StringTokenizer(value);
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreElements()) {
                String schema;
                String namespace = (String)st.nextElement();
                if (st.hasMoreElements()) {
                    schema = (String)st.nextElement();
                } else {
                    schema = namespace;
                    namespace = "http://java.sun.com/xml/ns/javaee";
                }
                if (namespace.equals("http://java.sun.com/xml/ns/j2ee") || namespace.equals("http://java.sun.com/xml/ns/javaee") || namespace.equals(W3C_XML_SCHEMA)) continue;
                sb.append(namespace);
                sb.append(" ");
                sb.append(schema);
            }
            String clientSchemaLocation = sb.toString();
            if (clientSchemaLocation != null && clientSchemaLocation.length() != 0 && (o = this.getDescriptor()) instanceof RootDeploymentDescriptor) {
                ((RootDeploymentDescriptor)o).setSchemaLocation(clientSchemaLocation);
            }
        } else if (element.getQName().equals("metadata-complete")) {
            Object o = this.getDescriptor();
            if (o instanceof BundleDescriptor) {
                ((BundleDescriptor)o).setFullAttribute(value);
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, T descriptor) {
        Element bundleNode;
        if (this.getDocType() == null) {
            bundleNode = descriptor instanceof ConnectorDescriptor ? BundleNode.appendChildNS(parent, this.getXMLRootTag().getQName(), "http://java.sun.com/xml/ns/j2ee") : BundleNode.appendChildNS(parent, this.getXMLRootTag().getQName(), "http://java.sun.com/xml/ns/javaee");
            this.addBundleNodeAttributes(bundleNode, (RootDeploymentDescriptor)descriptor);
        } else {
            bundleNode = BundleNode.appendChild(parent, this.getXMLRootTag().getQName());
        }
        if (descriptor instanceof Application) {
            Application application = (Application)descriptor;
            BundleNode.appendTextChild((Node)bundleNode, "application-name", application.getAppName());
        } else {
            BundleNode.appendTextChild((Node)bundleNode, "module-name", ((RootDeploymentDescriptor)descriptor).getModuleDescriptor().getModuleName());
        }
        this.writeDisplayableComponentInfo(bundleNode, descriptor);
        return bundleNode;
    }

    protected void writeMessageDestinations(Node parentNode, Iterator msgDestinations) {
        if (msgDestinations == null || !msgDestinations.hasNext()) {
            return;
        }
        MessageDestinationNode subNode = new MessageDestinationNode();
        while (msgDestinations.hasNext()) {
            MessageDestinationDescriptor next = (MessageDestinationDescriptor)msgDestinations.next();
            subNode.writeDescriptor(parentNode, "message-destination", next);
        }
    }

    protected void addBundleNodeAttributes(Element bundleNode, RootDeploymentDescriptor descriptor) {
        BundleDescriptor bundleDesc;
        String schemaLocation;
        if (descriptor instanceof ConnectorDescriptor) {
            bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://java.sun.com/xml/ns/j2ee");
            schemaLocation = "http://java.sun.com/xml/ns/j2ee " + this.getSchemaURL();
        } else {
            bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://java.sun.com/xml/ns/javaee");
            schemaLocation = "http://java.sun.com/xml/ns/javaee " + this.getSchemaURL();
        }
        bundleNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", W3C_XML_SCHEMA_INSTANCE);
        this.addNamespaceDeclaration(bundleNode, descriptor);
        String clientSchemaLocation = descriptor.getSchemaLocation();
        if (clientSchemaLocation != null) {
            schemaLocation = schemaLocation + " " + clientSchemaLocation;
        }
        bundleNode.setAttributeNS(W3C_XML_SCHEMA_INSTANCE, SCHEMA_LOCATION_TAG, schemaLocation);
        bundleNode.setAttribute("version", this.getSpecVersion());
        if (descriptor instanceof BundleDescriptor && !(descriptor instanceof Application) && !(bundleDesc = (BundleDescriptor)descriptor).isDDWithNoAnnotationAllowed() && bundleDesc.getManagedBeans().size() <= 0) {
            bundleNode.setAttribute("metadata-complete", "true");
        }
    }

    @Override
    public void addPrefixMapping(String prefix, String uri) {
        if (uri.equals("http://java.sun.com/xml/ns/j2ee")) {
            return;
        }
        if (uri.equals("http://java.sun.com/xml/ns/javaee")) {
            return;
        }
        if (uri.equals(W3C_XML_SCHEMA_INSTANCE)) {
            return;
        }
        super.addPrefixMapping(prefix, uri);
    }

    protected String getSchemaURL() {
        return "http://java.sun.com/xml/ns/javaee/" + this.getSystemID();
    }

    protected void setSpecVersion() {
        if (this.docType == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.docType, "//");
        while (st.hasMoreElements()) {
            String tmp = st.nextToken();
            if (!tmp.startsWith("DTD")) continue;
            StringTokenizer versionST = new StringTokenizer(tmp);
            while (versionST.hasMoreElements()) {
                String versionStr = versionST.nextToken();
                try {
                    Float.valueOf(versionStr);
                    RootDeploymentDescriptor rdd = (RootDeploymentDescriptor)this.getDescriptor();
                    rdd.setSpecVersion(versionStr);
                    return;
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
    }
}

