/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.LocalDomainCommand;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.net.NetUtils;
import java.io.Console;
import java.io.IOException;
import java.net.ConnectException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="change-admin-password")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class ChangeAdminPasswordCommand
extends LocalDomainCommand {
    private ParameterMap params;
    private static final LocalStringsImpl strings = new LocalStringsImpl(ChangeAdminPasswordCommand.class);
    private static final String oldpwName = "AS_ADMIN_PASSWORD";
    private static final String newpwName = "AS_ADMIN_NEWPASSWORD";
    @Param(name="domain_name", optional=true)
    private String userArgDomainName;
    private SecureAdmin secureAdmin = null;

    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
        if (this.programOpts.getUser() == null) {
            Console cons = System.console();
            if (cons != null && this.programOpts.isInteractive()) {
                cons.printf("%s", strings.get("AdminUserDefaultPrompt", "admin"));
                String val = cons.readLine();
                if (ChangeAdminPasswordCommand.ok(val)) {
                    this.programOpts.setUser(val);
                } else {
                    this.programOpts.setUser("admin");
                }
            } else {
                throw new CommandValidationException(strings.get("AdminUserRequired"));
            }
        }
        try {
            String password = this.getPasswords();
            this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.USER);
        }
        catch (CommandValidationException cve) {
            throw new CommandException(cve);
        }
        this.params = new ParameterMap();
        this.params.set("DEFAULT", this.programOpts.getUser());
        this.params.set(oldpwName, this.passwords.get(oldpwName));
        this.params.set(newpwName, this.passwords.get(newpwName));
    }

    protected int executeCommand() throws CommandException {
        if (ChangeAdminPasswordCommand.ok(this.domainDirParam) || ChangeAdminPasswordCommand.ok(this.userArgDomainName)) {
            String domainDir = ChangeAdminPasswordCommand.ok(this.domainDirParam) ? this.domainDirParam : this.getDomainsDir().getPath();
            String domainName = ChangeAdminPasswordCommand.ok(this.userArgDomainName) ? this.userArgDomainName : this.getDomainName();
            return this.changeAdminPasswordLocally(domainDir, domainName);
        }
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand(this.name, this.programOpts.getHost(), this.programOpts.getPort(), this.programOpts.isSecure(), this.programOpts.getUser(), this.programOpts.getPassword(), logger);
            rac.executeCommand(this.params);
            return 0;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                if (!ChangeAdminPasswordCommand.isLocalHost(this.programOpts.getHost())) {
                    throw ce;
                }
                return this.changeAdminPasswordLocally(this.getDomainsDir().getPath(), this.getDomainName());
            }
            throw ce;
        }
    }

    private String getPasswords() throws CommandValidationException {
        String newpasswordAgain;
        String newpassword;
        String oldpassword = (String)this.passwords.get(oldpwName);
        if (oldpassword == null) {
            oldpassword = this.readPassword(strings.get("AdminPasswordPrompt"));
        }
        if ((newpassword = (String)this.passwords.get(newpwName)) == null && !(newpassword = this.readPassword(strings.get("AdminNewPasswordPrompt"))).equals(newpasswordAgain = this.readPassword(strings.get("AdminNewPasswordConfirmationPrompt")))) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", "Admin Password"));
        }
        this.passwords.put(oldpwName, oldpassword);
        this.passwords.put(newpwName, newpassword);
        return oldpassword;
    }

    private int changeAdminPasswordLocally(String domainDir, String domainName) throws CommandException {
        if (!ChangeAdminPasswordCommand.isLocalHost(this.programOpts.getHost())) {
            throw new CommandException(strings.get("CannotExecuteLocally"));
        }
        GFLauncher launcher = null;
        try {
            String newPassword;
            launcher = GFLauncherFactory.getInstance(RuntimeType.DAS);
            GFLauncherInfo info = launcher.getInfo();
            info.setDomainName(domainName);
            info.setDomainParentDir(domainDir);
            launcher.setup();
            if (launcher.isSecureAdminEnabled() && ((newPassword = (String)this.passwords.get(newpwName)) == null || newPassword.isEmpty())) {
                throw new CommandException(strings.get("NullNewPassword"));
            }
            String adminKeyFile = launcher.getAdminRealmKeyFile();
            if (adminKeyFile != null) {
                String[] groups;
                FileRealmHelper helper = new FileRealmHelper(adminKeyFile);
                if (helper.hasAuthenticatableUser() && (groups = helper.authenticate(this.programOpts.getUser(), ((String)this.passwords.get(oldpwName)).toCharArray())) == null) {
                    throw new CommandException(strings.get("InvalidCredentials", this.programOpts.getUser()));
                }
                helper.updateUser(this.programOpts.getUser(), this.programOpts.getUser(), ((String)this.passwords.get(newpwName)).toCharArray(), null);
                helper.persist();
                return 0;
            }
            throw new CommandException(strings.get("NotFileRealmCannotChangeLocally"));
        }
        catch (MiniXmlParserException ex) {
            throw new CommandException(ex);
        }
        catch (GFLauncherException ex) {
            throw new CommandException(ex);
        }
        catch (IOException ex) {
            throw new CommandException(ex);
        }
    }

    private static boolean isLocalHost(String host) {
        return host != null && (NetUtils.isThisHostLocal(host) || NetUtils.isLocal(host));
    }
}

